#ifdef GL_ES
precision mediump float;
precision mediump int;
#endif

#define PROCESSING_TEXTURE_SHADER

uniform float iGlobalTime;
uniform sampler2D texture;

varying vec4 vertColor;
varying vec4 vertTexCoord;

float rand(vec2 co)
{
    return fract(sin(dot(co.xy, vec2(12.9898,78.233)) + iGlobalTime) * 43758.5453);
}

void main()
{
	vec4 coord = vertTexCoord;
	
	float distance = coord.y - mod(iGlobalTime / 1000.0, 1.0);
	if (distance < 0.01 && distance > -0.01)
	{
		vec4 color = texture2D(texture, coord.xy);
		color += texture2D(texture, vec2(coord.x - (coord.y * 0.05 * sin(coord.y)), coord.y - (coord.x * 0.03 * sin(coord.x))));
		if (abs(distance) < 0.003)
			color *= rand(coord);
		gl_FragColor = color;
	}
	else
	{
		gl_FragColor = texture2D(texture, vec2(coord.xy));
	}
}
