import ddf.minim.spi.*;
import ddf.minim.signals.*;
import ddf.minim.*;
import ddf.minim.analysis.*;
import ddf.minim.ugens.*;
import ddf.minim.effects.*;

AudioPlayer player;
Minim minim;
FFT fft;

int INITIAL_TIME = 0;

int PARTICLE_COUNT = 10000;

PShader blockShader;
PShader offsetShader;
PShader warpShader;
PShader scanlineShader;
PShader sceneFadeShader;
PShader leftShadowFuzzShader;
PShader spacialShader;
PShader vhsShader;
PShader boxxxShader;
PShader noizeeShader;
PShader saturationShader;
int SHADERS_ENABLED = 1;

int currentTime;
PImage introImage;
PFont introFont;
PFont font;
String message;

float bassVolume;
float midVolume;
float trebleVolume;

Particle[] particles;

class Particle
{
  public float x;
  public float y;
  public float vx;
  public float vy;
  public float ax;
  public float ay;
  
  public Particle(float x, float y, float vx, float vy, float ax, float ay)
  {
    this.x = x;
    this.y = y;
    this.vx = vx;
    this.vy = vy;
    this.ax = ax;
    this.ay = ay;
  }
}

void _filter(PShader shader)
{
  if (SHADERS_ENABLED == 1)
    filter(shader);
}

void setupBlockShader()
{
  blockShader = loadShader("blocks.glsl");
  blockShader.set("iGlobalTime", float(currentTime));
}

void setupOffsetShader()
{
  offsetShader = loadShader("offset.glsl");
  offsetShader.set("offsetRX", 0.0);
  offsetShader.set("offsetRY", 0.0);
  offsetShader.set("offsetGX", 0.0);
  offsetShader.set("offsetGY", 0.0);
  offsetShader.set("offsetBX", 0.0);
  offsetShader.set("offsetBY", 0.0);
}

void setupWarpShader()
{
  warpShader = loadShader("warp.glsl");
}

void setupScanlineShader()
{
  scanlineShader = loadShader("scanlines.glsl");
}

void setupSceneFadeShader()
{
  sceneFadeShader = loadShader("scenefade.glsl");
  sceneFadeShader.set("iAmount", 0.0);
  sceneFadeShader.set("iGlobalTime", float(currentTime));
}

void setupLeftShadowFuzzShader()
{
  leftShadowFuzzShader = loadShader("leftshadowfuzz.glsl");
  leftShadowFuzzShader.set("iGlobalTime", float(currentTime));
}

void setupSpacialShader()
{
  spacialShader = loadShader("spacial.glsl");
  spacialShader.set("iGlobalTime", float(currentTime));
}

void setupVHSShader()
{
  vhsShader = loadShader("vhs.glsl");
  vhsShader.set("iGlobalTime", float(currentTime));
}

void setupBoxxxShader()
{
  boxxxShader = loadShader("boxxx.glsl");
  boxxxShader.set("iGlobalTime", float(currentTime));
}

void setupNoizeeShader()
{
  noizeeShader = loadShader("noizee.glsl");
  noizeeShader.set("iAmount", 0.0);
}

void setupSaturationShader()
{
  saturationShader = loadShader("saturation.glsl");
}

void setupShaders()
{
  setupBlockShader();
  setupOffsetShader();
  setupWarpShader();
  setupScanlineShader();
  setupSceneFadeShader();
  setupLeftShadowFuzzShader();
  setupSpacialShader();
  setupVHSShader();
  setupBoxxxShader();
  setupNoizeeShader();
  setupSaturationShader();
}

void setupFont()
{
  introFont = createFont("subotnik.ttf", 64);
  font = createFont("SourceCodePro-Regular.ttf", 96);
  textMode(MODEL);
}

void setupImages()
{
  introImage = loadImage("introframe.png");
}

void setupMusic()
{
  minim = new Minim(this);
  player = minim.loadFile("knoeki_take_control.mp3", 2048);
  player.cue(INITIAL_TIME);
  player.play();
  fft = new FFT(player.bufferSize(), player.sampleRate());
}

void setupScene2Particles()
{
  particles = new Particle[PARTICLE_COUNT];
  for (int i = 0; i < PARTICLE_COUNT; i++)
  {
    particles[i] = new Particle(random(0, 1279), random(0, 1023), random(-2.0, 2.0), random(-2.0, 2.0), 0.0, 0.0);
  }
}

void setup()
{
  size(1280, 1024, P3D);
  
  message = "< < < <        S U N D O W N    2 0 1 5    P R E S E N T S    . . . .   P O L Y N O M I A L ' S    F I R S T    E V E R    D E M O    ^___^    . . . .    [F][R][A][G][M][E][N][T][S]        //        CODE & GRAPHICS BY POLYNOMIAL -- MUSIC BY KNOEKI        GREETS TO...    DSS,  DEATHBOY,  /r/demoscene,  CREATIVE CODING COLLECTIVE,  REVISION FOLKS,  THE SUNDOWN CREW,  AND ALL YOU LOVELY PEOPLE !!!        > > > >";
  
  currentTime = millis();
  setupFont();
  setupImages();
  setupShaders();
  setupMusic();
  setupScene2Particles();
}

void updateShaderTimes()
{
  blockShader.set("iGlobalTime", float(currentTime));
  scanlineShader.set("iGlobalTime", float(currentTime));
  sceneFadeShader.set("iGlobalTime", float(currentTime));
  leftShadowFuzzShader.set("iGlobalTime", float(currentTime));
  spacialShader.set("iGlobalTime", float(currentTime));
  vhsShader.set("iGlobalTime", float(currentTime));
  boxxxShader.set("iGlobalTime", float(currentTime));
}

void updateBassVolume()
{
  bassVolume = 0.0;
  int bassChannelCount = fft.specSize() / 4;
  for (int i = 0; i < bassChannelCount; i++)
  {
    bassVolume += fft.getBand(i);
  }
  bassVolume /= bassChannelCount;
}

void updateMidVolume()
{
  midVolume = 0.0;
  int bottomChannel = fft.specSize() / 4;
  int midChannelCount = fft.specSize() / 2;
  for (int i = bottomChannel; i < bottomChannel + midChannelCount; i++)
  {
    midVolume += fft.getBand(i);
  }
  midVolume /= midChannelCount;
}

void updateTrebleVolume()
{
  trebleVolume = 0.0;
  int bottomChannel = int(float(fft.specSize()) * 0.75); 
  int trebleChannelCount = fft.specSize() / 4;
  for (int i = bottomChannel; i < bottomChannel + trebleChannelCount; i++)
  {
    trebleVolume += fft.getBand(i);
  }
  trebleVolume /= trebleChannelCount;
}

void updateAudio()
{
  // compute FFT and calculate frequency range volumes
  fft.forward(player.mix);
  
  updateBassVolume();
  updateMidVolume();
  updateTrebleVolume();
}

void drawScene0()
{
  background(0);
  textFont(introFont);
  
  int sceneTime = currentTime;
  
  /*
  text("+------------+", 360, 100);
  text("| polynomial |", 360, 200);
  text("+------------+", 360, 300);
  text("|  fragment  |", 360, 400);
  text("+------------+", 360, 500);
  text("| written in |", 360, 600);
  text("| processing |", 360, 700);
  text("+------------+", 360, 800);*/
  image(introImage, 0, 0);
  
  offsetShader.set("offsetRX", sin(float(sceneTime) / 950.0) / 220.0);
  offsetShader.set("offsetGY", sin(float(sceneTime) / 1333.0) / 245.0);
  offsetShader.set("offsetBX", sin(float(sceneTime) / 777.0) / 235.0);
  
  _filter(leftShadowFuzzShader);
  _filter(offsetShader);
  _filter(scanlineShader);
  _filter(spacialShader);
  _filter(vhsShader);
}

void drawScene1()
{
  background(15);
  textFont(font);
  
  int sceneTime = currentTime - 10000;
  
  // draw background grid
  for (int x = 0; x < 1500; x += 40)
  {
    for (int y = 160; y < 1200; y += 40)
    {
      if ((x + y) % 80 == 0)
        fill(20);
      else
        fill(10);
      rect(x - ((currentTime / 10) % 80), y, 40, 40);
    }
  }
  
  // compute three circle sizes
  float sizeA = 200 + (sin(float(sceneTime) / 300.0) * 20.0);
  float sizeB = 205 + (cos(float(sceneTime) / 285.0) * 18.0);
  float sizeC = 195 + (cos(float(sceneTime) / 292.0) * 23.0);
  
  // scale circles over time
  if (sceneTime < 5000)
    sizeB = 0;
  else
    sizeB *= min(float(sceneTime - 5000) / 1500.0, 1.0);
  
  if (sceneTime < 10000)
    sizeC = 0;
  else
    sizeC *= min(float(sceneTime - 10000) / 1500.0, 1.0);
  
  // compue circle positions
  float ax = 640 + (sin(float(sceneTime) / 700.0) * 384.0);
  float ay = 582 + (cos(float(sceneTime) / 700.0) * 256.0);
  float bx = 640 + (sin(float(sceneTime + 50) / 885.0) * 384.0);
  float by = 582 + (cos(float(sceneTime + 100) / 775.0) * 256.0);
  float cx = 640 + (sin(float(sceneTime + 72) / 645.0) * 384.0);
  float cy = 582 + (cos(float(sceneTime + 100) / 630.0) * 256.0);
  
  // draw circles
  fill(255);
  ellipse(ax, ay, sizeA, sizeA);
  ellipse(bx, by, sizeB, sizeB);
  ellipse(cx, cy, sizeC, sizeC);
  
  // after 15s, draw circle inners (black)
  if (sceneTime > 15000)
  {
    float innerScale = min(float(sceneTime - 15000) / 4000.0, 0.35);
    innerScale += min(bassVolume / 50.0, 0.28);
    fill(20);
    ellipse(ax, ay, sizeA * innerScale, sizeA * innerScale);
    ellipse(bx, by, sizeB * innerScale, sizeB * innerScale);
    ellipse(cx, cy, sizeC * innerScale, sizeC * innerScale);
  }
  
  // draw text scroller
  fill(255);
  for (int i = 0; i < message.length(); i++)
  {
    text(message.charAt(i), (i * 48) + 4500 - (float(sceneTime) / 1.8), 110 + (sin(float(sceneTime + (i * 10)) / 100.0) * 25.0));
  }
  fill(0);
  for (int i = 0; i < message.length(); i++)
  {
    text(message.charAt(i), (i * 48) + 4504 - (float(sceneTime) / 1.8), 111 + (sin(float(sceneTime + (i * 10)) / 100.0) * 25.0));
  }
  fill(255);
  for (int i = 0; i < message.length(); i++)
  {
    text(message.charAt(i), (i * 48) + 4508 - (float(sceneTime) / 1.8), 112 + (sin(float(sceneTime + (i * 10)) / 100.0) * 25.0));
  }
  
  // draw cutoff line below scroller
  int strokeColor = 255;
  float shiftScale = 0.5 + (sin(float(sceneTime) * 0.001 * 3.14159265 * 2.33333333333 * 2) * 0.4);
  for (int i = 0; i < 8; i++)
  {
    stroke(strokeColor);
    line(0, 160 - i, 1280, 160 - i);
    strokeColor = int(float(strokeColor) * shiftScale);
  }
  noStroke();
  
  // draw cube
  translate(640 + (sin(sceneTime / 400.0) * 256), 512);
  rotateY(float(sceneTime) / 200.0);
  rotateX(float(sceneTime) / 240.0);
  float boxSize = 192 + (sin(sceneTime / 200.0) * 32);
  if (sceneTime < 17000)
    boxSize = 0; // pre-17s we don't draw the cube
  else
    boxSize *= min(float(sceneTime - 17000) / 3000.0, 1.0);
  
  // after 31.5s enable strokes
  if (sceneTime > 31500 && sceneTime < 46000)
  {
    float innerScale = 1.0 - min(float(sceneTime - 31500) / 4000.0, 1.0);
    stroke(15 + int(240.0 * innerScale));
  }
  
  // draw the cube
  box(boxSize);
  
  fill(255);
  
  // apply shaders
  offsetShader.set("offsetRX", sin(float(sceneTime) / 950.0) / 120.0);
  offsetShader.set("offsetBY", sin(float(sceneTime) / 1333.0) / 145.0);
  _filter(blockShader);
  _filter(offsetShader);
  _filter(scanlineShader);
  /*_filter(spacialShader);*/ // <- here be dragons
  _filter(warpShader);
  
  // fade out at the end
  if (sceneTime > 42500)
  {
    float amount = min((sceneTime - 42500) / 1500.0, 1.0);
    sceneFadeShader.set("iAmount", amount);
  }
  _filter(sceneFadeShader);
}

void drawScene2()
{
  background(0);
  
  int sceneTime = currentTime - 54000;
  
  noStroke();
  fill(255);
  
  float impulsePosX = 0.0;
  float impulsePosY = 0.0;
  if (sceneTime < 10000)
  {
    impulsePosX = 640 + (sin(sceneTime / 314.0) * 640);
    impulsePosY = 512 + (cos(sceneTime / 314.0) * 512);
  }
  else if (sceneTime < 20000)
  {
    impulsePosX = (float(sceneTime - 10000) / 10000.0) * 1024.0;
    impulsePosY = 512;
  }
  else if (sceneTime < 30000)
  {
    impulsePosX = 640;
    impulsePosY = 512;
  }
  else
  {
    impulsePosX = 640;
    impulsePosY = 5000;
  }
  
  for (int i = 0; i < PARTICLE_COUNT; i++)
  {
    float ax = impulsePosX - particles[i].x;
    float ay = impulsePosY - particles[i].y;
    if (abs(ax) > abs(ay))
    {
      ay /= abs(ax);
      ax /= abs(ax); // 1.0 in the correct sign
    }
    else
    {
      ax /= abs(ay);
      ay /= abs(ay); // 1.0 in the correct sign
    }
    particles[i].ax = ax / 4.0;
    particles[i].ay = ay / 4.0;
    
    particles[i].vx += particles[i].ax;
    particles[i].vy += particles[i].ay;
    
    particles[i].x += particles[i].vx;
    particles[i].y += particles[i].vy;
    
    /*if (particles[i].x <= 0 || particles[i].x >= 1280)
      particles[i].vx = -particles[i].vx * 0.8;
    
    if (particles[i].y >= 1024 || particles[i].y <= 0)
      particles[i].vy = -particles[i].vy * 0.8;*/
    
    float intensity = 1.0 + abs(particles[i].vx) + abs(particles[i].vy);
    intensity *= bassVolume / 15.0;
    intensity = min(255, max(50, intensity * intensity));
    fill(intensity);
    ellipse(particles[i].x, particles[i].y, 3, 3);
  }
  
  // fadeout from scene 1
  if (sceneTime < 3000)
  {
    float amount = 1.0 - max(min(sceneTime / 1500.0, 1.0), 0.0);
    sceneFadeShader.set("iAmount", amount);
    _filter(sceneFadeShader);
  }
}

void drawScene3()
{
  int sceneTime = currentTime - 88000;
  
  background(0);
  
  stroke(255);
  fill(96 + (bassVolume * 16), 96 + (midVolume * 16), 96 + (trebleVolume * 16));
  
  translate(640, 512);
  rotateZ((PI / 180) * (sceneTime / 10));
  
  for (int z = 0; z < 10; z++)
  {
    translate(0, 0, -(z * 100));
    
    float distance = 80 + (sceneTime / 10);
    float size = 30 + (sceneTime / 40);
    
    for (int i = 0; i < 24; i++)
    {
      translate(- (distance + (i * 4)), 0);
      rotateX((PI / 180) * 5);
      box(size);
      rotateX((PI / 180) * -5);
      translate(distance + (i * 4), 0);
      rotateZ((PI / 180) * 30);
    }
  }
  
  stroke(255);
  float perStep = (PI / 180.0) * (360.0 / 128.0); 
  for (int k = 0; k < 128; k++)
  {
    float basePosX = sin((float(sceneTime) / 2000.0) + perStep * k);
    float basePosY = cos((float(sceneTime) / 2000.0) + perStep * k);
    line(0 + (basePosX * 80), 0 + (basePosY * 80), basePosX * 10 * (sceneTime / 20), basePosY * 10 * (sceneTime / 20));
  }
  
  /*fill(32, 32, 32);
  translate(-15, -10, 5000);
  text("BLACK", 0, 0);
  translate(0, 20);
  text("H0LE_", 0, 0);*/
  
  //_filter(leftShadowFuzzShader);
  _filter(boxxxShader);
  _filter(leftShadowFuzzShader);
}

void drawScene4()
{
  float sceneTime = currentTime - 139000;   
  
  stroke(255);
  strokeWeight(1.0);
  if (bassVolume > 4.0)
    strokeWeight(2.0);
  if (bassVolume > 8.0)
    strokeWeight(4.0);
  
  fill(0);
  
  float scale = 1.0 + (sin(sceneTime / 1000)) / 2.0;
  translate(-140, -100);
  
  beginShape();
  for (int i = 0; i < 128; i += 2)
  {
    vertex((1.0 + sin(i + scale)) * ((i*i)/(4 * scale)), (1.0 + cos(i + scale)) * ((i*i)/(4 * scale)));
  }
  endShape();
  
  offsetShader.set("offsetRX", sin(sceneTime / 1000.0) * 0.002);
  offsetShader.set("offsetRY", sin(sceneTime / 1010.0) * 0.002);
  offsetShader.set("offsetGX", sin(sceneTime / 1020.0) * 0.002);
  offsetShader.set("offsetGY", sin(sceneTime / 1030.0) * -0.002);
  offsetShader.set("offsetBX", sin(sceneTime / 1040.0) * -0.002);
  offsetShader.set("offsetBY", sin(sceneTime / 1050.0) * -0.002);
  _filter(offsetShader);
  
  float amount = abs(sin(sceneTime / 300.0));
  if (sceneTime > 15000)
    amount = 1.0;
  //amount = min(1.0, max(0.0, sceneTime / 20000)) + (1.0 - (amount / min(1.0, max(0.0, (sceneTime / 20000)))));
  noizeeShader.set("iAmount", amount);
  _filter(noizeeShader);
  
  // fade out at the end
  if (sceneTime > 28000)
  {
    float fadeAmount = min((sceneTime - 28000) / 1500.0, 1.0);
    sceneFadeShader.set("iAmount", fadeAmount);
  }
  _filter(sceneFadeShader);
}

void drawScene5()
{
  float sceneTime = currentTime - 168000;
  background(0);
  
  String msg = "SUNDOWN2015";
  
  textFont(introFont);
  
  for (int c = 0; c < msg.length(); c++)
  {
    int xp = 20 + (c * 110);
    for (int i = 0; i < 20; i++)
    {
      fill(55 + (i * 10));
      textSize(200 - (i * 4));
      float volHeight = 0.0;
      if (c < 4)
        volHeight += (bassVolume * 0.75);
      if (c >= 4 && c < 8)
        volHeight += (midVolume * 1.5);
      if (c >= 8)
        volHeight += (trebleVolume * 2.0);
      text(msg.charAt(c), xp, (512 - (volHeight * 5.0)) + (sin((currentTime + (c * 110)) / 300.0) * 10.0));
    }
    fill(255, 240, 0);
    text(msg.charAt(c), xp, 512 + (sin((currentTime + (c * 110)) / 300.0) * 10.0));
    text(msg.charAt(c), xp + 4, 512 + (sin((currentTime + (c * 110)) / 300.0) * 10.0));
    text(msg.charAt(c), xp - 4, 512 + (sin((currentTime + (c * 110)) / 300.0) * 10.0));
    text(msg.charAt(c), xp, 516 + (sin((currentTime + (c * 110)) / 300.0) * 10.0));
    text(msg.charAt(c), xp, 508 + (sin((currentTime + (c * 110)) / 300.0) * 10.0));
    fill(255, 255, 255);
    text(msg.charAt(c), xp, 512 + (sin((currentTime + (c * 110)) / 300.0) * 10.0));
  }
  
  _filter(blockShader);
  
  fill(255, 255, 255);
  textSize(40);
  text("<<< thank you for watching >>>", 230, 620);
  
  noizeeShader.set("iAmount", 0.2 + abs(sin(currentTime / 80.0) * 0.3));
  _filter(noizeeShader);
  _filter(vhsShader);
  _filter(saturationShader);
  
  // fadeout from scene 4
  if (sceneTime < 3000)
  {
    float amount = 1.0 - max(min(sceneTime / 1500.0, 1.0), 0.0);
    sceneFadeShader.set("iAmount", amount);
    _filter(sceneFadeShader);
  }
}

void draw()
{
  currentTime = millis() + INITIAL_TIME;
  
  updateShaderTimes();
  updateAudio();
  
  int TIMING_SCENE1 = 10000;
  int TIMING_SCENE2 = 54000;
  int TIMING_SCENE3 = 88000;
  int TIMING_SCENE4 = 139000;
  int TIMING_SCENE5 = 168000;
  
  if (currentTime < TIMING_SCENE1)
  {
    drawScene0();
  }
  if (currentTime >= TIMING_SCENE1 && currentTime < TIMING_SCENE2)
    drawScene1();
  if (currentTime >= TIMING_SCENE2 && currentTime < TIMING_SCENE3)
    drawScene2();
  if (currentTime >= TIMING_SCENE3 && currentTime < TIMING_SCENE4)
    drawScene3();
  if (currentTime >= TIMING_SCENE4 && currentTime < TIMING_SCENE5)
    drawScene4();
  if (currentTime >= TIMING_SCENE5)
    drawScene5();
}
