from math import sqrt

#10/1000/40/9999
#1/7/4/9999

TRACK_COST = 1
GRASS_COST = 7
BAD_COST = 4
DIAGONAL_COST = 9999

class AStar(object):
    def __init__(self, graph):
        self.graph = graph

    def reset(self):
        for key, value in self.graph.iteritems():
            for node in value:
                node.g = 0
                node.h = 0
                node.parent = None
        
    def heuristic(self, node, start, end):
        raise NotImplementedError
        
    def search(self, start, end, doNotUseSet):
        openset = set()
        closedset = set()
        current = start
        openset.add(current)
        while openset:
            current = min(openset, key=lambda o:o.g + o.h)
            if current == end:
                path = []
                while current.parent:
                    path.append(current)
                    current = current.parent
                path.append(current)
                self.reset()
                return path[::-1]
            openset.remove(current)
            closedset.add(current)

            for node in self.graph[current]:
                if node in closedset:# or node in doNotUseSet:
                    continue
                if node in openset:
                    new_g = current.g + current.move_cost(node)
                    if node.g > new_g:
                        node.g = new_g
                        node.parent = current
                else:
                    node.g = current.g + current.move_cost(node)
                    node.h = self.heuristic(node, start, end)
                    node.parent = current
                    openset.add(node)
        return None


class AStarNode(object):
    def __init__(self, g = 0, h = 0, parent = None):
        self.g = g
        self.h = h
        self.parent = parent

    def move_cost(self, other):
        raise NotImplementedError

    def up(self, other):
        return self.y - other.y == 1

    def left(self, other):
        return self.x - other.x == 1

    def diagonal(self, other):
        return abs(self.x - other.x) == 1 and abs(self.y - other.y) == 1

    def vertical(self, other):
        return abs(self.y - other.y) == 1

    def horizontal(self, other):
        return abs(self.x - other.x ) == 1

    def down(self, other):
        return self.y - other.y == -1

    def right(self, other):
        return self.x - other.x == -1

class AStarGrid(AStar):
    def heuristic(self, node, start, end):
        return sqrt((end.x - node.x) ** 2 + (end.y - node.y) ** 2)


class AStarGridNode(AStarNode):
    def __init__(self, x, y):
        self.x, self.y = x, y
        super(AStarGridNode, self).__init__()

    def move_cost(self, other):
        diagonal = abs(self.x - other.x) == 1 and abs(self.y - other.y) == 1
        return DIAGONAL_COST if diagonal else TRACK_COST


class GrassNode(AStarNode):
    def __init__(self, x, y):
        self.x, self.y = x, y
        super(GrassNode, self).__init__()

    def move_cost(self, other):
        diagonal = abs(self.x - other.x) == 1 and abs(self.y - other.y) == 1
        return DIAGONAL_COST if diagonal else GRASS_COST


# The following names derives from a clockwise reading

class HorizontalNode(AStarNode):  # -
    def __init__(self, x, y):
        self.x, self.y = x, y
        super(HorizontalNode, self).__init__()

    def move_cost(self, other):
        if self.diagonal(other):
            return DIAGONAL_COST
        elif self.vertical(other):
            return BAD_COST
        else:
            return TRACK_COST


class VerticalNode(AStarNode):  # |
    def __init__(self, x, y):
        self.x, self.y = x, y
        super(VerticalNode, self).__init__()

    def move_cost(self, other):
        if self.diagonal(other):
            return DIAGONAL_COST
        elif self.horizontal(other):
            return BAD_COST
        else:
            return TRACK_COST


class LeftDownNode(AStarNode):  # `
    def __init__(self, x, y):
        self.x, self.y = x, y
        super(LeftDownNode, self).__init__()

    def move_cost(self, other):
        if self.diagonal(other):
            return DIAGONAL_COST
        elif self.left(other) or self.down(other):
            return TRACK_COST
        else:
            return BAD_COST


class UpLeftNode(AStarNode):  # ,
    def __init__(self, x, y):
        self.x, self.y = x, y
        super(UpLeftNode, self).__init__()

    def move_cost(self, other):
        if self.diagonal(other):
            return DIAGONAL_COST
        elif self.up(other) or self.left(other):
            return TRACK_COST
        else:
            return BAD_COST


class RightUpNode(AStarNode):  # \
    def __init__(self, x, y):
        self.x, self.y = x, y
        super(RightUpNode, self).__init__()

    def move_cost(self, other):
        if self.diagonal(other):
            return DIAGONAL_COST
        elif self.right(other) or self.up(other):
            return TRACK_COST
        else:
            return BAD_COST


class DownRightNode(AStarNode):  # /
    def __init__(self, x, y):
        self.x, self.y = x, y
        super(DownRightNode, self).__init__()

    def move_cost(self, other):
        if self.diagonal(other):
            return DIAGONAL_COST
        elif self.down(other) or self.right(other):
            return TRACK_COST
        else:
            return BAD_COST

