import sys
sys.path.append("..")
from coord import Coord
import socket
import json
from datetime import datetime

import logging
logger = logging.getLogger(__name__)

NET_INPUT_UP = 1 << 0
NET_INPUT_DOWN = 1 << 1
NET_INPUT_LEFT = 1 << 2
NET_INPUT_RIGHT = 1 << 3
NET_INPUT_SPACE = 1 << 4
NET_INPUT_RETURN = 1 << 5


def insertBorder(arr, size_y, size_x):
    arr = arr
    temp_arr = [x[:] for x in [['.']*int(size_x+2)]*int(size_y+2)]
    print temp_arr

    for y in range(1, size_x+1):
        for x in range(1, size_y+1):
            print arr[y-1][x-1],
            temp_arr[y][x] = arr[y-1][x-1]
        print ""
    return temp_arr


def scale2(array, factor):
    c = lambda a: [x for x in a for j in range(0, factor)]
    d = lambda x, y: [x[i:i + y] for i in range(0, len(x), y)]
    return [x for i in array for x in d(c(i) * factor, len(array[0] * factor))]


def scale(arr, factor):
    tmp = []
    merge_tmp = []
    for i in arr:
        for j in range(0, len(i)):
            _tmp = []
            for x in range(0, factor):
                _tmp.append(i[j])
            tmp.append(_tmp)
    for i in xrange(0, len(tmp), len(arr[0])):
        for j in range(0, factor):
            supah_merge = []
            for x in range(0, len(arr[0])):
                supah_merge += tmp[i + x]
            merge_tmp.append(supah_merge)

    return merge_tmp


class GameConnector(object):
    handler_mapdata = None
    handler_ownposition = None
    handler_enemylist = None
    handler_updateself = None
    handler_commandrequest = None
    handler_bomblist = None
    handler_endround = None
    handler_dead = None
    factor = None

    sock = None
    ownName = None
    ownId = None
    mapSize = Coord(x=0, y=0)
    inputbuf = ""
    parse_start = True
    factor = None

    def __init__(self, ownName):
        dt = datetime.now()
        print dt.microsecond
        self.ownName = ownName

    def connect(self, host, port):
        print "Starting Connect"
        self.sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        try:
            self.sock.settimeout(0.04)
            self.sock.connect((host, port))
            self.sendLine(self.ownName)
            # self.sendLine(0xdeadbeef)
        except socket.error as e:
            logging.error(e)
            exit()

    def readPacket(self):
        try:
            self.inputbuf = self.sock.recv(4096)
        except socket.timeout as s_timout:
            pass
        except socket.error as s_error:
            logging.error(s_error)
            if s_error.errno == 10054:
                print "Disconnected..."
                exit()

            return None

        try:
            characters_to_read = self.inputbuf.index("\n")
            line = self.inputbuf[0:characters_to_read]  # removing the newline
            self.inputbuf = self.inputbuf[characters_to_read + 1:len(self.inputbuf)]
            return line
        except ValueError as f:
            # print "Can't FIND SHIT! %s" % (str(f))
            return None

    def parseJSONPacket(self, packet):
        if self.parse_start:
            self.ownId = packet['id']
            self.parse_start = False

        if 'id' in packet:
            self.ownId = packet['id']

        if 'map' in packet:
            if 'path' in packet['map']:
                for path in packet['map']['path']:
                    self.pathlist.append(Coord(x=path['tile_x'], y=path['tile_y']) )

            if 'tiles' in packet['map']:
                _map = packet['map']['tiles']
                r_x_map_size = len(_map[0])
                r_y_map_size = len(_map)
                r_size = Coord(x=r_x_map_size, y=r_y_map_size)

                x_map_size = len(_map[0] * self.factor)
                y_map_size = len(_map * self.factor)
                size = Coord(x=x_map_size, y=y_map_size)

                if self.factor > 1:
                    n_map = scale2(_map, self.factor)
                else:
                    n_map = _map

                self.handler_mapdata(size, n_map, r_size, _map)

            #self.sendLine(0xdeadbeef)
            self.sendLine(str(1 << 0))

        if 'cars' in packet:
            me = None
            enemies = []
            for cars in packet['cars']:
                if isinstance(cars, dict):
                    if cars['id'] == self.ownId:
                        me = cars
                else:
                    enemies.append(cars)

            self.handler_updateself(me, self.ownId)
            self.handler_enemylist(enemies)

            # Do the right thing
            cmd = self.handler_commandrequest()

            if cmd is not None:
                self.sendLine(cmd)

    def sendLine(self, line):
        self.previous_message = line
        if self.sock.sendall(str(line) + "\n\r") is not None:
            print("Error sending data!")

    def parsingLoop(self):
        try:
            while True:
                line = self.readPacket()

                if line is not None:
                    try:
                        packet = json.loads(line)
                    except ValueError as e:
                        print("Error decoding JSON packet: {0}\nJSON: {1}".format(e, line))
                    except AttributeError as e:
                        print("Invalid message: %s" % e)
                    else:
                        self.parseJSONPacket(packet)

        except KeyboardInterrupt:
            print "OK, I'm quitting!"
            exit()
            # except Exception as e:
            # pprint.pprint(e)
