import sys
from os import sep as pathsep
import traceback
sys.path.append("..")

from coord import Coord

import pygame
from pygame.locals import *


def center_image(image):
    """Sets an image's anchor point to its center"""
    image.anchor_x = image.width / 2
    image.anchor_y = image.height / 2


class MapWindow():
    tick = 0
    debug = False
    width = 1024
    height = 768
    black = 0, 0, 0
    stop = False

    def __init__(self, mapSize, tileSize, path, tiles, World, Players, Bot):
        self.World = World
        self.Players = Players
        self.tiles = tiles
        self.Bot = Bot
        pygame.font.init()
        try:
            self.init_pyglet()
            self.screen = pygame.display.set_mode((self.width, self.height),
                          pygame.DOUBLEBUF | pygame.HWSURFACE)
            while True:
                self.clock.tick(30)
                self.screen.fill(self.black)
                self.game_tick(self.clock)
                self.on_draw()
        except Exception as e:
            print e
            print traceback.print_exc()

    def draw_path(self):
        last_pos = Coord(x=0, y=0)
        print last_pos
        # pygame.draw.line(self.screen,
        #                  pygame.Color(255, 0, 255),
        #                  (p_x, p_y), (t_x, t_y))

    def draw_target(self):
        try:
            _id = self.Players.own_id
            p_x = self.Players.players[_id]["pos"].x
            p_y = self.Players.players[_id]["pos"].y

            t_x = self.World.targetCoord.x
            t_y = self.World.targetCoord.y
            pink = pygame.Color(255, 0, 255)
            pygame.draw.line(self.screen, pink, (p_x, p_y), (t_x, t_y))
        except:
            pass

    def update_world(self):
        x_offset = y_offset = 0
        for y in self.World.r_tiles:
            for x in y:
                self.screen.blit(self.mapFiles[x], (x_offset, y_offset))
                x_offset += 128
            y_offset += 128
            x_offset = 0

        x_it = i = 0
        x_offset = y_offset = 0
        w = h = 128 / self.Bot.factor
        col = pygame.Color(0, 0, 0)
        font = pygame.font.Font(None, 36)
        for y in self.World.tiles:
            for x in y:
                if x_it == 0:
                    text = font.render(i, 1, (10, 10, 10))
                    self.screen.blit(text, (x_offset + 10, y_offset + 10))
                pygame.draw.rect(self.screen, col,
                                 (x_offset, y_offset, w, h), 1)
                x_offset += 128 / self.Bot.factor
            y_offset += 128 / self.Bot.factor
            x_offset = 0
            x_it += 1

    def update_position(self):
        try:
            _id = self.Players.own_id
            p_x = self.Players.players[_id]["pos"].x
            p_y = self.Players.players[_id]["pos"].y
            self.screen.blit(self.car, (p_x, p_y))
        except:
            pass

    def game_tick(self, clock):
        # Move everything here
        self.tick += 1

        try:
            self.update_world()
            self.update_position()
            self.draw_target()
            self.draw_path()
            t_x = self.World.targetTile.x
            t_y = self.World.targetTile.y
            render_text = "TargetCoord: x=%d y=%d" % (t_x, t_y)
            font = pygame.font.Font(None, 36)
            text = font.render(render_text, 1, (10, 10, 10))
            self.screen.blit(text, (10, 40))
        except:
            pass

        global k_up, k_down, k_left, k_right, speed
        global position, rotated, rect, map_y

        for event in pygame.event.get():
            if not hasattr(event, 'key'):
                continue

            down = event.type == KEYDOWN

            print down

            if event.key == K_SPACE:
                if self.stop:
                    self.stop = False
                else:
                    self.stop = True

            if event.key == K_RIGHT:
                pass
            elif event.key == K_LEFT:
                pass
            elif event.key == K_UP:
                pass
            elif event.key == K_DOWN:
                pass
            elif event.key == K_ESCAPE:
                print "Escape pressed"
                sys.exit(0)

    def load_resources(self):
        li = pygame.image.load
        self.car = li("mapwindow_gfx" + pathsep + "car1.bmp")
        self.car.set_colorkey(pygame.Color(255, 0, 255))
        self.mapFiles = {
            "\\": li("mapwindow_gfx" + pathsep + "map-bottomleft.bmp"),
            r",": li("mapwindow_gfx" + pathsep + "map-bottomright.bmp"),
            r"/": li("mapwindow_gfx" + pathsep + "map-topleft.bmp"),
            r"`": li("mapwindow_gfx" + pathsep + "map-topright.bmp"),
            r"-": li("mapwindow_gfx" + pathsep + "map-horizontal.bmp"),
            r"|": li("mapwindow_gfx" + pathsep + "map-vertical.bmp"),
            r".": li("mapwindow_gfx" + pathsep + "map-none.bmp"),
            r"+": li("mapwindow_gfx" + pathsep + "map-xing.bmp"),
        }

    def init_pyglet(self):
        self.load_resources()
        self.clock = pygame.time.Clock()

    def on_draw(self):
        # draw things here
        if not self.stop:
            pygame.display.flip()

    def on_mouse_press(self, x, y, dx, dy):
        print "mouse press"

    def update(self, mapSize, tileSize, path, tiles):
        if self.debug:
            print "Updating world object. Size: {0}".format(mapSize)
        for a in path:
            print a
        if len(path):
            self.path = [Coord(x=tile['tile_x'],
                         y=tile['tile_y']) for tile in path]
        self.mapSize = mapSize
        self.tileSize = tileSize
        self.tiles = [[square for square in row] for row in tiles]

if __name__ == '__main__':
    window = MapWindow(Coord(x=0, y=0), [], Coord(x=0, y=0), [], None)
