﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Interop;

namespace UserControl
{
	class Program
	{
		static void Main(string[] args)
		{
			var interop = new Interop.InteropService("Fuseren", -1, "127.0.0.1", 31337);
			interop.Send(0);

			while (true)
			{
				var gameState = interop.QueryForState<GameState>().Result;
				interop.Send(GetCommand());
			}
		}

		static byte GetCommand()
		{
			byte cmd = 0;
			if ((GetAsyncKeyState(Keys.Left) & 0x80000000) != 0)
			{
				cmd |= 1 << 2;
			}
			if ((GetAsyncKeyState(Keys.Right) & 0x80000000) != 0)
			{
				cmd |= 1 << 3;
			}
			if ((GetAsyncKeyState(Keys.Up) & 0x80000000) != 0)
			{
				cmd |= 1 << 0;
			}
			if ((GetAsyncKeyState(Keys.Down) & 0x80000000) != 0)
			{
				cmd |= 1 << 1;
			}
			if ((GetAsyncKeyState(Keys.Space) & 0x80000000) != 0)
			{
				cmd |= 1 << 5;
			}

			return cmd;
		}

		[DllImport("user32.dll")]
		static extern short GetAsyncKeyState(Keys vKey); 
	}
}
