/*
 * Decompiled with CFR 0.152.
 */
package artificialstupidity;

import Structures.Car;
import Structures.Map;
import Structures.Modifier;
import Structures.Node;
import Structures.VectorF2D;
import java.util.ArrayList;
import java.util.List;

public class AStar {
    private Map map;

    public AStar(Map map) {
        this.map = map;
    }

    private List<Node> GetPath(Node start, Node goal) {
        int firstTile = 1;
        int lastTile = this.map.map_height * this.map.map_width;
        boolean goal_reached = false;
        Node currentNode = null;
        ArrayList<Node> NodeArray = new ArrayList<Node>();
        List<Node> openList = new ArrayList<Node>();
        ArrayList<Node> closedList = new ArrayList<Node>();
        closedList.add(start);
        currentNode = start;
        if (currentNode.equals(goal)) {
            return null;
        }
        while (!goal_reached) {
            Node north = new Node(currentNode.GetX(), currentNode.GetY() - 1, currentNode, currentNode.GetG() + 10, this.map.map_width);
            Node south = new Node(currentNode.GetX(), currentNode.GetY() + 1, currentNode, currentNode.GetG() + 10, this.map.map_width);
            Node west = new Node(currentNode.GetX() - 1, currentNode.GetY(), currentNode, currentNode.GetG() + 10, this.map.map_width);
            Node east = new Node(currentNode.GetX() + 1, currentNode.GetY(), currentNode, currentNode.GetG() + 10, this.map.map_width);
            north.SetH(Math.abs(goal.GetX() - north.GetX()) + Math.abs(goal.GetY() - north.GetY()));
            east.SetH(Math.abs(goal.GetX() - east.GetX()) + Math.abs(goal.GetY() - east.GetY()));
            west.SetH(Math.abs(goal.GetX() - west.GetX()) + Math.abs(goal.GetY() - west.GetY()));
            south.SetH(Math.abs(goal.GetX() - south.GetX()) + Math.abs(goal.GetY() - south.GetY()));
            NodeArray.add(north);
            NodeArray.add(east);
            NodeArray.add(west);
            NodeArray.add(south);
            for (int i = 0; i < NodeArray.size(); ++i) {
                int PosX = ((Node)NodeArray.get(i)).GetY();
                int PosY = ((Node)NodeArray.get(i)).GetX();
                if (PosX < 0 || PosY < 0) {
                    NodeArray.remove(i);
                }
                Node tempNode = (Node)NodeArray.get(i);
                NodeArray.remove(i);
                NodeArray.add(i, this.IsWalkable(tempNode));
                boolean walkable = ((Node)NodeArray.get((int)i)).walkable;
                boolean inClosedList = this.contains(closedList, (Node)NodeArray.get(i));
                if (((Node)NodeArray.get(i)).GetID() >= lastTile || ((Node)NodeArray.get(i)).GetID() <= firstTile || !walkable || inClosedList) continue;
                if (this.contains(openList, (Node)NodeArray.get(i))) {
                    if (((Node)NodeArray.get(i)).GetG() >= this.GetNode(openList, (Node)NodeArray.get(i)).GetG()) continue;
                    openList = this.RemoveNode((Node)NodeArray.get(i), openList);
                    openList.add((Node)NodeArray.get(i));
                    continue;
                }
                openList.add((Node)NodeArray.get(i));
            }
            NodeArray.clear();
            currentNode = this.GetLowestF(openList);
            closedList.add(currentNode);
            openList.remove(currentNode);
            if (currentNode == null) {
                return null;
            }
            if (!currentNode.equals(goal)) continue;
            goal_reached = true;
        }
        List<Node> Path = this.ReverseParents(currentNode);
        ArrayList<Node> returnPath = new ArrayList<Node>();
        for (int i = 0; i < Path.size(); ++i) {
            returnPath.add(Path.get(Path.size() - i - 1));
        }
        return returnPath;
    }

    private List<Node> ReverseParents(Node node) {
        ArrayList<Node> Path = new ArrayList<Node>();
        while (node != null) {
            Path.add(node);
            node = node.GetParent();
        }
        if (Path.size() > 1) {
            Path.remove(Path.size() - 1);
        }
        return Path;
    }

    private Node IsWalkable(Node node) {
        try {
            char terrain = this.map.GetTerrain(node.GetX(), node.GetY());
            switch (terrain) {
                case '.': {
                    node.SetH(node.GetH() + 36);
                    node.walkable = true;
                    return node;
                }
                case '/': {
                    node.SetH(node.GetH() + 13);
                    node.corner = true;
                    node.walkable = true;
                    return node;
                }
                case '-': {
                    node.SetH(node.GetH() + 10);
                    node.walkable = true;
                    return node;
                }
                case '|': {
                    node.SetH(node.GetH() + 10);
                    node.walkable = true;
                    return node;
                }
                case '`': {
                    node.SetH(node.GetH() + 13);
                    node.corner = true;
                    node.walkable = true;
                    return node;
                }
                case '\\': {
                    node.SetH(node.GetH() + 13);
                    node.corner = true;
                    node.walkable = true;
                    return node;
                }
                case ',': {
                    node.SetH(node.GetH() + 13);
                    node.corner = true;
                    node.walkable = true;
                    return node;
                }
                case '+': {
                    node.SetH(node.GetH() + 12);
                    node.corner = true;
                    node.walkable = true;
                    return node;
                }
            }
            return node;
        }
        catch (Exception e) {
            System.out.println("Exception in IsWalkable!");
            return node;
        }
    }

    public boolean Intersects(VectorF2D boxA, VectorF2D boxB, VectorF2D sizeA, VectorF2D sizeB) {
        return boxA.x < boxB.x + sizeB.x && boxA.x + sizeA.x > boxB.x && boxA.y < boxB.y + sizeB.y && sizeA.y + boxA.y > boxB.y;
    }

    public List<Node> GetFullPath(List<Node> checkpoints, Node start, Car local_car) {
        ArrayList<Node> full_path = new ArrayList<Node>();
        Node currentNode = start;
        for (int i = 0; i < checkpoints.size(); ++i) {
            List<Node> sub_path = this.GetPath(currentNode, checkpoints.get(i));
            if (sub_path == null) continue;
            for (Node checkpoint : sub_path) {
                full_path.add(checkpoint);
            }
            currentNode = (Node)full_path.get(full_path.size() - 1);
            currentNode.SetParent(null);
            sub_path.clear();
        }
        if (!currentNode.equals(start)) {
            List<Node> sub_path = this.GetPath(currentNode, start);
            for (Node checkpoint : sub_path) {
                full_path.add(checkpoint);
            }
            currentNode = (Node)full_path.get(full_path.size() - 1);
            currentNode.SetParent(null);
            sub_path.clear();
        }
        for (Modifier mod : this.map.modifiers) {
            VectorF2D modPos = new VectorF2D(mod.x, mod.y);
            VectorF2D modSize = new VectorF2D(mod.width, mod.height);
            boolean avoid = true;
            if (mod.type.equals("booster")) {
                avoid = false;
            }
            for (int i = 0; i < full_path.size(); ++i) {
                Node thisNode = (Node)full_path.get(i);
                Node nextNode = null;
                Node lastNode = null;
                VectorF2D tileSize = new VectorF2D(this.map.tile_width, this.map.tile_height);
                VectorF2D tilePos = new VectorF2D(thisNode.pos.x * tileSize.x, thisNode.pos.y * tileSize.y);
                nextNode = i + 1 < full_path.size() ? (Node)full_path.get(i + 1) : (Node)full_path.get(0);
                lastNode = i - 1 > 0 ? (Node)full_path.get(i - 1) : (Node)full_path.get(full_path.size() - 1);
                if (this.Intersects(tilePos, modPos, tileSize, modSize)) {
                    float left = (float)mod.x - thisNode.pos.x * tileSize.x;
                    float right = (thisNode.pos.x + 1.0f) * tileSize.x - (float)(mod.x + mod.width);
                    float up = (float)mod.y - thisNode.pos.y * tileSize.y;
                    float down = (thisNode.pos.y + 1.0f) * tileSize.y - (float)(mod.y + mod.height);
                    float last_next_diffX = nextNode.GetX() - lastNode.GetX();
                    float last_next_diffY = nextNode.GetY() - lastNode.GetY();
                    if (Math.abs(thisNode.GetX() - nextNode.GetX()) > 0) {
                        if (down > (float)local_car.height) {
                            if (avoid) {
                                thisNode.Adjust(0.0f, (tileSize.y - down + down / 2.0f) / tileSize.y);
                                lastNode.Adjust(0.0f, (tileSize.y - down + down / 3.0f) / tileSize.y);
                                nextNode.Adjust(0.0f, (tileSize.y - down + down / 3.0f) / tileSize.y);
                            } else {
                                thisNode.Adjust(0.0f, (tileSize.y - down - (float)(mod.height / 2)) / tileSize.y);
                                lastNode.Adjust(0.0f, (tileSize.y - down - (float)(mod.height / 3)) / tileSize.y);
                                nextNode.Adjust(0.0f, (tileSize.y - down - (float)(mod.height / 3)) / tileSize.y);
                            }
                        }
                        if (up > (float)local_car.height) {
                            if (avoid) {
                                thisNode.Adjust(0.0f, up / 2.0f / tileSize.y);
                                lastNode.Adjust(0.0f, up / 3.0f / tileSize.y);
                                nextNode.Adjust(0.0f, up / 3.0f / tileSize.y);
                            } else {
                                thisNode.Adjust(0.0f, (tileSize.y + up + (float)(mod.height / 2)) / tileSize.y);
                                lastNode.Adjust(0.0f, (tileSize.y + up + (float)(mod.height / 3)) / tileSize.y);
                                nextNode.Adjust(0.0f, (tileSize.y + up + (float)(mod.height / 3)) / tileSize.y);
                            }
                        }
                    }
                    if (Math.abs(thisNode.GetY() - nextNode.GetY()) > 0) {
                        if (right > (float)local_car.width) {
                            if (avoid) {
                                thisNode.Adjust((tileSize.x - right + right / 2.0f) / tileSize.x, 0.0f);
                                lastNode.Adjust((tileSize.x - right + right / 3.0f) / tileSize.x, 0.0f);
                                nextNode.Adjust((tileSize.x - right + right / 3.0f) / tileSize.x, 0.0f);
                            } else {
                                thisNode.Adjust((tileSize.x - right - (float)(mod.width / 2)) / tileSize.x, 0.0f);
                                lastNode.Adjust((tileSize.x - right - (float)(mod.width / 3)) / tileSize.x, 0.0f);
                                nextNode.Adjust((tileSize.x - right - (float)(mod.width / 3)) / tileSize.x, 0.0f);
                            }
                        } else if (left > (float)local_car.width) {
                            if (avoid) {
                                thisNode.Adjust(left / 2.0f / tileSize.x, 0.5f);
                                lastNode.Adjust(left / 3.0f / tileSize.x, 0.0f);
                                nextNode.Adjust(left / 3.0f / tileSize.x, 0.0f);
                            } else {
                                thisNode.Adjust((tileSize.x + left + (float)(mod.width / 2)) / tileSize.x, 0.0f);
                                lastNode.Adjust((tileSize.x + left + (float)(mod.width / 3)) / tileSize.x, 0.0f);
                                nextNode.Adjust((tileSize.x + left + (float)(mod.width / 3)) / tileSize.x, 0.0f);
                            }
                        }
                    }
                }
                if (i + 1 < full_path.size()) {
                    full_path.remove(i + 1);
                    full_path.add(i + 1, nextNode);
                }
                if (i - 1 > 0) {
                    full_path.remove(i - 1);
                    full_path.add(i - 1, lastNode);
                }
                full_path.remove(i);
                full_path.add(i, thisNode);
            }
        }
        for (Node node : full_path) {
            if (node.adjustedx && node.adjustedy) continue;
            node.Adjust(0.5f, 0.5f);
        }
        return full_path;
    }

    private boolean contains(List<Node> nodeList, Node target) {
        for (int i = 0; i < nodeList.size(); ++i) {
            if (!target.equals(nodeList.get(i))) continue;
            return true;
        }
        return false;
    }

    private Node GetNode(List<Node> list, Node target) {
        for (int i = 0; i < list.size(); ++i) {
            if (!target.equals(list.get(i))) continue;
            return list.get(i);
        }
        return null;
    }

    private List<Node> RemoveNode(Node target, List<Node> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (!target.equals(list.get(i))) continue;
            list.remove(i);
        }
        return list;
    }

    private Node GetLowestF(List<Node> NodeArray) {
        int F = Integer.MAX_VALUE;
        Node retNode = null;
        for (int i = 0; i < NodeArray.size(); ++i) {
            if (NodeArray.get(i).GetF() >= F) continue;
            retNode = NodeArray.get(i);
            F = retNode.GetF();
        }
        return retNode;
    }
}

