#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h> 
#include <string>
#include <iostream>
#include <algorithm>
#include <cmath>
#include <ctime>
#include <time.h>
#include <vector>

using namespace std;

struct modifier {
	int x;
	int y;
	int width;
	int height;
	bool boost;
	bool mud;
};

struct cords {
	int x;
	int y;
};

struct fcords {
	float x;
	float y;
};
	

void error(const char *msg)
{
    perror(msg);
    exit(0);
}

//fast string to int
//based on source&benchmarks: http://tinodidriksen.com/2010/02/16/cpp-convert-string-to-int-speed/
int string_to_int(string thestring) {
	const char *p=thestring.c_str();
    int x = 0;
    bool neg = false;
    if (*p == '-') {
        neg = true;
        ++p;
    }
    while (*p >= '0' && *p <= '9') {
        x = (x*10) + (*p - '0');
        ++p;
    }
    if (neg) {
        x = -x;
    }
    return x;
}

string substring_till(string stringdummy, string target)
{	
	return stringdummy.substr(0,stringdummy.find(target));
}

bool noboost(cords postocheck, modifier *modifiers, int numberofmodifiers, int tile_width, int tile_height)
{
   	for( int i = 0 ; i < numberofmodifiers ; i++ )
	{
		if (modifiers[i].boost)
		{
			if( postocheck.x*tile_width<modifiers[i].x && (postocheck.x+1)*tile_width>modifiers[i].x &&
			    postocheck.y*tile_height<modifiers[i].y && (postocheck.y+1)*tile_height>modifiers[i].y)
			    {
			    	return false;
				}
		}			
	}
	return true;			
}                 

string cut_string_at(string stringdummy, string target, int additional)
{
	int pos=stringdummy.find(target)+target.length()+2+additional;
	stringdummy=stringdummy.substr(pos,stringdummy.length()-pos);
	return stringdummy;
}                 

int substring_to_int(string stringdummy, string endat)
{
	return string_to_int(stringdummy.substr(0,stringdummy.find(endat)));
}                                                                                                                                                                                                                                              

void countroutetiled(string **map, int **actionmap,int actioncount, int i, int j, int rows, int columns, bool fastway)
{
	int dummyactionmap;
	if (i>=0 && j>=0 && i<rows && j<columns && actionmap[i][j]>=0)
	{
		if(map[i][j]!=".") 
		{
			if(fastway)
			{
				dummyactionmap=actioncount+1; 
			}
			else
			{
				dummyactionmap=actioncount+2; 
			}
		}
		else 
		{
			dummyactionmap=actioncount+5;
		}
		
		if(dummyactionmap<actionmap[i][j] || actionmap[i][j]==0)
		{
			actionmap[i][j]=dummyactionmap;
		}
	}
}

int findwayback(int **actionmap,int actioncount, int i, int j, int rows, int columns)
{
	int value=0;
	if (i>=0 && j>=0 && i<rows && j<columns)
	{
		if(0<actionmap[i][j] && actionmap[i][j]<actioncount) 
		{
			value=actionmap[i][j];
		}
		else	 
		{
			value=actioncount;
		}
	}
	return value;
}

bool fastway(int y, int x, string source)
{
	if(x>0)
	{
		return (source=="/" || source=="-" || source=="\\" || source=="+");
	
	}
	else if(x<0)
	{
		return (source=="-" || source=="`" || source=="," || source=="+");
	
	}
	else if(y>0)
	{
		return(source=="|" || source=="/" || source=="`" || source=="+");
	
	}
	else if(y<0)
	{
		return(source=="|" || source=="," || source=="\\" || source=="+");
	
	}
	else 
	{
		return false;
	
	}
}

int findroute(string **map, int **actionmap, cords start, cords target, int rows, int columns,vector<cords> *path)
{
	bool found=false;
	actionmap[start.y][start.x]=1;
 	if(path->size()>=2)
	{
		if(path->at(path->size()-2).x != start.x || path->at(path->size()-2).y != start.y)
		{
			actionmap[path->at(path->size()-2).y][path->at(path->size()-2).x]=-1;
		}
		
	}
	int actioncount=1;
	do
	{
	   	for( int i = 0 ; i < rows ; i++ )
   		{
			for( int j = 0 ; j < columns ; j++ )
			{
				if (actionmap[i][j]==actioncount)
				{
					if (i==target.y && j==target.x)
					{
						found = true;
					}
					else
					{	
						countroutetiled(map,actionmap, actioncount, i-1, j  , rows, columns,fastway(-1, 0, map[i][j]));
						countroutetiled(map,actionmap, actioncount, i  , j+1, rows, columns,fastway( 0,+1, map[i][j]));
						countroutetiled(map,actionmap, actioncount, i+1, j  , rows, columns,fastway(+1, 0, map[i][j]));
						countroutetiled(map,actionmap, actioncount, i  , j-1, rows, columns,fastway( 0,-1, map[i][j]));
					}
				}
			}
		}
		actioncount++;
	}
	while(!found);
	found=false;	
	int pos =path->size();
	path->insert(path->begin()+pos,target);
	int value;
	int dactioncount;
	cords dummytarget;
	int di,dj,i,j;
	i=target.y;
	j=target.x;
	while(!found)
	{	
		bool goodfound=false;
		di=i-1;dj=j  ; dactioncount=findwayback(actionmap,actioncount, di, dj, rows, columns); 
						if(dactioncount>0 && (dactioncount<actioncount || (!goodfound && map[di][dj]!=".")))
						{
							if(actionmap[di][dj]<=actioncount)
							{
								dummytarget.x=dj;
								dummytarget.y=di;
								if(map[i][j]=="|" || map[i][j]=="\\" || map[i][j]=="," || map[i][j]=="+")
								{
									goodfound=true;
								}
								actioncount=dactioncount;
							}
							
						}
		di=i  ;dj=j+1; dactioncount=findwayback(actionmap,actioncount, di, dj, rows, columns); 
						if(dactioncount>0 && (dactioncount<actioncount || (!goodfound && map[di][dj]!=".")))
						{
							if(actionmap[di][dj]<=actioncount)
							{
								dummytarget.x=dj;
								dummytarget.y=di;
								if(map[i][j]=="-" || map[i][j]=="/" || map[i][j]=="\\" || map[i][j]=="+")
								{
									goodfound=true;
								}
								actioncount=dactioncount;
							}
						}
		di=i+1;dj=j  ; dactioncount=findwayback(actionmap,actioncount, di, dj, rows, columns); 
						if(dactioncount>0 && (dactioncount<actioncount || (!goodfound && map[di][dj]!=".")))
						{
							if(actionmap[di][dj]<=actioncount)
							{
								dummytarget.x=dj;
								dummytarget.y=di;
								if(map[i][j]=="|" || map[i][j]=="/" || map[i][j]=="`" || map[i][j]=="+")
								{
									goodfound=true;
								}
								actioncount=dactioncount;
							}
						}
		di=i  ;dj=j-1; dactioncount=findwayback(actionmap,actioncount, di, dj, rows, columns); 
						if(dactioncount>0 && (dactioncount<actioncount || (!goodfound && map[di][dj]!=".")))
						{
							if(actionmap[di][dj]<=actioncount)
							{
								dummytarget.x=dj;
								dummytarget.y=di;
								if(map[i][j]=="-" || map[i][j]=="`" || map[i][j]=="," || map[i][j]=="+")
								{
									goodfound=true;
								}
								actioncount=dactioncount;
							}
						}
		i=dummytarget.y;
		j=dummytarget.x;
		if(path->at(pos-1).x==dummytarget.x && path->at(pos-1).y==dummytarget.y)
		{
			found=true;
			return actioncount-1;
		}
		else
		{	
			path->insert(path->begin()+pos,dummytarget);
		}
	}			
	return actioncount-1;
}

int main()
{
    int sockfd, portno, n;
    struct sockaddr_in serv_addr;
    struct hostent *server;
    char buffer[256],command[256];
    portno = 31337;
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) 
        error("ERROR opening socket");
    server = gethostbyname("127.0.0.1");
    if (server == NULL) {
        exit(0);
    }
    bzero((char *) &serv_addr, sizeof(serv_addr));
    serv_addr.sin_family = AF_INET;
    bcopy((char *)server->h_addr, 
         (char *)&serv_addr.sin_addr.s_addr,
         server->h_length);
    serv_addr.sin_port = htons(portno);
    bool connected;
    if (connect(sockfd,(struct sockaddr *) &serv_addr,sizeof(serv_addr)) < 0) 
        error("ERROR connecting");
    else
    	connected=true;
	bzero(buffer,256);
	buffer[0]='s';
	buffer[1]='h';
	buffer[2]='a';
	buffer[3]='d';
	buffer[4]='\n';
	n = write(sockfd,buffer,strlen(buffer));
	if (n < 0) 
	     error("ERROR writing to socket");
    string gameinfo="";
    do
    {
	    bzero(buffer,256);
	    n = read(sockfd,buffer,255);
	    if (n < 0) 
	         error("ERROR reading from socket");
	    gameinfo=gameinfo+buffer;
	}
    while(n==255);
  	int pos;
	string stringdummy=gameinfo;
	int myid = string_to_int(stringdummy.substr(6,1));
	int Cars = string_to_int(stringdummy.substr(19,1));
	stringdummy=cut_string_at(stringdummy,"tile_width",0);
	int tile_width = substring_to_int(stringdummy,",");
	stringdummy=cut_string_at(stringdummy,"tile_height",0);
	int tile_height = substring_to_int(stringdummy,",");
	pos=stringdummy.find("tiles");
	stringdummy=stringdummy.substr(pos+8,stringdummy.length()-(pos+8));
	pos=stringdummy.find("]]")+1;
	string string_map=stringdummy.substr(0,pos);
	int rows=count(string_map.begin(),string_map.end(),'[');
	int columns=count(string_map.begin(),string_map.end(),',');
	columns=(columns-(rows-1))/rows+1; //fixed
	string **map = 0;
	map = new string *[rows] ;
	for( int i = 0 ; i < rows ; i++ )
		map[i] = new string[columns];
	int i=0,j=0;
    while(string_map.length()>1)
    {   
    	if (string_map.substr(0,1)=="\"")
    	{
    		map[j][i]=string_map.substr(1,1);
    		string_map=string_map.substr(1,string_map.length()-1);
			pos = string_map.find("\"");
    		string_map=string_map.substr(pos+1,string_map.length()-pos+1);
 			i++;
 			if (i>=columns)
 			{
 				i=0;
 				j++;
 			}
 		}
 		else
 		{
 			string_map=string_map.substr(1,string_map.length()-1);
 		}
    }
	stringdummy=cut_string_at(stringdummy,"modifiers",0);
	string string_modifiers = stringdummy.substr(0,stringdummy.find("]"));
	int numberofmodifiers = count(string_modifiers.begin(),string_modifiers.end(),'}');
   	modifier modifiers[numberofmodifiers];
	for( int i = 0 ; i < numberofmodifiers ; i++ )
	{
		string_modifiers=cut_string_at(string_modifiers,"type",1);
	    string modifier = substring_till(string_modifiers,"\"");
	    modifiers[i].boost=(modifier == "booster");
	    modifiers[i].mud=(modifier == "mud");// || modifier == "ice");
   	    string_modifiers=cut_string_at(string_modifiers,"x",0);
	    modifiers[i].x=substring_to_int(string_modifiers,",");
   	    string_modifiers=cut_string_at(string_modifiers,"y",0);
		modifiers[i].y=substring_to_int(string_modifiers,",");
   	    string_modifiers=cut_string_at(string_modifiers,"width",0);
		modifiers[i].width=substring_to_int(string_modifiers,",");
	    string_modifiers=cut_string_at(string_modifiers,"height",0);
		modifiers[i].height=substring_to_int(string_modifiers,"}");
		if(	map[modifiers[i].y/tile_height][modifiers[i].x/tile_width]=="/" ||
			map[modifiers[i].y/tile_height][modifiers[i].x/tile_width]=="`" ||
			map[modifiers[i].y/tile_height][modifiers[i].x/tile_width]=="," ||
			map[modifiers[i].y/tile_height][modifiers[i].x/tile_width]=="\\")
		{
			modifiers[i].boost=false;
		}	
    }
	stringdummy=cut_string_at(stringdummy,"path",0);
	int numberofcheckpoints = count(stringdummy.begin(),stringdummy.end(),'}')-2;
   	cords pseudopath[numberofcheckpoints+1];
	for( int i = 0 ; i < numberofcheckpoints ; i++ )
	{
		stringdummy=cut_string_at(stringdummy,"tile_x",0);
	    pseudopath[i].x=substring_to_int(stringdummy,",");
   	    stringdummy=cut_string_at(stringdummy,"tile_y",0);
		pseudopath[i].y=substring_to_int(stringdummy,"}");
    }
    pseudopath[numberofcheckpoints]=pseudopath[0];
	bool done;
   	vector<cords> path(1);
	path[0]=pseudopath[0];
	for( int i = 0 ; i < numberofcheckpoints ; i++ )
	{
		if(abs(pseudopath[i].x-pseudopath[i+1].x) + abs(pseudopath[i].y-pseudopath[i+1].y) == 1 && 
			(path[path.size()-1].x != pseudopath[i].x  ||	   path[path.size()-1].y != pseudopath[i].y))
		{
				path.push_back(pseudopath[i]);
		}
		else
		{
			int **actionmap = 0;
			actionmap = new int *[rows];
			for( int i = 0 ; i < rows ; i++ )
				actionmap[i] = new int[columns];
			for( int i = 0 ; i < rows ; i++ )
   			{
				for( int j = 0 ; j < columns ; j++ )
				{
					actionmap[i][j]=0;
				}
			}
			findroute(map, actionmap,pseudopath[i], pseudopath[i+1], rows, columns, &path);
			}         
	}
	numberofcheckpoints=path.size();
	int maxlength=0;
	int dummylength=0;
	cords max_length_cords=path[0];
	cords dummy_max_length_cords=path[0];
	int check_x=path[0].x;
	for( int i = 1 ; i < numberofcheckpoints ; i++ )
	{
		if(check_x==path[i].x && noboost(path[i],modifiers,numberofmodifiers, tile_width, tile_height))
		{
			dummylength=dummylength+1;
			if (dummylength>maxlength)
			{
				maxlength=dummylength;
				max_length_cords=dummy_max_length_cords;
			}	
		}
		else
		{
			dummylength=0;
			check_x=path[i].x;
			dummy_max_length_cords=path[i];
		}
	}
	dummylength=0;
	int check_y=path[0].y;
	dummy_max_length_cords=path[0];
	for( int i = 1 ; i < numberofcheckpoints ; i++ )
	{
		if(check_y==path[i].y && noboost(path[i],modifiers,numberofmodifiers, tile_width, tile_height))
		{
			dummylength=dummylength+1;
			if (dummylength>maxlength)
			{
				maxlength=dummylength;
				max_length_cords=dummy_max_length_cords;
			}	
		}
		else
		{
			dummylength=0;
			check_y=path[i].y;
			dummy_max_length_cords=path[i];
		}
	}
	clock_t begin = clock();
	bzero(buffer,256);
	buffer[0]='3';
	buffer[1]='2';
	buffer[2]='\n';
	n = write(sockfd,buffer,strlen(buffer));
	if (n < 0) 
	     error("ERROR writing to socket");
	int mypathcp=0;
	int count_=0;
	srand(time(NULL));
	int max_straight=0;
    while(connected)
    {
	    string gameinfo="";
	    do
	    {
		    bzero(buffer,256);
		    n = read(sockfd,buffer,255);
		    if (n < 0) 
		         error("ERROR reading from socket");
		    gameinfo=gameinfo+buffer;
		}
	    while(n==255 && buffer[254]!='\n');	   
		string stringdummy=gameinfo;
		for(i=0;i<myid;i++)
		{		
			stringdummy=cut_string_at(stringdummy,"id\":",10);
		}
		int pos=stringdummy.find("direction");
		stringdummy=stringdummy.substr(pos+16,stringdummy.length()-(pos+16));
		fcords direction;
		pos=stringdummy.find(",");
		string string_direction_x=stringdummy.substr(0,pos);
		direction.x=atof(string_direction_x.c_str());		
		pos=stringdummy.find(":");
		string string_direction_y = stringdummy.substr(pos+1,stringdummy.find("}")-(pos+1));
		direction.y=atof(string_direction_y.c_str());
		fcords v_velo;
		stringdummy=cut_string_at(stringdummy,"velocity",0);
		stringdummy=cut_string_at(stringdummy,"x",0);
	    v_velo.x=substring_to_int(stringdummy,",");
		stringdummy=cut_string_at(stringdummy,"y",0);
	    v_velo.y=substring_to_int(stringdummy,",");
		int speed = sqrt(v_velo.x*v_velo.x+v_velo.y*v_velo.y);
		pos=stringdummy.find("pos");
		stringdummy=stringdummy.substr(pos+10,stringdummy.length()-pos-10);
		pos=stringdummy.find(",");
		string string_pos_x=stringdummy.substr(0,pos);
		pos=stringdummy.find(":");
		string string_pos_y = stringdummy.substr(pos+1,stringdummy.find("}")-(pos+1));
		cords mycords;
		mycords.x=string_to_int(string_pos_x);
		mycords.y=string_to_int(string_pos_y);
		stringdummy=cut_string_at(stringdummy,"width",0);
		int car_width=substring_to_int(stringdummy,",");
		stringdummy=cut_string_at(stringdummy,"height",0);
	    int car_height=substring_to_int(stringdummy,",");
		cords mytile;
		mytile.x=mycords.x/tile_width;
		mytile.y=mycords.y/tile_height;
		stringdummy=cut_string_at(stringdummy,"powerup",1);
	    string powerup=substring_till(stringdummy,"\"");
	    stringdummy=cut_string_at(stringdummy,"boxes",1);
	    string boxstring=substring_till(stringdummy,"]");
	    int nrofboxes=count(boxstring.begin(),boxstring.end(),'{');
		cords boxes[nrofboxes];
	   	for( int i = 0 ; i < nrofboxes ; i++ )
		{
			boxstring=cut_string_at(boxstring,"x",0);
		    boxes[i].x=substring_to_int(boxstring,",");
   		    boxstring=cut_string_at(boxstring,"y",0);
			boxes[i].y=substring_to_int(boxstring,",");
			boxstring=cut_string_at(boxstring,"width",0);
			boxes[i].x+=substring_to_int(boxstring,",")/2;
			boxstring=cut_string_at(boxstring,"height",0);
			boxes[i].y+=substring_to_int(boxstring,",")/2;
    	}     
	    int nextpathcp=mypathcp+1;
	    if (nextpathcp>=numberofcheckpoints)
	    {
	    	nextpathcp=0;
	    }
	    if (path[nextpathcp].x==mytile.x && path[nextpathcp].y==mytile.y)
	    	{
	    		mypathcp=nextpathcp; 
	    		nextpathcp=mypathcp+1;
	   	 		if (nextpathcp>=numberofcheckpoints)
	    		{
	    			nextpathcp=0;
	    		}
	    	}
	    bool targetfound=false;
	    bool curvefound=false;
		int maybenexttarget=0;
	    int nexttarget=nextpathcp;
		fcords target;
	    cords mud;
	    for( int i = 0 ; i < numberofmodifiers ; i++ )
		{
   	 		if (modifiers[i].mud)
			{
				mud.x=modifiers[i].x+modifiers[i].width/2;
				mud.y=modifiers[i].y+modifiers[i].height/2;
				if( path[mypathcp].x*tile_width<mud.x && (path[mypathcp].x+1)*tile_width>mud.x &&
				    path[mypathcp].y*tile_height<mud.y && (path[mypathcp].y+1)*tile_height>mud.y)
				{ 
					targetfound=true;
						if(path[nexttarget].x == path[mypathcp].x)
						{  
							if(path[mypathcp].y > path[nexttarget].y)
							{
								target.y=modifiers[i].y;
								if (mycords.y <= modifiers[i].y)
								{
									targetfound=false;
								}
							}
							else
							{
								target.y=modifiers[i].y+modifiers[i].height;
								if (mycords.y >= modifiers[i].y+modifiers[i].height)
								{
									targetfound=false;
								}
							}
							if(mud.x-path[mypathcp].x*tile_width<tile_width/2)
							{
								target.x=modifiers[i].x+modifiers[i].width+car_width/2;    
							}
							else
							{
								target.x=modifiers[i].x-car_width/2;    
							}							
						}
						else
						{  
							if(path[mypathcp].x > path[nexttarget].x)
							{
								target.x=modifiers[i].x;
								if (mycords.x <= modifiers[i].x)
								{
									targetfound=false;
								}
							}
							else
							{
								target.x=modifiers[i].x+modifiers[i].width;
								if (mycords.x >= modifiers[i].x+modifiers[i].width)
								{
									targetfound=false;
								}
							}
							if(mud.y-path[mypathcp].y*tile_height<tile_height/2)
							{
								target.y=modifiers[i].y+modifiers[i].height+car_height/2;    
							}
							else
							{
								target.y=modifiers[i].y-car_height/2;    
							}							
						}
						if (2*abs(mycords.x-target.x) > car_width && 2*abs(mycords.y - target.y)>car_height)
						{
							targetfound=false;    
						}							
				}
			}	
		}		
    	while(!targetfound && !curvefound)
	    {
		    for( int i = 0 ; i < nrofboxes ; i++ )
			{
	   	 		if( path[nexttarget].x*tile_width<boxes[i].x && (path[nexttarget].x+1)*tile_width>boxes[i].x &&
					path[nexttarget].y*tile_height<boxes[i].y && (path[nexttarget].y+1)*tile_height>boxes[i].y)
				{    
						targetfound=true;
						target.x=boxes[i].x;
						target.y=boxes[i].y;
				}	
    		}

		    cords boost,mud;
		    for( int i = 0 ; i < numberofmodifiers ; i++ )
			{
	   	 		if (modifiers[i].mud)
				{
					mud.x=modifiers[i].x+modifiers[i].width/2;
					mud.y=modifiers[i].y+modifiers[i].height/2;
					if( path[nexttarget].x*tile_width<mud.x && (path[nexttarget].x+1)*tile_width>mud.x &&
					    path[nexttarget].y*tile_height<mud.y && (path[nexttarget].y+1)*tile_height>mud.y)
					{    
						targetfound=true;
						if(path[nexttarget].x == path[mypathcp].x)
						{  
							if(modifiers[i].y> mycords.y)
							{
								target.y=modifiers[i].y-car_height/2;
							}
							else
							{
								target.y=modifiers[i].y+modifiers[i].height+car_height/2;
								if (target.y>tile_height*path[nexttarget].y+1)
								{
									target.y=tile_height*path[nexttarget].y+1;
								}
							}
							if(mud.x-path[nexttarget].x*tile_width<tile_width/2)
							{
								target.x=modifiers[i].x+modifiers[i].width+car_width/2;    
							}
							else
							{
								target.x=modifiers[i].x-car_width/2;    
							}							
						}
						else
						{  
							if(modifiers[i].x> mycords.x)
							{
								target.x=modifiers[i].x-car_height/2;
							}
							else
							{
								target.x=modifiers[i].x+modifiers[i].width+car_height/2;
								if (target.x>tile_width*path[nexttarget].x+1)
								{
									target.x=tile_width*path[nexttarget].x+1;
								}
							}
							if(mud.y-path[nexttarget].y*tile_height<tile_height/2)
							{
								target.y=modifiers[i].y+modifiers[i].height+car_height/2;    
							}
							else
							{
								target.y=modifiers[i].y-car_height/2;    
							}							
						}
						
					}
				}
				else
				{
		   	 		if (modifiers[i].boost)
					{
						boost.x=modifiers[i].x+modifiers[i].width/2;
						boost.y=modifiers[i].y+modifiers[i].height/2;
						if( path[nexttarget].x*tile_width<boost.x && (path[nexttarget].x+1)*tile_width>boost.x &&
						    path[nexttarget].y*tile_height<boost.y && (path[nexttarget].y+1)*tile_height>boost.y)
						{    
							targetfound=true;
							target.x=boost.x;
							target.y=boost.y;
						}
					}
				}	
    		}
    		if(!targetfound)
    		{
				maybenexttarget=nexttarget+1;
				if (maybenexttarget>=numberofcheckpoints)
				{	
					maybenexttarget=0;
				}
    			if((mytile.x == path[nextpathcp].x && mytile.x == path[maybenexttarget].x &&
    					((mytile.y > path[nextpathcp].y && mytile.y > path[maybenexttarget].y) ||
    					 (mytile.y < path[nextpathcp].y && mytile.y < path[maybenexttarget].y))) ||
	   	 			(mytile.y == path[nextpathcp].y && mytile.y == path[maybenexttarget].y &&
    					((mytile.x > path[nextpathcp].x && mytile.x > path[maybenexttarget].x) ||
    					 (mytile.x < path[nextpathcp].x && mytile.x < path[maybenexttarget].x))))
	   	 		{
	   	 			nexttarget=maybenexttarget;
	   	 		}	
	   	 		else
	   	 		{	
	   	 			curvefound=true;
	   	 		}	
    		}
    	}
		fcords way;
		if (curvefound)
		{
			int curvetarget=nexttarget+1;
			if (curvetarget>=numberofcheckpoints)
			{
				curvetarget=0;
			}
			cords curvecorrection;
			curvecorrection.x=tile_width/2;
			curvecorrection.y=tile_height/2;
			int carsize=car_width;
			if (carsize<car_height)
			{
				carsize=car_height;
			}
			if (path[curvetarget].x>path[nexttarget].x)
			{
				curvecorrection.x=curvecorrection.x+tile_width/2-carsize;//-
				curvecorrection.y=curvecorrection.y+tile_height/2-carsize;//-
			}
			else if (path[curvetarget].x<path[nexttarget].x)
			{
				curvecorrection.x=curvecorrection.x-tile_width/2+carsize;//+
				curvecorrection.y=curvecorrection.y-tile_height/2+carsize;//+
			}
			else if (path[curvetarget].y>path[nexttarget].y)
			{
				curvecorrection.x=curvecorrection.x-tile_width/2+carsize;//+
				curvecorrection.y=curvecorrection.y+tile_height/2-carsize;//-
			}
			else if (path[curvetarget].y<path[nexttarget].y)
			{
				curvecorrection.x=curvecorrection.x+tile_width/2-carsize;//-
				curvecorrection.y=curvecorrection.y-tile_height/2+carsize;//+
			}
			target.x = (path[nexttarget].x*tile_width+curvecorrection.x);
			target.y = (path[nexttarget].y*tile_height+curvecorrection.y);
		}
		way.x=target.x-mycords.x;
		way.y=target.y-mycords.y;
	    fcords targetvector;
	    float waylength=way.x*way.x+way.y*way.y;
	    targetvector.x=way.x/sqrt(waylength);
	    targetvector.y=way.y/sqrt(waylength);
	    float phi = acos
	    			(direction.x*targetvector.x+direction.y*targetvector.y)/
	    		 	(sqrt(direction.x*direction.x+direction.y*direction.y) *
	    			 sqrt(targetvector.x*targetvector.x+targetvector.y*targetvector.y))/M_PI*180;
	    bzero(buffer,256);
		int command = 0;
		cout << "SPEED: " << speed << "\n";
		int minspeed=30;
		if (speed > 200*(tile_width+tile_height)/(128+128)-2*phi)
		{
	    	command=command+16;
	    	if(speed<minspeed)
	    		command=command+1;
	    }
	    else if(phi<66 || speed<minspeed)
	    {
		    command=command+1;
	    }	    	    
	    bool fire=false;
	    if (phi > 1)
	    {
	    	float lr = direction.x*targetvector.y-direction.y*targetvector.x;
			if(lr<0)
			{
				command=command+4;
			}    	
			else
			{
				command=command+8;
			}
			if (speed > 100 && speed < 150)
			{
				if (powerup =="redshell")
			    {
		 		   	fire=true;
			    }
			    else if (powerup =="blueshell")
			    {
		    		fire=true;
			    }
			    else if (powerup =="greenshell")
			    {
		    		fire=true;
			    }
			}
			if (powerup =="lightning")
			{
		   		fire=true;
		  	}
	    }
	    int dummymypathcp=mypathcp-1;
	    if (dummymypathcp<0)
	    {
	    	dummymypathcp=0;
	    }
	    if (phi < 5 && ((max_length_cords.x==path[mypathcp].x && max_length_cords.y==path[mypathcp].y) ||
	   					(max_length_cords.x==path[dummymypathcp].x && max_length_cords.y==path[dummymypathcp].y)))
	    {
	    	if (powerup =="bigmushroom" || powerup =="mushroom" || powerup =="star")
	    	{
	    			fire=true;
	    	}
	    }
		if (powerup =="banana")
	    {
	    	fire=true;
	    }
	    else if (powerup =="oil")
	    {
	    	fire=true;
	    }
		if (fire) command =command+32;	    	    	    	    
		sprintf(buffer, "%d", command);	    	    	    
	    int length=1;
	    while(command/10>0)
	    {
	    	length++;
	    	command=command/10;
	    }
	    buffer[length]='\n';
	    n = write(sockfd,buffer,strlen(buffer));
	    if (n < 0) 
	         error("ERROR writing to socket");
	    clock_t end = clock();
	    double elapsed_secs = double(end-begin)/CLOCKS_PER_SEC*5.41;
	    count_++;
    }
    close(sockfd);
    return 0;
}