package com.petterroea.kartering;

import com.petterroea.kartering.Shell.ShellType;
import com.petterroea.kartering.math.FloatVect;

public class Item {
	public enum ItemType{
		UNKNOWN,
		OIL
	}
	private ItemType type;
	private FloatVect position, size;
	public Item(ItemType type, FloatVect position, FloatVect size)
	{
		this.type = type;
		this.size = size;
		this.position = position;
	}
	public Item(String type, FloatVect position, FloatVect size)
	{
		if(type.equals("oil")) {
			this.type = ItemType.OIL;
		} else {
			System.out.println("UNKNOWN ITEM TYPE: " + type);
		}
		this.size = size;
		this.position = position;
	}
	public ItemType getType()
	{
		return type;
	}
	public FloatVect getPosition()
	{
		return position;
	}
	public FloatVect getSize()
	{
		return size;
	}
}
