package com.petterroea.kartering;

import com.petterroea.kartering.math.*;

public class Modifier {
	public enum ModifierType {
		UNKNOWN,
		MUD,
		BOOSTER,
		ICE
	}
	private FloatVect position, size;
	private ModifierType type;
	public Modifier(ModifierType type, FloatVect position, FloatVect size)
	{
		this.type = type;
		this.position = position;
		this.size = size;
	}
	public Modifier(String type, FloatVect position, FloatVect size)
	{
		if(type.equals("mud")) {
			this.type = ModifierType.MUD;
		} else if(type.equals("booster")) {
			this.type = ModifierType.BOOSTER;
		} else if(type.equals("ice")) {
			this.type = ModifierType.ICE;
		} else {
			this.type = ModifierType.UNKNOWN;
			System.out.println("Got unknown modifier type: " + type);
		}
		this.position = position;
		this.size = size;
	}
	public FloatVect getPosition()
	{
		return position;
	}
	public FloatVect getSize()
	{
		return size;
	}
	
}
