package com.petterroea.neural;

import java.util.LinkedList;

public class RoundNode implements INode{
	INode in = null;
	LinkedList<INode> outputs = new LinkedList<INode>();
	private boolean hasSimulated = false;
	private float value = 0.0f;
	@Override
	public boolean canConnectInput() {
		// TODO Auto-generated method stub
		return in == null;
	}

	@Override
	public void connectInput(INode n) {
		if(in == null) {
			in = n;
		}
	}

	@Override
	public void disconnectInput(INode n) {
		if(n.equals(in)) {
			in = null;
		}
	}

	@Override
	public int getNeededInputs() {
		// TODO Auto-generated method stub
		return in == null ? 1 : 0;
	}

	@Override
	public boolean canSimulate() {
		return in != null && in.hasSimulated() && !hasSimulated();
	}

	@Override
	public void simulate() {
		if(canSimulate())
		{
			value = Math.round(in.getOutput());
			hasSimulated = true;
			for(INode outputNode : outputs) {
				if(outputNode.canSimulate()) {
					outputNode.simulate();
				}
			}
		}
	}

	@Override
	public boolean hasSimulated() {
		// TODO Auto-generated method stub
		return hasSimulated;
	}

	@Override
	public void connectOutput(INode n) {
		outputs.add(n);
	}

	@Override
	public boolean canConnectOutput() {
		return true;
	}

	@Override
	public void disconnectOutput(INode n) {
		outputs.remove(n);
	}

	@Override
	public float getOutput() {
		return value;
	}

	@Override
	public int getNeededOutputs() {
		return outputs.size() > 0 ? 0 : 1;
	}

	@Override
	public void reset() {
		hasSimulated = false;
	}

}
