package com.petterroea.neural;

import java.util.LinkedList;

public class SubtractionNode implements INode{
	private LinkedList<INode> inputs = new LinkedList<INode>();
	private LinkedList<INode> outputs = new LinkedList<INode>();
	private boolean hasSimulated = false;
	private float value = 0.0f;
	@Override
	public boolean canConnectInput() {
		// TODO Auto-generated method stub
		return inputs.size() < 2;
	}

	@Override
	public void connectInput(INode n) {
		if(inputs.size()<2) {
			inputs.add(n);
		}
	}

	@Override
	public void disconnectInput(INode n) {
		inputs.remove(n);
	}

	@Override
	public int getNeededInputs() {
		// TODO Auto-generated method stub
		return 2-inputs.size();
	}

	@Override
	public boolean canSimulate() {
		for(INode node : inputs)
		{
			if(!node.hasSimulated())
				return false;
		}
		return inputs.size()==2 && !hasSimulated();
	}

	@Override
	public void simulate() {
		if(canSimulate())
		{
			value = inputs.get(0).getOutput() - inputs.get(1).getOutput();
			hasSimulated = true;
			for(INode outputNode : outputs) {
				if(outputNode.canSimulate()) {
					outputNode.simulate();
				}
			}
		}
	}

	@Override
	public boolean hasSimulated() {
		// TODO Auto-generated method stub
		return hasSimulated;
	}

	@Override
	public void connectOutput(INode n) {
		outputs.add(n);
	}

	@Override
	public boolean canConnectOutput() {
		return true;
	}

	@Override
	public void disconnectOutput(INode n) {
		outputs.remove(n);
	}

	@Override
	public float getOutput() {
		return value;
	}

	@Override
	public int getNeededOutputs() {
		return outputs.size() > 0 ? 0 : 1;
	}

	@Override
	public void reset() {
		hasSimulated = false;
	}

}
