/*
 * Decompiled with CFR 0.152.
 */
package com.petterroea.kartering.math;

import com.petterroea.kartering.math.AStarRoute;
import com.petterroea.kartering.math.IntVect;
import java.util.LinkedList;

public class AnalysisAStar {
    private LinkedList<AStarRoute> cachedRoutes = new LinkedList();
    private byte DIRECTION_UP = 0;
    private byte DIRECTION_DOWN = 1;
    private byte DIRECTION_LEFT = (byte)2;
    private byte DIRECTION_RIGHT = (byte)3;

    public AStarRoute getRoute(boolean[] map, int mapWidth, IntVect start, IntVect end) {
        int i = 0;
        while (i < this.cachedRoutes.size()) {
            if (this.cachedRoutes.get(i).getStart().equals(start) && this.cachedRoutes.get(i).getEnd().equals(end)) {
                return this.cachedRoutes.get(i);
            }
            ++i;
        }
        short[] heatmap = this.getHeatmap(map, mapWidth, start, end);
        if (heatmap == null) {
            return null;
        }
        int xPos = end.getX();
        int yPos = end.getY();
        LinkedList<IntVect> route = new LinkedList<IntVect>();
        while (true) {
            short posAt;
            route.add(new IntVect(xPos, yPos));
            if (xPos == start.getX() && yPos == start.getY()) {
                IntVect[] routeData = new IntVect[route.size()];
                int i2 = 0;
                while (i2 < route.size()) {
                    routeData[i2] = (IntVect)route.get(route.size() - 1 - i2);
                    ++i2;
                }
                return new AStarRoute(routeData);
            }
            short smallestNeighbour = posAt = heatmap[xPos + yPos * mapWidth];
            int topCoord = xPos + (yPos - 1) * mapWidth;
            int botCoord = xPos + (yPos + 1) * mapWidth;
            int leftCoord = xPos - 1 + yPos * mapWidth;
            int rightCoord = xPos + 1 + yPos * mapWidth;
            LinkedList<Byte> places = new LinkedList<Byte>();
            if (yPos > 0 && !map[topCoord]) {
                if (heatmap[topCoord] < smallestNeighbour && heatmap[topCoord] != -1) {
                    places.clear();
                    places.add(this.DIRECTION_UP);
                    smallestNeighbour = heatmap[topCoord];
                } else if (heatmap[topCoord] == smallestNeighbour) {
                    places.add(this.DIRECTION_UP);
                }
            }
            if (yPos > 0 && !map[botCoord]) {
                if (heatmap[botCoord] < smallestNeighbour && heatmap[botCoord] != -1) {
                    places.clear();
                    places.add(this.DIRECTION_DOWN);
                    smallestNeighbour = heatmap[botCoord];
                } else if (heatmap[botCoord] == smallestNeighbour) {
                    places.add(this.DIRECTION_DOWN);
                }
            }
            if (yPos > 0 && !map[leftCoord]) {
                if (heatmap[leftCoord] < smallestNeighbour && heatmap[leftCoord] != -1) {
                    places.clear();
                    places.add(this.DIRECTION_LEFT);
                    smallestNeighbour = heatmap[leftCoord];
                } else if (heatmap[leftCoord] == smallestNeighbour) {
                    places.add(this.DIRECTION_LEFT);
                }
            }
            if (yPos > 0 && !map[rightCoord]) {
                if (heatmap[rightCoord] < smallestNeighbour && heatmap[rightCoord] != -1) {
                    places.clear();
                    places.add(this.DIRECTION_RIGHT);
                    smallestNeighbour = heatmap[rightCoord];
                } else if (heatmap[rightCoord] == smallestNeighbour) {
                    places.add(this.DIRECTION_RIGHT);
                }
            }
            if (places.size() == 0) {
                return null;
            }
            byte directionFlag = (Byte)places.get((xPos + yPos * mapWidth + (int)(System.currentTimeMillis() / 10000L)) % places.size());
            if (directionFlag == this.DIRECTION_UP) {
                --yPos;
            }
            if (directionFlag == this.DIRECTION_DOWN) {
                ++yPos;
            }
            if (directionFlag == this.DIRECTION_LEFT) {
                --xPos;
            }
            if (directionFlag != this.DIRECTION_RIGHT) continue;
            ++xPos;
        }
    }

    private short[] getHeatmap(boolean[] map, int mapWidth, IntVect start, IntVect end) {
        short[] heatmap = new short[map.length];
        int[] pointCache = new int[map.length * 2];
        int i = 0;
        while (i < heatmap.length) {
            heatmap[i] = -1;
            ++i;
        }
        int cacheSize = 1;
        pointCache[0] = start.getX();
        pointCache[1] = start.getY();
        heatmap[start.getX() + start.getY() * mapWidth] = 1;
        while (cacheSize != 0) {
            int[] newPointCache = new int[map.length * 2];
            int newCacheSize = 0;
            int i2 = 0;
            while (i2 < cacheSize) {
                int xCoord = pointCache[i2 * 2 + 0];
                int yCoord = pointCache[i2 * 2 + 1];
                short val = heatmap[xCoord + yCoord * mapWidth];
                int topCoord = xCoord + (yCoord - 1) * mapWidth;
                int bottomCoord = xCoord + (yCoord + 1) * mapWidth;
                int leftCoord = xCoord - 1 + yCoord * mapWidth;
                int rightCoord = xCoord + 1 + yCoord * mapWidth;
                if (xCoord == end.getX() && yCoord == end.getY()) {
                    int a = 0;
                    while (a < heatmap.length) {
                        String s = String.valueOf(heatmap[a]);
                        if (s.length() == 1) {
                            System.out.print(" " + heatmap[a] + ", ");
                        } else {
                            System.out.print(String.valueOf(heatmap[a]) + ", ");
                        }
                        if (a % mapWidth == mapWidth - 1) {
                            System.out.println();
                        }
                        ++a;
                    }
                    return heatmap;
                }
                if (!(yCoord <= 0 || heatmap[topCoord] <= val + 1 && heatmap[topCoord] != -1 || map[topCoord])) {
                    heatmap[topCoord] = (short)(val + 1);
                    newPointCache[newCacheSize * 2 + 0] = xCoord;
                    newPointCache[newCacheSize * 2 + 1] = (byte)(yCoord - 1);
                    ++newCacheSize;
                }
                if (!(yCoord >= map.length / mapWidth - 1 || heatmap[bottomCoord] <= val + 1 && heatmap[bottomCoord] != -1 || map[bottomCoord])) {
                    heatmap[bottomCoord] = (short)(val + 1);
                    newPointCache[newCacheSize * 2 + 0] = xCoord;
                    newPointCache[newCacheSize * 2 + 1] = (byte)(yCoord + 1);
                    ++newCacheSize;
                }
                if (!(xCoord <= 0 || heatmap[leftCoord] <= val + 1 && heatmap[leftCoord] != -1 || map[leftCoord])) {
                    heatmap[leftCoord] = (short)(val + 1);
                    newPointCache[newCacheSize * 2 + 0] = (byte)(xCoord - 1);
                    newPointCache[newCacheSize * 2 + 1] = yCoord;
                    ++newCacheSize;
                }
                if (!(xCoord >= mapWidth - 1 || heatmap[rightCoord] <= val + 1 && heatmap[rightCoord] != -1 || map[rightCoord])) {
                    heatmap[rightCoord] = (short)(val + 1);
                    newPointCache[newCacheSize * 2 + 0] = (byte)(xCoord + 1);
                    newPointCache[newCacheSize * 2 + 1] = yCoord;
                    ++newCacheSize;
                }
                ++i2;
            }
            pointCache = newPointCache;
            cacheSize = newCacheSize;
        }
        return null;
    }

    public void newTurn() {
        this.cachedRoutes.clear();
    }

    public void newRound() {
        this.newTurn();
    }
}

