import time
from coord import Coord

def printTimeSpent(fn):
    def wrapped(*args, **kwargs):
        start = time.clock()
        print "Starting {0}()".format(fn.__name__)
        retval = fn(*args, **kwargs)
        end = time.clock();
        print "{0}() spent {1:.1g} ms".format(fn.__name__, (end - start) * 1000.0)
        return retval

    return wrapped

class Players:
    players = {}
    own_id = 0

    def __init__(self, player_list = None, own_id = None):
        self.own_id = own_id
        
        if (player_list == None):
            return

        print "Creating player list from scratch..."
        self.update(player_list)

    def update(self, player_list):
        for player in player_list:
            if not (player['id'] in self.players):
                self.players[player['id']] = self.prepcoords_for_player(player)
            else:
                self.update_player(player)

        #print "Updated player information: {0}".format(self.players)

    def update_player(self, player):
        newinfo = self.prepcoords_for_player(player)
        # Update pos, vel and dir only to keep any other info we have injected during round
        self.players[player['id']]['pos'] = newinfo['pos']
        self.players[player['id']]['velocity'] = newinfo['velocity']
        self.players[player['id']]['direction'] = newinfo['direction']

    def prepcoords_for_player(self, player):
        player['pos'] = self.parse_vector(player['pos'])
        player['velocity'] = self.parse_vector(player['velocity'])
        player['direction'] = self.parse_vector(player['direction'])

        return player

    def parse_vector(self, vector):
        if (vector == None):
            return None
        
        return Coord(x=vector['x'], y=vector['y'])

    def me(self):
        for id, player in self.players.iteritems():
            if (id == self.own_id):
                return player

        return None

    def enemies(self):
        return [player for name, player in self.players.iteritems() if name != self.own_id]
    
    def allplayers(self):
        return [player for name, player in self.players.iteritems()]

    def playerPositions(self):
        return [player['pos'] for name, player in self.players.iteritems()]

    def playerPositionsWithoutMe(self):
        return [player['pos'] for name, player in self.players.iteritems() if name != self.own_id]
