import sys
sys.path.append("..")
from itertools import product
from coord import Coord
from operator import itemgetter
#from astar_grid import AStarGrid, AStarGridNode
from djikstra import Graph, Vertex, PathFinding
import math
from mapwindow import MapWindow
import datetime

def clamp(n, minn, maxn):
	return max(min(maxn, n), minn)

class World(object):
	debug = False
	tiles = []
	enemies = []
	shells = []
	items = []
	modifiers = []
	tilesize = Coord(x=0, y=0)
	mapSize = Coord(x=0, y=0)
	graph = None
	mapwindow = None
	players = None
	path = None
	checkpoints = None
	pathIndex = 0
	offsetAmount = 48

	movesreverse = { 'UP': 'DOWN', 'DOWN': 'UP', 'LEFT': 'RIGHT', 'RIGHT': 'LEFT', 
	                 'UPRIGHT': 'DOWNLEFT', 'DOWNRIGHT': 'UPLEFT', 'DOWNLEFT': 'UPRIGHT', 'UPLEFT': 'DOWNRIGHT'}
	moves = { 'UP': Coord(x=0,y=-1), 'DOWN': Coord(x=0,y=1), 'LEFT': Coord(x=-1,y=0), 'RIGHT': Coord(x=1,y=0),
	          'UPRIGHT': Coord(x=1,y=-1), 'DOWNRIGHT': Coord(x=1,y=1), 'DOWNLEFT': Coord(x=-1,y=1), 'UPLEFT': Coord(x=-1,y=-1) }

	# Pathfinding costs for moving in and out of the different tiles in the different directions
	costs = { 
		'-': { 
			'in':  { 'LEFT': .5, 'RIGHT': .5, 'UP': 3, 'DOWN': 3, 'UPRIGHT': 10, 'DOWNRIGHT': 10, 'DOWNLEFT': 10, 'UPLEFT': 10 },
			'out': { 'LEFT': .5, 'RIGHT': .5, 'UP': 3, 'DOWN': 3, 'UPRIGHT': 10, 'DOWNRIGHT': 10, 'DOWNLEFT': 10, 'UPLEFT': 10 }
		},
		'|': {
			'in':  { 'LEFT': 3, 'RIGHT': 3, 'UP': .5, 'DOWN': .5, 'UPRIGHT': 10, 'DOWNRIGHT': 10, 'DOWNLEFT': 10, 'UPLEFT': 10 },
			'out': { 'LEFT': 3, 'RIGHT': 3, 'UP': .5, 'DOWN': .5, 'UPRIGHT': 10, 'DOWNRIGHT': 10, 'DOWNLEFT': 10, 'UPLEFT': 10 }
		},
		'/': {
			'in':  { 'LEFT': .5, 'RIGHT': 3, 'UP': .5, 'DOWN': 3, 'UPRIGHT': 3, 'DOWNRIGHT': 3, 'DOWNLEFT': 3, 'UPLEFT': 3 },
			'out': { 'LEFT': 3, 'RIGHT': .5, 'UP': 3, 'DOWN': .5, 'UPRIGHT': 3, 'DOWNRIGHT': 3, 'DOWNLEFT': 3, 'UPLEFT': 3 }
		},
		'\\': {
			'in':  { 'LEFT': .5, 'RIGHT': 3, 'UP': 3, 'DOWN': .5, 'UPRIGHT': 3, 'DOWNRIGHT': 3, 'DOWNLEFT': 3, 'UPLEFT': 3 },
			'out': { 'LEFT': 3, 'RIGHT': .5, 'UP': .5, 'DOWN': 3, 'UPRIGHT': 3, 'DOWNRIGHT': 3, 'DOWNLEFT': 3, 'UPLEFT': 3 }
		},
		'`': {
			'in':  { 'LEFT': 3, 'RIGHT': .5, 'UP': .5, 'DOWN': 3, 'UPRIGHT': 3, 'DOWNRIGHT': 3, 'DOWNLEFT': 3, 'UPLEFT': 3 },
			'out': { 'LEFT': .5, 'RIGHT': 3, 'UP': 3, 'DOWN': .5, 'UPRIGHT': 3, 'DOWNRIGHT': 3, 'DOWNLEFT': 3, 'UPLEFT': 3 }
		},
		',': {
			'in':  { 'LEFT': 3, 'RIGHT': .5, 'UP': 3, 'DOWN': .5, 'UPRIGHT': 3, 'DOWNRIGHT': 3, 'DOWNLEFT': 3, 'UPLEFT': 3 },
			'out': { 'LEFT': .5, 'RIGHT': 3, 'UP': .5, 'DOWN': 3, 'UPRIGHT': 3, 'DOWNRIGHT': 3, 'DOWNLEFT': 3, 'UPLEFT': 3 }
		},
		'.': {
			'in':  { 'LEFT': 5, 'RIGHT': 5, 'UP': 5, 'DOWN': 5, 'UPRIGHT': 10, 'DOWNRIGHT': 10, 'DOWNLEFT': 10, 'UPLEFT': 10 },
			'out': { 'LEFT': 5, 'RIGHT': 5, 'UP': 5, 'DOWN': 5, 'UPRIGHT': 10, 'DOWNRIGHT': 10, 'DOWNLEFT': 10, 'UPLEFT': 10 }
		},
		'+': {
			'in':  { 'LEFT': .5, 'RIGHT': .5, 'UP': .5, 'DOWN': .5, 'UPRIGHT': 2, 'DOWNRIGHT': 2, 'DOWNLEFT': 2, 'UPLEFT': 2 },
			'out': { 'LEFT': .5, 'RIGHT': .5, 'UP': .5, 'DOWN': .5, 'UPRIGHT': 2, 'DOWNRIGHT': 2, 'DOWNLEFT': 2, 'UPLEFT': 2 }
		}
	}

	def __init__(self, mapSize, tileSize, checkpoints, tiles, modifiers):
		if self.debug:
			print "Constructing world object. Size: {0}".format(mapSize)
		self.update(mapSize, tileSize, checkpoints, tiles, modifiers)

	def update(self, mapSize, tileSize, checkpoints, tiles, modifiers):
		if self.debug:
			print "Updating world object. Size: {0}".format(mapSize)
		self.checkpoints = [Coord(x=tile['tile_x'], y=tile['tile_y']) for tile in checkpoints]
		self.mapSize = mapSize
		self.tileSize = tileSize
		self.tiles = [[square for square in row] for row in tiles]
		self.modifiers = modifiers

		if self.mapSize.x > 0 and self.mapSize.y > 0:
			self.calculateFullPath()

	def calculateFullPath(self):
		self.path = []
		start = self.checkpoints[0]
		goal = start
		self.path.extend([start])
		lastmove = "RIGHT"

		for tile in self.checkpoints[1::]:
			subpath = self.search(start, tile, lastmove)
			subgoal = subpath[-1]
			if len(subpath) == 1:
				penultimate = self.path[-1]
			else: 				
				penultimate = subpath[-2]
			for label, move in self.moves.iteritems():
				ultimate = penultimate + move
				if ultimate == subgoal:
					lastmove = label
			
			self.path.extend(subpath)
			#print "Path so far: {0}".format(self.path)
			start = subpath[-1]

		subpath = self.search(start, goal, lastmove)
		self.path.extend(subpath[:-1])
		#print "Path so far: {0}".format(self.path)

		#print "Finished finding route..."

		#print "Checkpoints  : {0}".format(self.checkpoints)
		#print "Complete path: {0}".format(self.path)

	def updateEnemies(self, enemies):
		self.enemies = enemies

	def setMapwindow(self, mapWindow):
		self.mapwindow = mapWindow

	def setPlayers(self, players):
		self.players = players

	def updateTarget(self, currentCoords):
		currentTile = self.getTileFromCoords(currentCoords)
		targetTile = self.path[self.pathIndex]

		if currentTile == targetTile:
			self.pathIndex += 1
			self.pathIndex = self.pathIndex % len(self.path)
			print "Next target tile is ", self.path[self.pathIndex]

		return self.pathIndex, self.path[self.pathIndex]

	def updateItems(self, items):
		self.items = items

	def updateShells(self, shells):
		self.shells = shells

	def getTileType(self, tile):
		return self.tiles[tile.y][tile.x]

	def isCorner(self, tile):
		tt = self.getTileType(tile)
		return (tt == '/' or tt == '\\' or tt == ',' or tt == '`')

	def getCenterForTile(self, tile):
		return Coord(x = (tile.x * self.tileSize.x) + (self.tileSize.x / 2), y = (tile.y * self.tileSize.y) + (self.tileSize.y / 2))
		
	def getModifiersForTile(self, tile, tile_type):
		tile_center = self.getCenterForTile(tile)
		tilesize_x = self.tileSize.x
		tilesize_y = self.tileSize.y
		if(tile_type == "-"):
			tilesize_y -= 32
		elif(tile_type == "|"):
			tilesize_x -= 32
		tx = tile_center.x - (tilesize_x / 2)
		ty = tile_center.y - (tilesize_y / 2)
		modifiers = []
		for modifier in self.modifiers:
			mx = modifier['x'] # - modifier['width']/2
			my = modifier['y'] # - modifier['height']/2
			if ((mx < (tx + tilesize_x)) and
			   ((mx + modifier['width']) > tx) and
			   (my < (ty + tilesize_y)) and
			   ((my + modifier['height']) > ty)):
				modifiers.append(modifier)
				
		return modifiers
		
	def penalizeMud(self, tile):
		mud_count = 0
		tile_type = self.getTileType(tile)
		modifiers = self.getModifiersForTile(tile, tile_type)
		for modifier in modifiers:
			if modifier['type'] == "mud":
				mud_count += 1
				
		if mud_count:
			print("Adding mud-tax")
			
		if mud_count == 1:
			return 0.1
		elif mud_count > 1:
			return 1.5
		else:
			return 0
	
	
	
	def shouldBoost(self, tile_type, next_tile_type, modifiers):
		if ((tile_type == '|' or tile_type == '-' or tile_type == '+')): #and
		#   (next_tile_type == '|' or next_tile_type == '-')):
			# This might be a good place to boost!
			for modifier in modifiers:
				if modifier['type'] == "booster":
					# TODO check if the booster is not near the borders..
					return Coord(x=modifier['x'] + modifier['width']/2, y=modifier['y'] + modifier['height']/2)

		
	def shouldAvoidMud(self, previous_tile, previous_tile_type, tile, tile_type, next_tile, next_tile_type, modifiers):
		# Should i avoid in this?
		mudoffset = 0
		tilesize_x = self.tileSize.x
		tilesize_y = self.tileSize.y
		if(tile_type == "-"):
			tilesize_y -= 32
		elif(tile_type == "|"):
			tilesize_x -= 32
			
		if ((tile_type == '|' or tile_type == '-' or tile_type == '+')):
			xmove = next_tile.x - tile.x
			ymove = next_tile.y - tile.y
			for modifier in modifiers:
				if modifier['type'] == "mud":
					print("PANIC! MUDSLIDE!!" + str(xmove) + " " + str(ymove))
					tile_center = self.getCenterForTile(tile)
					# x or y ?
					if ymove:
						print("Moving |")
						modcenter = modifier['x'] + modifier['width']/2;
						if modcenter < tile_center.x:
							print("Pass to the RIGHT")
							#return Coord(x=((tile_center.x+(self.tileSize.x/2))-modifier['x'] + modifier['width'])/2, y = 0)
							return Coord(x=((tile_center.x+(self.tileSize.x/2))-(modifier['x'] + modifier['width']))/2, y = mudoffset*ymove)
						else:
							print("Pass to the LEFT")
							return Coord(x=-64+(modifier['x']-(tile_center.x-(self.tileSize.x/2)))/2, y = mudoffset*ymove)
					else:
						print("Moving -")
						modcenter = modifier['y'] + modifier['height']/2;
						if modcenter < tile_center.y:
							print("Pass UNDER " + str(xmove))
							return Coord(x=mudoffset*xmove, y=(tilesize_y/2)-(((tile_center.y+(tilesize_y/2))-(modifier['y'] + modifier['height']))/2))
						else:
							print("Pass OVER " + str(xmove))
							return Coord(x=mudoffset*xmove, y=-(tilesize_y/2)+(modifier['y']-(tile_center.y-(tilesize_y/2)))/2)
		
		
	def isDiagonal(self, tile, next_tile):
		distx = next_tile.x - tile.x
		disty = next_tile.y - tile.y
		if tile.x != next_tile.x and tile.y != next_tile.y:
			return Coord(x=64*distx, y=64*disty)
			
	def getSafeTarget(self, tile, speed, next_tile, botpos, target, offset):
		if speed < 50:
			target = self.getCenterForTile(tile) + Coord(x=offset.x*0.5, y= offset.y*0.5);
			print("SAFING!")
		return target
			
			
	def getCorneringPointForTile(self, tile, pathIdx, botpos, speed):
		# How much we should cut the corners for speeeeed
		of = self.offsetAmount

						
		tile_type = self.getTileType(tile)
		
		previous_tile = self.path[(pathIdx-1)%len(self.path)]
		previous_tile_type = self.getTileType(previous_tile)

		next_tile = self.path[(pathIdx+1)%len(self.path)]
		next_tile_type = self.getTileType(next_tile)
		
		next_next_tile = self.path[(pathIdx+2)%len(self.path)]
		next_next_tile_type = self.getTileType(next_next_tile)
		


		modifiers = self.getModifiersForTile(tile, tile_type)
		
		# Is this a 'normal' move?
		weirdout = [False, False]
		weirdin = [False, False]
		
		
		for label, move in self.moves.iteritems():
			thisMove = previous_tile + move
			if thisMove == tile:
				outcost = self.costs[previous_tile_type]['out'][label]
				incost = self.costs[tile_type]['in'][label]
				if incost != 0.5:
					weirdin[0] = True
				if outcost != 0.5:
					weirdout[0] = True
					
			nextMove = tile + move
			if next_tile == nextMove:
				outcost = self.costs[tile_type]['out'][label]
				incost = self.costs[next_tile_type]['in'][label]
				if incost != 0.5:
					weirdin[1] = True
				if outcost != 0.5:
					weirdout[1] = True

		if weirdin[0]:
			print("this is not happy in")
		if weirdout[0]:
			print("this is not happy out")
				
		if weirdin[1]:
			print("Next is not happy in")
		if weirdout[1]:
			print("Next is not happy out")
		
#		if self.getTileType(self.path[(pathIdx-1)%len(self.path)]) == "`" and self.getTileType(self.path[(pathIdx)%len(self.path)]) == "/":
#			print("Heading into \\/ shortcut stage y")
#			offset = Coord(x=-61, y=61)
#		elif self.getTileType(self.path[(pathIdx)%len(self.path)]) == "`" and self.getTileType(self.path[(pathIdx+1)%len(self.path)]) == "/":
#			print("Heading into \\/ shortcut stage x")
#			offset = Coord(x=-63, y=63)
		found_special = False
		found_shortcut = False
		# Should I boost?
		boost = self.shouldBoost(tile_type, next_tile_type, modifiers)
		if boost:
			return boost
			
		diagonal = self.isDiagonal(tile, next_tile)
		if diagonal:
			offset = diagonal
			found_special = True
			found_shortcut = True
			
		avoid_mud = self.shouldAvoidMud(previous_tile, previous_tile_type, tile, tile_type, next_tile, next_tile_type, modifiers)
		if avoid_mud:
			offset = avoid_mud
			found_special = True
			print offset
			
#		# Check if we are zig-zagging via grass:
#		if self.path[(pathIdx)%len(self.path)].x != self.path[(pathIdx+2)%len(self.path)].x and self.path[(pathIdx)%len(self.path)].y != self.path[(pathIdx+2)%len(self.path)].y:
#			x = self.path[(pathIdx)%len(self.path)].x - self.path[(pathIdx+2)%len(self.path)].x
#			y = self.path[(pathIdx)%len(self.path)].y - self.path[(pathIdx+2)%len(self.path)].y
#			if self.getTileType(self.path[(pathIdx+1)%len(self.path)]) == ".":
#				print("PRE GRASS ZIGZAG %d %d" % (x,y))
#		if self.path[(pathIdx-1)%len(self.path)].x != self.path[(pathIdx+1)%len(self.path)].x and self.path[(pathIdx-1)%len(self.path)].y != self.path[(pathIdx+1)%len(self.path)].y:
#			xg = self.path[(pathIdx-1)%len(self.path)].x - self.path[(pathIdx)%len(self.path)].x
#			yg = self.path[(pathIdx-1)%len(self.path)].y - self.path[(pathIdx)%len(self.path)].y
#			xm = self.path[(pathIdx-1)%len(self.path)].x - self.path[(pathIdx+1)%len(self.path)].x
#			ym = self.path[(pathIdx-1)%len(self.path)].y - self.path[(pathIdx+1)%len(self.path)].y
#			xc = self.path[(pathIdx-1)%len(self.path)].x - self.path[(pathIdx)%len(self.path)].x
#			yc = self.path[(pathIdx-1)%len(self.path)].y - self.path[(pathIdx)%len(self.path)].y
#			if self.getTileType(self.path[(pathIdx)%len(self.path)]) == ".":
#				print("GRASS ZIGZAG %d %d" % (xm,ym))
#				if xc == 0:
#					xc = -xm
#				if yc == 0:
#					yc = -ym
					
#				offset = Coord(x=60*xc, y=60*yc)
#				found_special = True
			
		if (tile_type == "|" or tile_type == "+" or tile_type == "-") and (not found_special):
			# I'm heading for a straigt pipe, up and down. IF i'm just before a u-turn, aim a bit out of the turn:
			found_special = True # I'm optimistic!
			if next_tile_type == "/" and next_next_tile_type == "`":
				print("Heading into /\\ 180 turn turning right")
				offset = Coord(x=-40, y=0)
			elif next_tile_type == "\\" and next_next_tile_type == ",":
				print("Heading into \\/ 180 turn turning left")
				offset = Coord(x=-40, y=0)
			elif next_tile_type == "`" and next_next_tile_type == "/":
				print("Heading into /\\ 180 turn turning left")
				offset = Coord(x=40, y=0)
			elif next_tile_type == "," and next_next_tile_type == "\\":
				print("Heading into \\/ 180 turn turning right")
				offset = Coord(x=40, y=0)
			elif next_tile_type == "/" and next_next_tile_type == "\\":
				print("Heading into ( 180 turn turning left")
				offset = Coord(x=0, y=-40)
			elif next_tile_type == "\\" and next_next_tile_type == "/":
				print("Heading into ( 180 turn turning right")
				offset = Coord(x=0, y=40)
			elif next_tile_type == "," and next_next_tile_type == "`":
				print("Heading into ) 180 turn turning left")
				offset = Coord(x=0, y=40)
			elif next_tile_type == "`" and next_next_tile_type == ",":
				print("Heading into ) 180 turn turning right")
				offset = Coord(x=0, y=-40)
			else:
				# Didn't work out
				found_special = False
		
		if (weirdout[0] or weirdin[0] or weirdout[1] or weirdin[1]) and not found_special:
			offset = Coord(x=0, y=0)
			found_special = True
				
		if not found_special:
			if tile_type == ",":
				offset = Coord(x=-of, y=-of)
			elif tile_type == "/":
				offset = Coord(x=of, y=of)
			elif tile_type == "\\":
				offset = Coord(x=of, y=-of)
			elif tile_type == "`":
				offset = Coord(x=-of, y=of)
			elif tile_type =="+":
				# This might be a turn, or it might not.
				tmovex = next_tile.x - previous_tile.x
				tmovey = next_tile.y - previous_tile.y
				tx = next_tile.x - tile.x
				ty = next_tile.y - tile.y
				if tx == 0:
					tx = -(next_tile.x - previous_tile.x)
				if ty == 0:
					ty = -(next_tile.y - previous_tile.y)
				if tmovex and tmovey:
					offset = Coord(x=tx*of, y=ty*of)
					print("Cutting corner in + " + str(tx) + " " + str(ty))
				else:
					offset = Coord(x=0, y=0)
			else:
				offset = Coord(x=0, y=0)
#		if tile.x == 3 and tile.y == 2:
#			offset = Coord(x=0, y=64)
		target = self.getCenterForTile(tile) + offset
		if not found_shortcut:
			target = self.getSafeTarget(tile ,speed, next_tile, botpos, target, offset)
		return target

	def getTileFromCoords(self, coords):
		x = int(math.floor(coords.x / self.tileSize.x))
		y = int(math.floor(coords.y / self.tileSize.y))

		x = clamp(x, 0, self.mapSize.x)
		y = clamp(y, 0, self.mapSize.y)

		return Coord(x=x, y=y)

	def legalTile(self, tile):
		return (tile.x >= 0 and tile.y >= 0 and tile.x < self.mapSize.x and tile.y < self.mapSize.y)

	def addPossibleMoves(self, tile, lastmove, start):
	
		ott = self.getTileType(tile)
		badmove = self.moves[self.movesreverse[lastmove]]

		for label, move in self.moves.iteritems():
			currentTile = tile + move

			if self.legalTile(currentTile):
				bonus_cost = self.penalizeMud(currentTile)
				ttt = self.getTileType(currentTile)
					
				if ttt in self.costs:
					enterance_cost = self.costs[ttt]['in'][label]
					if currentTile == start and label == lastmove:
						enterance_cost += 3 # must be 3 make loops in tight loops with reverse checkpoints.
				else:
					enterance_cost = 4
					print "***** WARNING ***** UNEXPECTED ENTERANCE TILE WHILE PATHING: {0}".format(ttt)

				if ott in self.costs:
					exit_cost = self.costs[ott]['out'][label]
					if tile == start and move == badmove:
						exit_cost += 3 # must be 3 make loops in tight loops with reverse checkpoints.
				else:
					exit_cost = 4
					print "***** WARNING ***** UNEXPECTED EXIT TILE WHILE PATHING: {0}".format(ott)

				self.graph.add_edge(tile, currentTile, enterance_cost + exit_cost + bonus_cost)
					

	def createGraph(self, lastmove, start):
		self.graph = Graph()

		for y in range(self.mapSize.y):
			for x in range(self.mapSize.x):
				self.graph.add_vertex(Coord(x=x, y=y))

		for vertex in self.graph.get_vertices():
			self.addPossibleMoves(vertex, lastmove, start)

	def search(self, start, end, lastmove):
		if self.debug:
			print "Looking for path from {0} to {1}".format(start, end)

		if (end == None):
			return []

		if (start == end):
			return []


		a = datetime.datetime.now()
		self.createGraph(lastmove, start)
		b = datetime.datetime.now()
		delta = b - a
		print("Time to calculate graph..: %s" % delta.total_seconds())

		PathFinding.dijkstra(self.graph, self.graph.get_vertex(start))

		target = self.graph.get_vertex(end)
		path = [target.get_id()]
		PathFinding.shortest(target, path)

		if path is None:
			return None

		path.reverse()

		print "Path: {0}".format(path[1::])

		# Convert found path to sequence of coordinates
		# path = [Coord(x=tile.x, y=tile.y) for tile in path]

		# Remove first tile since this is our starting point and is not needed
		return path[1::]