/**
* B is for BACON
* staalebk
*/

THREE.Bacon = function () {

  THREE.Object3D.call( this );

  this.type = 'Bacon';


  var randomPoints1 = [];
  var randomPoints2 = [];
  var randomPoints3 = [];

  for ( var i = 0; i < 20; i ++ ) {
    if(i==0){
      randomPoints1.push( new THREE.Vector3( ( i - 10 )*0.1-0.1, Math.sin(i)*0.03, 0 ));
      randomPoints2.push( new THREE.Vector3( ( i - 10 )*0.1-0.1, Math.sin(i)*0.03+0.19, 0.001 ));
      randomPoints3.push( new THREE.Vector3( ( i - 10 )*0.1-0.1, Math.sin(i)*0.03+0.38, 0.002 ));
    }

    randomPoints1.push( new THREE.Vector3( ( i - 10 )*0.1, Math.sin(i)*0.03, 0 ));
    randomPoints2.push( new THREE.Vector3( ( i - 10 )*0.1, Math.sin(i)*0.03+0.19, 0.001 ));
    randomPoints3.push( new THREE.Vector3( ( i - 10 )*0.1, Math.sin(i)*0.03+0.38, 0.002 ));
    if (i== 19) {
      randomPoints1.push( new THREE.Vector3( ( i - 10 )*0.1+0.1, Math.sin(i)*0.03, 0 ));
      randomPoints2.push( new THREE.Vector3( ( i - 10 )*0.1+0.1, Math.sin(i)*0.03+0.19, 0.001 ));
      randomPoints3.push( new THREE.Vector3( ( i - 10 )*0.1+0.1, Math.sin(i)*0.03+0.38, 0.002 ));
    }

  }

  var randomSpline1 =  new THREE.SplineCurve3( randomPoints1 );
  var randomSpline2 =  new THREE.SplineCurve3( randomPoints2 );
  var randomSpline3 =  new THREE.SplineCurve3( randomPoints3 );

  //

  var extrudeSettings1 = {
    steps			: 20,
    bevelEnabled	: false,
    extrudePath		: randomSpline1
  };

  var extrudeSettings2 = {
    steps			: 20,
    bevelEnabled	: false,
    extrudePath		: randomSpline2
  };

  var extrudeSettings3 = {
    steps			: 20,
    bevelEnabled	: false,
    extrudePath		: randomSpline3
  };



  var pts = [], numPts = 10;

  pts.push( new THREE.Vector2 ( 0, 0));
  pts.push( new THREE.Vector2 ( 0, 0.2));
  pts.push( new THREE.Vector2 ( 0.01, 0.2));
  pts.push( new THREE.Vector2 ( 0.01, 0));

  var shape = new THREE.Shape( pts );

  var geometry1 = new THREE.ExtrudeGeometry( shape, extrudeSettings1 );
  var geometry2 = new THREE.ExtrudeGeometry( shape, extrudeSettings2 );
  var geometry3 = new THREE.ExtrudeGeometry( shape, extrudeSettings3 );

  var material1 = new THREE.MeshBasicMaterial( { color: 0xffFFFF, wireframe: false } );
  var material2 = new THREE.MeshBasicMaterial( { color: 0xff3000, wireframe: false } );

  var mesh1 = new THREE.Mesh( geometry1, material2 );
  var mesh2 = new THREE.Mesh( geometry2, material1 );
  var mesh3 = new THREE.Mesh( geometry3, material2 );

  this.add( mesh1 );
  this.add( mesh2 );
  this.add( mesh3 );

  this.scale.set(20,20,20);

};

THREE.Bacon.prototype = Object.create( THREE.Object3D.prototype);
THREE.Bacon.prototype.constructor = THREE.Bacon;
