/**
 * Hello my name is -badge.
 */
THREE.Badge = function(texture) {

	THREE.Object3D.call(this);

	this.type = 'Badge';

	this.geo = new THREE.PlaneGeometry(7,5,1,1);
	this.mat = new THREE.MeshBasicMaterial({
		map: texture,
		transparent: true
	})
	this.badge = new THREE.Mesh(this.geo, this.mat);
	this.badge.customOverrideMaterial = new THREE.MeshBasicMaterial({color:0x000000});
	this.add(this.badge);

	this.animate = function(n)
	{
		if (n>0.0000001)
		{
			this.badge.visible = true;

			var e = easeOne('easeOutQuint', n);
			this.badge.scale.set(e,e,e);

		} else
		{
			this.badge.visible = false;
		}
	}

};

THREE.Badge.prototype = Object.create(THREE.Object3D.prototype);
THREE.Badge.prototype.constructor = THREE.Badge;