// Use constructive solid geometry to bevels the corners of a box geometry.

function bevelBoxEdges (geo, bevel)
{
	var bounds = {
		max: { x:0, y:0, z:0 },
		min: { x:0, y:0, z:0 }
	};
	for (var i=0; i<geo.vertices.length; i++)
	{
		if (geo.vertices[i].x > bounds.max.x)
			bounds.max.x = geo.vertices[i].x*1;

		if (geo.vertices[i].y > bounds.max.y)
			bounds.max.y = geo.vertices[i].y*1;

		if (geo.vertices[i].z > bounds.max.z)
			bounds.max.z = geo.vertices[i].z*1;

		if (geo.vertices[i].x < bounds.min.x)
			bounds.min.x = geo.vertices[i].x*1;

		if (geo.vertices[i].y < bounds.min.y)
			bounds.min.y = geo.vertices[i].y*1;

		if (geo.vertices[i].z < bounds.min.z)
			bounds.min.z = geo.vertices[i].z*1;
	}

	var width = bounds.max.x - bounds.min.x;
	var height = bounds.max.y - bounds.min.y;
	var depth = bounds.max.z - bounds.min.z;

	geoCSG = new ThreeBSP(geo);

	// Top Front
	var removerGeo = new THREE.BoxGeometry(width*1.2, bevel, bevel,1,1,1);
	removerGeo.applyMatrix(new THREE.Matrix4().makeRotationX(deg2rad(45)));
	removerGeo.applyMatrix(new THREE.Matrix4().makeTranslation(0, bounds.max.y+0.01, bounds.max.z+0.01));
	geoCSG = geoCSG.subtract(new ThreeBSP(removerGeo));

	// Bottom front
	var removerGeo2 = new THREE.BoxGeometry(width*1.2, bevel, bevel,1,1,1);
	removerGeo2.applyMatrix(new THREE.Matrix4().makeRotationX(deg2rad(45)));
	removerGeo2.applyMatrix(new THREE.Matrix4().makeTranslation(0, bounds.min.y-0.01, bounds.max.z+0.01));
	geoCSG = geoCSG.subtract(new ThreeBSP(removerGeo2));
	
	// Top Back
	var removerGeo = new THREE.BoxGeometry(width*1.2, bevel, bevel,1,1,1);
	removerGeo.applyMatrix(new THREE.Matrix4().makeRotationX(deg2rad(45)));
	removerGeo.applyMatrix(new THREE.Matrix4().makeTranslation(0, bounds.max.y+0.01, bounds.min.z-0.01));
	geoCSG = geoCSG.subtract(new ThreeBSP(removerGeo));

	// Bottom Back
	var removerGeo = new THREE.BoxGeometry(width*1.2, bevel, bevel,1,1,1);
	removerGeo.applyMatrix(new THREE.Matrix4().makeRotationX(deg2rad(45)));
	removerGeo.applyMatrix(new THREE.Matrix4().makeTranslation(0, bounds.min.y-0.01, bounds.min.z-0.01));
	geoCSG = geoCSG.subtract(new ThreeBSP(removerGeo));



	// Top Right
	var removerGeo = new THREE.BoxGeometry(bevel, bevel, depth*1.2,1,1,1);
	removerGeo.applyMatrix(new THREE.Matrix4().makeRotationZ(deg2rad(45)));
	removerGeo.applyMatrix(new THREE.Matrix4().makeTranslation(bounds.max.x+0.01, bounds.max.y+0.01, 0));
	geoCSG = geoCSG.subtract(new ThreeBSP(removerGeo));

	// Top Left
	var removerGeo = new THREE.BoxGeometry(bevel, bevel, depth*1.2,1,1,1);
	removerGeo.applyMatrix(new THREE.Matrix4().makeRotationZ(deg2rad(45)));
	removerGeo.applyMatrix(new THREE.Matrix4().makeTranslation(bounds.min.x-0.01, bounds.max.y+0.01, 0));
	geoCSG = geoCSG.subtract(new ThreeBSP(removerGeo));

	// Bottom Right
	var removerGeo = new THREE.BoxGeometry(bevel, bevel, depth*1.2,1,1,1);
	removerGeo.applyMatrix(new THREE.Matrix4().makeRotationZ(deg2rad(45)));
	removerGeo.applyMatrix(new THREE.Matrix4().makeTranslation(bounds.max.x+0.01, bounds.min.y-0.01, 0));
	geoCSG = geoCSG.subtract(new ThreeBSP(removerGeo));

	// Bottom Left
	var removerGeo = new THREE.BoxGeometry(bevel, bevel, depth*1.2,1,1,1);
	removerGeo.applyMatrix(new THREE.Matrix4().makeRotationZ(deg2rad(45)));
	removerGeo.applyMatrix(new THREE.Matrix4().makeTranslation(bounds.min.x-0.01, bounds.min.y-0.01, 0));
	geoCSG = geoCSG.subtract(new ThreeBSP(removerGeo));
	

	// Front Right
	var removerGeo = new THREE.BoxGeometry(bevel, height*1.2, bevel, 1,1,1);
	removerGeo.applyMatrix(new THREE.Matrix4().makeRotationY(deg2rad(45)));
	removerGeo.applyMatrix(new THREE.Matrix4().makeTranslation(bounds.max.x+0.01, 0, bounds.max.z+0.01));
	geoCSG = geoCSG.subtract(new ThreeBSP(removerGeo));

	// Front Left
	var removerGeo = new THREE.BoxGeometry(bevel, height*1.2, bevel, 1,1,1);
	removerGeo.applyMatrix(new THREE.Matrix4().makeRotationY(deg2rad(45)));
	removerGeo.applyMatrix(new THREE.Matrix4().makeTranslation(bounds.min.x-0.01, 0, bounds.max.z+0.01));
	geoCSG = geoCSG.subtract(new ThreeBSP(removerGeo));

	// Bottom Right
	var removerGeo = new THREE.BoxGeometry(bevel, height*1.2, bevel, 1,1,1);
	removerGeo.applyMatrix(new THREE.Matrix4().makeRotationY(deg2rad(45)));
	removerGeo.applyMatrix(new THREE.Matrix4().makeTranslation(bounds.max.x+0.01, 0, bounds.min.z-0.01));
	geoCSG = geoCSG.subtract(new ThreeBSP(removerGeo));

	// Bottom Left
	var removerGeo = new THREE.BoxGeometry(bevel, height*1.2, bevel, 1,1,1);
	removerGeo.applyMatrix(new THREE.Matrix4().makeRotationY(deg2rad(45)));
	removerGeo.applyMatrix(new THREE.Matrix4().makeTranslation(bounds.min.x-0.01, 0, bounds.min.z-0.01));
	geoCSG = geoCSG.subtract(new ThreeBSP(removerGeo));



	geo = geoCSG.toGeometry();

	return geo;
}