"use strict";
/**
* Busk aka Tree
* staalebk
* Nice seeds: 6, 7, 9, 11
*/

THREE.Busk = function (options) {

  options.seed = options.seed || (Math.random() * 10000);
  options.leafCount = options.leafCount || 2;

  THREE.Object3D.call( this );

  this.type = 'Busk';

  Math.seedrandom(options.seed);

  var stamme_h = 13;

  var stamme = [];
  stamme.push( new THREE.Vector3( 0, 0, 0 ) );
  stamme.push( new THREE.Vector3( 1.3, 0, 0 ) );
  stamme.push( new THREE.Vector3( 1.0, 0, 3 ) );
  stamme.push( new THREE.Vector3( 0.4, 0, stamme_h ) );
  stamme.push( new THREE.Vector3( 0, 0, stamme_h ) );
  var stamme_g = new THREE.LatheGeometry( stamme, 9 );

  for (var i=0; i < stamme_g.vertices.length; i++) {
    stamme_g.vertices[i].y += Math.random();
    stamme_g.vertices[i].x += Math.random();
    if(stamme_g.vertices[i].z != 0 || stamme_g.vertices[i].z == stamme_h){
      stamme_g.vertices[i].z += Math.random();
    }
    //stamme_g.applyAxisAngle(new THREE.Vector3(i,i,i), angle = Math.PI/i);
  }

  stamme_g.applyMatrix( new THREE.Matrix4().makeTranslation(0,0,-2) );

  var busk_g = new THREE.IcosahedronGeometry(4, 0);

  var matWood = new THREE.MeshLambertMaterial({
    ambient: 0x999999,
    color: 0x7a5229,
    emissive: 0x222222,
    shading: THREE.FlatShading
  });

  this.stamme_m = new THREE.Mesh( stamme_g, matWood );
  this.stamme_m.castShadow = true;
  //this.stamme_m.receiveShadow = true;
  this.add(this.stamme_m);

  var matBush = new THREE.MeshLambertMaterial({
    ambient: 0x999999,
    color: 0x198515,
    emissive: 0x222222,
    shading: THREE.FlatShading
  });

  this.busk = [];

  for(var i = 0; i < options.leafCount; i++) {
    this.busk[i] = new THREE.Mesh( busk_g, matBush );
    this.busk[i].castShadow = true;
    this.busk[i].receiveShadow = true;

    this.busk[i].position.x = (Math.random() * 4) - 2;
    this.busk[i].position.z = 11 + ((Math.random() * 6) - 3);
    //console.log(this.busk[i].position.z); // stop flooding my console. okthxbye.
    this.busk[i].position.y = (Math.random() * 3) - 1.5;

    this.busk[i].animOffset = 0.1 + (Math.random() * 0.2);
    this.busk[i].busk_scale = 0.4 + (Math.random() * 0.5);
    this.add(this.busk[i]);  
  }
    
  this.rotation.x = -Math.PI / 2;

  this.rotation.z = Math.PI * Math.random();
  this.castShadow = true;
  this.receiveShadow = true;
  this.setAge(1);
};

THREE.Busk.prototype = Object.create( THREE.Object3D.prototype );
THREE.Busk.prototype.constructor = THREE.Busk;

THREE.Busk.prototype.setAge = function( age ) {
  
  if(age == 0) {
    this.visible = false;
  } else {
    this.visible = true;
  }

  this.stamme_m.visible = (age > 0);

  // Eases scale up when age is between 0 and 0.5
  this.stamme_m.scale.z = easeOne('easeOutCubic', segmentTransition(0, 0.5, age)) + 0.0001;
  this.stamme_m.scale.x = easeOne('easeOutCubic', segmentTransition(0, 0.3, age)) + 0.0001;
  this.stamme_m.scale.y = this.stamme_m.scale.x;
  
  for(var i = 0; i < this.busk.length; i++) {
    var animStart = this.busk[i].animOffset;
    var animEnd = animStart + 0.4;
    var s = (easeOne('easeOutElastic', segmentTransition(animStart, animEnd, age)) + 0.0001) * this.busk[i].busk_scale;

    this.busk[i].visible = (age > animStart);
    this.busk[i].scale.copy(new THREE.Vector3(s, s, s));
    this.busk[i].rotation.z = easeOne('easeOutBack', segmentTransition(animStart, animEnd + 0.2, age)) * Math.PI;  
  }

  //this.scale.z = age;
  /*
  if (age != this.age) {
    this.rotation.z += Math.PI * age / 40;
  }
  */
  this.age = age;
};
