'use strict';

THREE.Fire = function (options) {

	options = options || {};

	options.withLight = typeof(options.withLight) !== "undefined" ? options.withLight : true;
	options.seed = typeof(options.seed) !== "undefined" ? options.seed : 100;

	THREE.Object3D.call( this );
	this.type = 'Fire';

	this.flames = [];

	var flame = new THREE.Flame({ skew: new THREE.Vector3(  5,  0, 0), seed: options.seed + 1, wiggle: 4 });
	flame.scale.y = 0.7;
	this.flames.push(flame);

	var flame = new THREE.Flame({ skew: new THREE.Vector3( 0, -4, 0), seed: options.seed - 1, wiggle: 2 });
	this.flames.push(flame);

	var flame = new THREE.Flame({ skew: new THREE.Vector3( -3,  0, 0), seed: options.seed, wiggle: 3 });
	flame.scale.y = 0.8;
	this.flames.push(flame);


	for(var i = 0, il = this.flames.length; i < il; i++) {
		this.add(this.flames[i]);
	}

	if(options.withLight) {
		this.lightSource = new THREE.PointLight( 0xF4D93E, 1, 50 );
		this.lightSource.position.y = 15;
		this.add(this.lightSource);	
	}
};

THREE.Fire.prototype = Object.create( THREE.Object3D.prototype);
THREE.Fire.prototype.constructor = THREE.Fire;

THREE.Fire.prototype.animate = function(t) {
	for(var i = 0, il = this.flames.length; i < il; i++) {
		this.flames[i].animate(t);	
	}
	this.lightSource.intensity = 0.75 + noise.perlin2(t * 5, t * 5) * 0.25;
}
