THREE.LaserProjector = function (options) {

	options = options || {};
	options.color = typeof(options.color) !== "undefined" ? options.color : 0x00ff00;
	options.laserCount = typeof(options.laserCount) !== "undefined" ? options.laserCount : 10;
	options.spread = typeof(options.spread) !== "undefined" ? options.spread : 0.05;

	THREE.Object3D.call( this );

	var material = new THREE.MeshBasicMaterial({
		color: options.color
	});

	var length = 750;
	var geometry = new THREE.CylinderGeometry( 0.5, 0.5, length, 5, 1 );
	geometry.applyMatrix(new THREE.Matrix4().makeTranslation(0, length / 2, 0));

	for(var i = 0; i < options.laserCount; i++) {
		var line = new THREE.Mesh( geometry, material );
		line.rotateOnAxis(new THREE.Vector3(0, 1, 0), -Math.PI / 2);
		line.rotateOnAxis(new THREE.Vector3(0, 0, 1), Math.PI / 2);
		line.rotateOnAxis(new THREE.Vector3(1, 0, 0), (options.spread * Math.PI) * ((options.laserCount / 2) - i));
		this.add( line );
	}
	
};

THREE.LaserProjector.prototype = Object.create( THREE.Object3D.prototype );
THREE.LaserProjector.prototype.constructor = THREE.LaserProjector;