/**
 * Busk aka Tree
 * staalebk
 */
var pigCache = null;

THREE.Pig = function (options) {

	options = options || {};

	options.skin_emissive = typeof(options.skin_emissive) !== "undefined" ? options.skin_emissive : 0x552B20;
	options.eye_emissive = typeof(options.eye_emissive) !== "undefined" ? options.eye_emissive : 0x333333;

	options.groundlevel = typeof(options.groundlevel) !== "undefined" ? options.groundlevel : false;

	options.center = typeof(options.center) !== "undefined" ? options.center : false;

	THREE.Object3D.call( this );
	this.type = 'Pig';

	if(pigCache === null) {
		var loader = new THREE.JSONLoader();
		pigCache = loader.parse(THREE.Pig.meshData);
		pigCache.geometry.applyMatrix(new THREE.Matrix4().makeRotationY(deg2rad(180)));
	}

	this.constructMesh(pigCache.geometry, pigCache.materials, options);
};

THREE.Pig.prototype = Object.create( THREE.Object3D.prototype);
THREE.Pig.prototype.constructor = THREE.Pig;

THREE.Pig.prototype.constructMesh = function(geometry, materials, options) {
	//materials[0].emissive = new THREE.Color(options.skin_emissive);
	//materials[2].emissive = new THREE.Color(options.eye_emissive);

	for(var i = 0; i < materials.length; i++) {
		materials[i].shading = THREE.FlatShading;	
	}

	var material = new THREE.MeshFaceMaterial( materials );
	var mesh = new THREE.Mesh( geometry, material );

	mesh.scale.x = mesh.scale.y = mesh.scale.z = 3.5;
	
	if (options.center == true)
	{
		mesh.position.y = -3.5;
	} else
	{
		//mesh.position.y = 0.25;
	}
	mesh.position.z = 1; // certified
	//mesh.rotation.y = deg2rad(180);
	mesh.rotation.y = deg2rad(180);
	mesh.castShadow = true;
	mesh.receiveShadow = true;

	this.mesh = mesh;
	this.add( mesh );
};

THREE.Pig.prototype.computeBoundingBox = function() {
	this.mesh.geometry.computeBoundingBox();
	return this.mesh.geometry.boundingBox;
};

THREE.Pig.prototype.getBoundingBox = function() {
	return this.mesh.geometry.boundingBox;
}

THREE.Pig.meshData = {

"metadata":
{
"sourceFile": "Piggy.max",
"generatedBy": "3ds max ThreeJSExporter",
"formatVersion": 3.1,
"vertices": 212,
"normals": 212,
"colors": 0,
"uvs": 0,
"triangles": 408,
"materials": 2
},

"materials": [
{
"DbgIndex" : 0,
"DbgName"  : "Skin",
"colorDiffuse"  : [0.7255, 0.4392, 0.4392],
"colorAmbient"  : [0.7255, 0.4392, 0.4392],
"colorSpecular"  : [0.9000, 0.9000, 0.9000],
"transparency"  : 1.0,
"specularCoef"  : 13.0,
"vertexColors" : false
},

{
"DbgIndex" : 1,
"DbgName"  : "Eyes",
"colorDiffuse"  : [0.0863, 0.0863, 0.0863],
"colorAmbient"  : [0.0863, 0.0863, 0.0863],
"colorSpecular"  : [0.9000, 0.9000, 0.9000],
"transparency"  : 1.0,
"specularCoef"  : 33.0,
"vertexColors" : false
}

],

"vertices": [-0.872732,1.6625,-0.932646,-1.05548,1.13965,-0.17598,-1.02231,1.1135,-0.929937,-0.597888,1.55077,-1.49206,-0.69792,1.14396,-1.484,-0.416812,1.97087,-0.950864,-0.348105,1.69034,-1.56274,0.0,2.06597,-0.983311,0.0,1.72917,-1.5786,-0.355847,2.01239,-0.140748,0.0,2.08175,-0.161935,0.0,2.01806,0.252633,-0.287233,1.99868,0.271851,-0.232227,1.99337,0.659186,0.0,1.95856,0.712775,-0.192695,1.77135,0.870756,-0.35779,1.98535,0.685681,-0.532189,1.66984,0.79654,-0.680813,1.79488,0.720582,-0.717683,1.55134,0.762725,-0.443314,2.25736,0.657968,-0.462269,2.17339,0.680857,-0.618243,2.40617,0.848744,-0.62843,2.35933,0.864205,-0.716537,2.39653,0.892595,-0.686607,2.35336,0.899994,-0.781508,2.1088,0.774212,-0.740247,2.10676,0.764626,-0.768497,1.78281,0.70141,-0.249566,1.32916,1.43377,0.0,1.43573,1.45194,-0.382551,1.29568,1.24462,-0.513355,1.0806,1.16244,0.0,1.62271,1.08163,-0.20309,1.55677,1.09526,-0.604838,1.36681,0.926315,-0.801156,1.50463,0.669619,-0.79441,1.73442,0.29397,-0.961188,1.34147,0.28276,-0.750533,2.12172,0.577281,-0.509054,2.24781,0.509187,-0.359666,1.16269,-1.70996,0.0,1.22183,-1.77835,-0.665299,0.576125,-1.39064,-0.678573,0.521985,-0.946285,-0.790162,0.542461,0.0809167,-0.947389,0.499295,0.366344,-0.762235,0.613811,0.620503,-0.496584,0.815404,0.821342,0.0,0.653954,-1.49695,-0.354387,0.578214,-1.50616,-0.647399,0.813574,-1.46862,-0.946698,0.803209,-0.905442,-1.01224,0.817278,-0.143864,-0.997525,1.03262,0.325393,-0.804563,1.18131,0.733284,-0.714891,1.22052,0.856904,0.0,0.914876,-1.7226,-0.297034,0.851845,-1.658,0.0,0.233368,0.0283584,0.0,0.266908,-0.838737,-0.39018,0.316434,-0.898521,-0.451217,0.315433,0.101729,0.0,0.413795,0.681837,-0.429872,0.447931,0.616368,0.0,0.745966,1.13599,-0.274855,0.75134,1.05872,-0.308745,1.0352,1.40341,0.0,0.991874,1.51341,-0.645891,-0.000213468,-1.41388,-0.709406,-0.000605102,-1.02707,-0.828203,0.000594493,0.151247,-0.411758,-0.000178715,-1.44821,-0.425184,-0.000650836,-0.981897,-0.475383,0.000568739,0.178006,-0.458224,8.48542e-005,0.655937,-0.766976,7.42199e-005,0.662473,-0.924998,0.000325814,0.419268,-0.420553,1.92896,0.545496,-0.618549,1.81164,0.573208,-0.488148,2.0511,0.544537,-0.657713,2.32853,0.793933,-0.659447,2.01961,0.597251,0.0402874,1.59928,-1.76683,-0.0733429,1.46702,-1.63815,-0.112533,1.65102,-1.54514,-0.00375962,1.73201,-1.6651,0.169502,1.59705,-1.70798,0.0558716,1.4648,-1.5793,0.0166817,1.6488,-1.48629,0.125455,1.72979,-1.60625,-0.0741774,1.07652,1.50959,-0.0701352,1.32377,1.45615,-0.187153,1.27584,1.4639,-0.220817,1.09695,1.43474,-0.0689497,1.10252,1.33577,-0.0635229,1.2726,1.28607,-0.128442,1.24773,1.30351,-0.152068,1.11383,1.2744,0.14764,1.76337,-1.8453,0.0883152,1.68357,-1.92859,-0.0413143,1.71312,-1.86471,0.02485,1.81399,-1.79564,-0.086601,1.9962,-2.1197,-0.0329159,1.96967,-2.12115,-0.143046,1.86076,-1.93099,-0.0791619,1.81291,-1.96158,-0.141965,1.7669,-1.98976,-0.209818,1.80914,-1.95067,-0.289936,0.852475,1.32432,0.0,0.831441,1.41804,0.872732,1.6625,-0.932647,1.05548,1.13965,-0.17598,1.02231,1.1135,-0.929937,0.597888,1.55077,-1.49206,0.69792,1.14396,-1.484,0.416812,1.97087,-0.950864,0.348105,1.69034,-1.56274,0.355847,2.01239,-0.140748,0.287233,1.99868,0.271851,0.232227,1.99337,0.659186,0.192695,1.77135,0.870756,0.35779,1.98535,0.685682,0.532189,1.66984,0.79654,0.680813,1.79488,0.720582,0.717683,1.55134,0.762725,0.443314,2.25736,0.657968,0.462269,2.17339,0.680857,0.618243,2.40617,0.848744,0.62843,2.35933,0.864205,0.716537,2.39653,0.892595,0.686607,2.35336,0.899994,0.781508,2.1088,0.774212,0.740247,2.10676,0.764625,0.768497,1.78281,0.70141,0.249566,1.32916,1.43377,0.382551,1.29568,1.24462,0.513355,1.0806,1.16244,0.20309,1.55677,1.09526,0.604838,1.36681,0.926315,0.801156,1.50463,0.669619,0.79441,1.73442,0.29397,0.961188,1.34147,0.28276,0.750533,2.12172,0.577281,0.509054,2.24781,0.509187,0.359666,1.16269,-1.70996,0.665299,0.576125,-1.39064,0.678573,0.521985,-0.946285,0.790162,0.542461,0.0809167,0.947389,0.499295,0.366344,0.762235,0.613811,0.620503,0.496584,0.815404,0.821342,0.354387,0.578214,-1.50616,0.647399,0.813574,-1.46862,0.946698,0.803209,-0.905442,1.01224,0.817278,-0.143864,0.997525,1.03262,0.325393,0.804563,1.18131,0.733284,0.714891,1.22052,0.856904,0.297034,0.851845,-1.658,0.39018,0.316434,-0.898521,0.451217,0.315433,0.101729,0.429872,0.447931,0.616368,0.274855,0.75134,1.05872,0.308745,1.0352,1.40341,0.645891,-0.000213468,-1.41388,0.709406,-0.000605102,-1.02707,0.828203,0.000594493,0.151247,0.411758,-0.000178715,-1.44821,0.425184,-0.000650836,-0.981897,0.475383,0.000568739,0.178006,0.458224,8.48542e-005,0.655937,0.766976,7.42199e-005,0.662473,0.924998,0.000325814,0.419268,0.420553,1.92896,0.545496,0.618549,1.81164,0.573208,0.488148,2.0511,0.544537,0.657713,2.32853,0.793933,0.659447,2.01961,0.597251,0.0741774,1.07652,1.50959,0.0701352,1.32377,1.45615,0.187153,1.27584,1.4639,0.220817,1.09695,1.43474,0.0689497,1.10252,1.33577,0.0635229,1.2726,1.28607,0.128442,1.24773,1.30351,0.152068,1.11383,1.2744,0.289936,0.852475,1.32432,0.169722,1.67768,0.989908,0.216857,1.63386,1.00689,0.230707,1.74525,0.887685,0.174965,1.7391,0.925545,0.277256,1.63645,0.969938,0.27222,1.70037,0.908922,-0.169722,1.67768,0.989908,-0.216857,1.63386,1.00689,-0.230707,1.74525,0.887685,-0.174965,1.7391,0.925545,-0.277256,1.63645,0.969938,-0.27222,1.70037,0.908922,0.177188,1.6908,1.00303,0.224324,1.64698,1.02001,0.238173,1.75837,0.900809,0.182431,1.75222,0.938669,0.284723,1.64957,0.983061,0.279687,1.71349,0.922046,-0.177188,1.6908,1.00303,-0.182431,1.75222,0.938669,-0.238173,1.75837,0.900809,-0.224324,1.64698,1.02001,-0.279687,1.71349,0.922046,-0.284723,1.64957,0.983061],

"normals": [-0.795156,0.561515,-0.228973,-0.994589,0.102065,0.0193605,-0.96112,-0.00619067,-0.276063,-0.633264,0.425587,-0.646415,-0.744973,0.00688416,-0.66706,-0.399411,0.891485,-0.213835,-0.29798,0.606082,-0.737478,0.0,0.969148,-0.24648,0.0,0.641959,-0.766739,-0.364484,0.931008,0.0194061,0.0,0.999506,0.0314265,0.0,0.994156,0.107951,-0.121349,0.984479,-0.126792,0.243946,0.842704,0.479939,0.0,0.870788,0.491659,-0.211125,0.671677,0.710124,-0.305561,0.385842,0.870493,-0.343128,0.427002,0.83662,-0.0201915,0.323953,0.945858,-0.604085,0.210277,0.768678,0.77507,0.603434,0.187437,0.0683239,-0.314799,0.946696,0.336911,0.905305,0.258676,0.471737,-0.350964,0.808881,-0.503324,0.721597,0.475355,0.211895,-0.193228,0.958,-0.764517,-0.151272,0.626602,0.537593,-0.316503,0.78155,-0.796635,0.0545681,0.601992,-0.54252,0.409874,0.733263,0.0,0.615112,0.78844,-0.725403,0.417323,0.547386,-0.825862,-0.182069,0.533669,0.0,0.807941,0.589263,-0.386822,0.723173,0.572179,-0.644439,0.354591,0.677469,-0.899293,0.147122,0.411858,-0.844955,0.529996,-0.0717954,-0.947278,0.262688,0.183465,-0.792665,0.414789,-0.446803,0.0584064,0.785258,-0.616408,-0.346562,0.0238712,-0.937723,0.0,0.120814,-0.992675,-0.836671,-0.0485527,-0.54555,-0.855387,-0.515449,0.0512364,-0.804007,-0.472165,-0.361432,-0.997405,-0.0336506,0.0636422,-0.579885,-0.140973,0.802409,-0.623257,-0.449951,0.639605,0.0,-0.755003,-0.655722,0.0584063,-0.5368,-0.841686,-0.690451,-0.247991,-0.679543,-0.861883,-0.447089,-0.239308,-0.913852,-0.404858,0.0310535,-0.963858,-0.0575926,0.260117,-0.825709,-0.0800536,0.558388,-0.794361,-0.0701216,0.603385,0.0,-0.39518,-0.918604,-0.214476,-0.377044,-0.90102,0.0,-0.994025,0.109157,0.0,-0.966996,-0.254791,0.0350145,-0.97659,0.212242,0.054717,-0.940176,-0.336266,0.0,-0.894345,0.447378,0.0725719,-0.618515,0.782414,0.0,-0.898194,0.439599,-0.439947,-0.762554,0.474297,-0.58727,-0.15822,0.793776,0.0,-0.283941,0.958842,-0.553136,-0.592656,-0.585491,-0.671164,-0.611268,0.419392,-0.448031,-0.638434,-0.625836,0.503287,-0.600776,-0.621104,0.501557,-0.667631,0.55019,0.573497,-0.659672,-0.48573,0.569954,-0.569302,0.592493,-0.36448,-0.589063,0.72122,-0.768286,-0.630078,0.112867,-0.600285,0.378111,0.704763,0.204588,0.749426,0.629685,-0.183759,-0.345476,0.92026,0.34565,-0.747561,0.567167,0.640823,-0.143726,0.754115,-0.37844,-0.747919,-0.545344,-0.63429,-0.756491,-0.159367,-0.882091,0.27041,0.385738,-0.710358,0.680901,0.178228,0.880282,-0.467498,-0.0809274,0.355713,-0.856628,0.373707,0.0968257,0.210522,0.972782,0.589243,0.584127,0.558201,-0.376828,0.157443,0.912805,-0.269081,-0.0988361,0.958033,0.117147,-0.161303,0.979928,-0.0335725,0.195493,0.98013,-0.676847,0.618283,0.399504,-0.451406,-0.478425,0.753221,0.520565,-0.413902,0.746791,0.281545,0.403831,0.870433,0.809537,0.502882,-0.302917,0.367918,-0.414642,-0.832291,-0.775615,-0.60951,0.16407,-0.179538,0.956507,0.229912,-0.0618033,0.767372,-0.638217,0.735156,0.250328,-0.629985,-0.198453,0.690314,0.695761,0.719723,0.400178,-0.567324,-0.259296,-0.714179,-0.650164,-0.977189,-0.125694,0.171178,-0.502028,-0.674745,0.541006,0.0,-0.749699,0.661779,0.795156,0.561515,-0.228973,0.994589,0.102066,0.0193606,0.96112,-0.00619068,-0.276063,0.633264,0.425587,-0.646415,0.744972,0.00688414,-0.66706,0.399411,0.891485,-0.213835,0.29798,0.606082,-0.737478,0.364484,0.931008,0.0194062,0.121349,0.984479,-0.126792,-0.243946,0.842704,0.479938,0.211124,0.671677,0.710124,0.30556,0.385842,0.870494,0.343127,0.427001,0.83662,0.0201936,0.323953,0.945858,0.604086,0.210277,0.768677,-0.77507,0.603435,0.187438,-0.0683238,-0.314799,0.946696,-0.33691,0.905306,0.258676,-0.471736,-0.350964,0.808882,0.503324,0.721597,0.475355,-0.211895,-0.193228,0.958,0.764518,-0.151272,0.626601,-0.537592,-0.316503,0.78155,0.796636,0.054568,0.601991,0.54252,0.409874,0.733264,0.725403,0.417323,0.547386,0.825862,-0.182069,0.533669,0.386822,0.723173,0.572179,0.644439,0.354591,0.677469,0.899293,0.147122,0.411858,0.844955,0.529996,-0.0717955,0.947278,0.262688,0.183465,0.792664,0.414789,-0.446804,-0.0584067,0.785258,-0.616408,0.346562,0.0238712,-0.937723,0.836671,-0.0485527,-0.54555,0.855387,-0.515449,0.0512364,0.804007,-0.472165,-0.361431,0.997405,-0.0336506,0.0636426,0.579885,-0.140973,0.802409,0.623257,-0.449951,0.639605,-0.0584061,-0.5368,-0.841686,0.690451,-0.247991,-0.679543,0.861883,-0.447089,-0.239308,0.913852,-0.404858,0.0310535,0.963858,-0.0575927,0.260117,0.825709,-0.0800536,0.558387,0.794361,-0.0701219,0.603385,0.214476,-0.377044,-0.90102,-0.0350141,-0.97659,0.212242,-0.054717,-0.940176,-0.336266,-0.0725715,-0.618515,0.782414,0.439947,-0.762554,0.474297,0.58727,-0.15822,0.793776,0.553136,-0.592656,-0.585491,0.671164,-0.611268,0.419392,0.448031,-0.638434,-0.625836,-0.503287,-0.600776,-0.621104,-0.501556,-0.667631,0.550191,-0.573497,-0.659672,-0.48573,-0.569953,-0.569302,0.592493,0.36448,-0.589063,0.72122,0.768286,-0.630078,0.112867,0.600284,0.37811,0.704763,-0.204587,0.749427,0.629685,0.183759,-0.345476,0.92026,-0.34565,-0.747561,0.567167,-0.640822,-0.143726,0.754116,0.376828,0.157443,0.912805,0.269081,-0.098836,0.958033,-0.117147,-0.161303,0.979927,0.0335726,0.195492,0.98013,0.676847,0.618283,0.399504,0.451406,-0.478425,0.753221,-0.520565,-0.413902,0.746791,-0.281545,0.403831,0.870433,0.502028,-0.674745,0.541006,-0.901586,-0.432591,0.00258653,-0.335286,-0.922774,0.189927,-0.0992652,0.137094,-0.985572,-0.84304,0.0799807,-0.53187,0.410218,-0.869455,-0.275261,0.417059,-0.385759,-0.822953,0.901591,-0.432581,0.00257091,0.335269,-0.922781,0.18992,0.099261,0.137094,-0.985572,0.843042,0.0799798,-0.531867,-0.410217,-0.869457,-0.275257,-0.41706,-0.385756,-0.822954,-0.439743,0.378775,0.814344,0.116933,-0.128387,0.984806,0.344129,0.916007,-0.206173,-0.386638,0.881708,0.270376,0.856476,-0.0856163,0.509037,0.892891,0.450073,0.0133881,0.439747,0.378788,0.814336,0.386641,0.881706,0.270377,-0.344132,0.916005,-0.206175,-0.116952,-0.128392,0.984803,-0.892891,0.450074,0.0133852,-0.856475,-0.0856204,0.509039],

"colors": [],

"uvs": [[]],

"faces": [34,40,22,20,0,40,22,20,34,39,26,24,0,39,26,24,34,35,19,56,0,35,19,56,34,47,64,48,0,47,64,48,34,66,48,64,0,66,48,64,34,67,32,109,0,67,32,109,34,0,3,2,0,0,3,2,34,6,41,3,0,6,41,3,34,8,42,41,0,8,42,41,34,6,8,41,0,6,8,41,34,2,3,4,0,2,3,4,34,3,41,4,0,3,41,4,34,6,3,5,0,6,3,5,34,0,5,3,0,0,5,3,34,13,14,11,0,13,14,11,34,11,12,13,0,11,12,13,34,13,15,14,0,13,15,14,34,15,13,16,0,15,13,16,34,16,17,15,0,16,17,15,34,18,19,17,0,18,19,17,34,17,16,18,0,17,16,18,34,20,22,23,0,20,22,23,34,23,21,20,0,23,21,20,34,24,25,23,0,24,25,23,34,23,22,24,0,23,22,24,34,30,33,34,0,30,33,34,34,34,29,30,0,34,29,30,34,15,34,33,0,15,34,33,34,33,14,15,0,33,14,15,34,31,29,34,0,31,29,34,34,34,35,31,0,34,35,31,34,17,35,34,0,17,35,34,34,34,15,17,0,34,15,17,34,17,19,35,0,17,19,35,34,19,18,28,0,19,18,28,34,28,36,19,0,28,36,19,34,36,28,37,0,36,28,37,34,37,38,36,0,37,38,36,34,1,38,37,0,1,38,37,34,12,9,37,0,12,9,37,34,39,37,28,0,39,37,28,34,28,26,39,0,28,26,39,34,12,37,39,0,12,37,39,34,39,40,12,0,39,40,12,34,40,20,13,0,40,20,13,34,13,12,40,0,13,12,40,34,39,24,22,0,39,24,22,34,22,40,39,0,22,40,39,34,20,21,16,0,20,21,16,34,16,13,20,0,16,13,20,34,25,24,26,0,25,24,26,34,26,27,25,0,26,27,25,34,28,18,27,0,28,18,27,34,27,26,28,0,27,26,28,34,52,2,4,0,52,2,4,34,4,51,52,0,4,51,52,34,51,43,44,0,51,43,44,34,44,52,51,0,44,52,51,34,1,2,52,0,1,2,52,34,52,53,1,0,52,53,1,34,44,45,53,0,44,45,53,34,53,52,44,0,53,52,44,34,1,53,54,0,1,53,54,34,54,38,1,0,54,38,1,34,45,46,54,0,45,46,54,34,54,53,45,0,54,53,45,34,38,54,55,0,38,54,55,34,55,36,38,0,55,36,38,34,47,55,54,0,47,55,54,34,54,46,47,0,54,46,47,34,56,19,36,0,56,19,36,34,36,55,56,0,36,55,56,34,49,50,58,0,49,50,58,34,58,57,49,0,58,57,49,34,50,43,51,0,50,43,51,34,51,58,50,0,51,58,50,34,45,44,61,0,45,44,61,34,61,62,45,0,61,62,45,34,61,60,59,0,61,60,59,34,59,62,61,0,59,62,61,34,49,60,61,0,49,60,61,34,61,50,49,0,61,50,49,34,31,32,67,0,31,32,67,34,67,29,31,0,67,29,31,34,43,69,70,0,43,69,70,34,70,44,43,0,70,44,43,34,72,69,43,0,72,69,43,34,43,50,72,0,43,50,72,34,61,73,72,0,61,73,72,34,72,50,61,0,72,50,61,34,70,73,61,0,70,73,61,34,61,44,70,0,61,44,70,34,77,71,74,0,77,71,74,34,76,77,74,0,76,77,74,34,75,76,74,0,75,76,74,34,73,70,69,0,73,70,69,34,69,72,73,0,69,72,73,34,62,74,71,0,62,74,71,34,71,45,62,0,71,45,62,34,64,75,74,0,64,75,74,34,74,62,64,0,74,62,64,34,64,47,76,0,64,47,76,34,76,75,64,0,76,75,64,34,46,77,76,0,46,77,76,34,76,47,46,0,76,47,46,34,46,45,71,0,46,45,71,34,71,77,46,0,71,77,46,34,18,79,82,0,18,79,82,34,82,27,18,0,82,27,18,34,16,78,79,0,16,78,79,34,79,18,16,0,79,18,16,34,80,78,16,0,80,78,16,34,16,21,80,0,16,21,80,34,21,23,81,0,21,23,81,34,81,80,21,0,81,80,21,34,25,81,23,0,25,81,23,34,81,25,27,0,81,25,27,34,27,82,81,0,27,82,81,34,80,81,82,0,80,81,82,34,78,80,82,0,78,80,82,34,82,79,78,0,82,79,78,34,85,86,83,0,85,86,83,34,83,84,85,0,83,84,85,34,88,84,83,0,88,84,83,34,83,87,88,0,83,87,88,34,89,85,84,0,89,85,84,34,84,88,89,0,84,88,89,34,86,85,89,0,86,85,89,34,89,90,86,0,89,90,86,34,88,87,90,0,88,87,90,34,90,89,88,0,90,89,88,34,68,91,94,0,68,91,94,34,94,67,68,0,94,67,68,34,68,30,92,0,68,30,92,34,92,91,68,0,92,91,68,34,92,30,29,0,92,30,29,34,29,93,92,0,29,93,92,34,29,67,94,0,29,67,94,34,94,93,29,0,94,93,29,34,95,98,94,0,95,98,94,34,94,91,95,0,94,91,95,34,92,96,95,0,92,96,95,34,95,91,92,0,95,91,92,34,97,96,92,0,97,96,92,34,92,93,97,0,92,93,97,34,94,98,97,0,94,98,97,34,97,93,94,0,97,93,94,34,95,96,97,0,95,96,97,34,97,98,95,0,97,98,95,34,90,99,102,0,90,99,102,34,102,86,90,0,102,86,90,34,87,100,99,0,87,100,99,34,99,90,87,0,99,90,87,34,100,87,83,0,100,87,83,34,83,101,100,0,83,101,100,34,86,102,101,0,86,102,101,34,101,83,86,0,101,83,86,34,106,104,105,0,106,104,105,34,106,105,102,0,106,105,102,34,102,99,106,0,102,99,106,34,103,104,106,0,103,104,106,34,106,107,103,0,106,107,103,34,100,107,106,0,100,107,106,34,106,99,100,0,106,99,100,34,107,108,103,0,107,108,103,34,101,108,107,0,101,108,107,34,107,100,101,0,107,100,101,34,105,104,103,0,105,104,103,34,103,108,105,0,103,108,105,34,105,108,101,0,105,108,101,34,101,102,105,0,101,102,105,34,48,56,55,0,48,56,55,34,55,47,48,0,55,47,48,34,63,64,62,0,63,64,62,34,62,59,63,0,62,59,63,34,63,65,66,0,63,65,66,34,66,64,63,0,66,64,63,34,32,31,35,0,32,31,35,34,32,35,56,0,32,35,56,34,56,48,32,0,56,48,32,34,65,110,109,0,65,110,109,34,109,66,65,0,109,66,65,34,67,109,110,0,67,109,110,34,110,68,67,0,110,68,67,34,66,109,32,0,66,109,32,34,32,48,66,0,32,48,66,34,0,2,1,0,0,2,1,34,1,37,0,0,1,37,0,34,57,58,41,0,57,58,41,34,41,42,57,0,41,42,57,34,41,58,51,0,41,58,51,34,51,4,41,0,51,4,41,34,12,11,10,0,12,11,10,34,10,9,12,0,10,9,12,34,7,8,6,0,7,8,6,34,6,5,7,0,6,5,7,34,9,5,0,0,9,5,0,34,0,37,9,0,0,37,9,34,5,9,10,0,5,9,10,34,10,7,5,0,10,7,5,34,144,126,128,0,144,126,128,34,143,130,132,0,143,130,132,34,139,158,125,0,139,158,125,34,150,151,162,0,150,151,162,34,163,162,151,0,163,162,151,34,164,187,137,0,164,187,137,34,111,113,114,0,111,113,114,34,117,114,145,0,117,114,145,34,8,145,42,0,8,145,42,34,117,145,8,0,117,145,8,34,113,115,114,0,113,115,114,34,114,115,145,0,114,115,145,34,117,116,114,0,117,116,114,34,111,114,116,0,111,114,116,34,11,14,120,0,11,14,120,34,120,119,11,0,120,119,11,34,120,14,121,0,120,14,121,34,122,120,121,0,122,120,121,34,121,123,122,0,121,123,122,34,123,125,124,0,123,125,124,34,124,122,123,0,124,122,123,34,129,128,126,0,129,128,126,34,126,127,129,0,126,127,129,34,130,128,129,0,130,128,129,34,129,131,130,0,129,131,130,34,138,33,30,0,138,33,30,34,30,135,138,0,30,135,138,34,33,138,121,0,33,138,121,34,121,14,33,0,121,14,33,34,138,135,136,0,138,135,136,34,136,139,138,0,136,139,138,34,138,139,123,0,138,139,123,34,123,121,138,0,123,121,138,34,123,139,125,0,123,139,125,34,134,124,125,0,134,124,125,34,125,140,134,0,125,140,134,34,141,134,140,0,141,134,140,34,140,142,141,0,140,142,141,34,112,141,142,0,112,141,142,34,119,141,118,0,119,141,118,34,134,141,143,0,134,141,143,34,143,132,134,0,143,132,134,34,119,144,143,0,119,144,143,34,143,141,119,0,143,141,119,34,120,126,144,0,120,126,144,34,144,119,120,0,144,119,120,34,143,144,128,0,143,144,128,34,128,130,143,0,128,130,143,34,122,127,126,0,122,127,126,34,126,120,122,0,126,120,122,34,132,130,131,0,132,130,131,34,131,133,132,0,131,133,132,34,134,132,133,0,134,132,133,34,133,124,134,0,133,124,134,34,115,113,154,0,115,113,154,34,154,153,115,0,154,153,115,34,153,154,147,0,153,154,147,34,147,146,153,0,147,146,153,34,154,113,112,0,154,113,112,34,112,155,154,0,112,155,154,34,147,154,155,0,147,154,155,34,155,148,147,0,155,148,147,34,156,155,112,0,156,155,112,34,112,142,156,0,112,142,156,34,148,155,156,0,148,155,156,34,156,149,148,0,156,149,148,34,157,156,142,0,157,156,142,34,142,140,157,0,142,140,157,34,156,157,150,0,156,157,150,34,150,149,156,0,150,149,156,34,140,125,158,0,140,125,158,34,158,157,140,0,158,157,140,34,159,152,49,0,159,152,49,34,49,57,159,0,49,57,159,34,153,146,152,0,153,146,152,34,152,159,153,0,152,159,153,34,148,161,160,0,148,161,160,34,160,147,148,0,160,147,148,34,160,161,59,0,160,161,59,34,59,60,160,0,59,60,160,34,49,152,160,0,49,152,160,34,160,60,49,0,160,60,49,34,164,137,136,0,164,137,136,34,136,135,164,0,136,135,164,34,166,165,146,0,166,165,146,34,146,147,166,0,146,147,166,34,146,165,168,0,146,165,168,34,168,152,146,0,168,152,146,34,168,169,160,0,168,169,160,34,160,152,168,0,160,152,168,34,160,169,166,0,160,169,166,34,166,147,160,0,166,147,160,34,170,167,173,0,170,167,173,34,170,173,172,0,170,173,172,34,171,170,172,0,171,170,172,34,169,168,165,0,169,168,165,34,165,166,169,0,165,166,169,34,167,170,161,0,167,170,161,34,161,148,167,0,161,148,167,34,162,161,170,0,162,161,170,34,170,171,162,0,170,171,162,34,172,150,162,0,172,150,162,34,162,171,172,0,162,171,172,34,172,173,149,0,172,173,149,34,149,150,172,0,149,150,172,34,149,173,167,0,149,173,167,34,167,148,149,0,167,148,149,34,178,175,124,0,178,175,124,34,124,133,178,0,124,133,178,34,122,124,175,0,122,124,175,34,175,174,122,0,175,174,122,34,122,174,176,0,122,174,176,34,176,127,122,0,176,127,122,34,177,129,127,0,177,129,127,34,127,176,177,0,127,176,177,34,131,129,177,0,131,129,177,34,133,131,177,0,133,131,177,34,177,178,133,0,177,178,133,34,176,178,177,0,176,178,177,34,178,176,174,0,178,176,174,34,174,175,178,0,174,175,178,34,68,164,182,0,68,164,182,34,182,179,68,0,182,179,68,34,68,179,180,0,68,179,180,34,180,30,68,0,180,30,68,34,135,30,180,0,135,30,180,34,180,181,135,0,180,181,135,34,182,164,135,0,182,164,135,34,135,181,182,0,135,181,182,34,182,186,183,0,182,186,183,34,183,179,182,0,183,179,182,34,183,184,180,0,183,184,180,34,180,179,183,0,180,179,183,34,180,184,185,0,180,184,185,34,185,181,180,0,185,181,180,34,185,186,182,0,185,186,182,34,182,181,185,0,182,181,185,34,183,186,185,0,183,186,185,34,185,184,183,0,185,184,183,34,157,158,151,0,157,158,151,34,151,150,157,0,151,150,157,34,161,162,63,0,161,162,63,34,63,59,161,0,63,59,161,34,63,162,163,0,63,162,163,34,163,65,63,0,163,65,63,34,137,139,136,0,137,139,136,34,137,151,158,0,137,151,158,34,158,139,137,0,158,139,137,34,187,110,65,0,187,110,65,34,65,163,187,0,65,163,187,34,164,68,110,0,164,68,110,34,110,187,164,0,110,187,164,34,137,187,163,0,137,187,163,34,163,151,137,0,163,151,137,34,112,113,111,0,112,113,111,34,111,141,112,0,111,141,112,34,145,159,57,0,145,159,57,34,57,42,145,0,57,42,145,34,153,159,145,0,153,159,145,34,145,115,153,0,145,115,153,34,10,11,119,0,10,11,119,34,119,118,10,0,119,118,10,34,117,8,7,0,117,8,7,34,7,116,117,0,7,116,117,34,118,141,111,0,118,141,111,34,111,116,118,0,111,116,118,34,10,118,116,0,10,118,116,34,116,7,10,0,116,7,10,34,200,188,189,1,200,188,189,34,189,201,200,1,189,201,200,34,202,190,191,1,202,190,191,34,191,203,202,1,191,203,202,34,203,191,188,1,203,191,188,34,188,200,203,1,188,200,203,34,188,191,190,1,188,191,190,34,190,189,188,1,190,189,188,34,200,201,202,1,200,201,202,34,202,203,200,1,202,203,200,34,201,189,192,1,201,189,192,34,192,204,201,1,192,204,201,34,204,192,193,1,204,192,193,34,193,205,204,1,193,205,204,34,205,193,190,1,205,193,190,34,190,202,205,1,190,202,205,34,189,190,193,1,189,190,193,34,193,192,189,1,193,192,189,34,201,204,205,1,201,204,205,34,205,202,201,1,205,202,201,34,206,194,197,1,206,194,197,34,197,207,206,1,197,207,206,34,207,197,196,1,207,197,196,34,196,208,207,1,196,208,207,34,209,195,194,1,209,195,194,34,194,206,209,1,194,206,209,34,194,195,196,1,194,195,196,34,196,197,194,1,196,197,194,34,206,207,208,1,206,207,208,34,208,209,206,1,208,209,206,34,208,196,199,1,208,196,199,34,199,210,208,1,199,210,208,34,210,199,198,1,210,199,198,34,198,211,210,1,198,211,210,34,211,198,195,1,211,198,195,34,195,209,211,1,195,209,211,34,195,198,199,1,195,198,199,34,199,196,195,1,199,196,195,34,209,208,210,1,209,208,210,34,210,211,209,1,210,211,209]

};