// Wall with pilars poking out of it.

THREE.StoneSinus = function(ding) {
	THREE.Object3D.call(this);

	this.type = 'StoneSinus';

	var rockMat = new THREE.MeshPhongMaterial({
		color: 0xA0A09F,
		//shading: THREE.FlatShading
	});
	var rockMat2 = new THREE.MeshPhongMaterial({
		color: 0x5C5C5C,
		//shading: THREE.FlatShading
	});

	//console.log(this);

	this.wallGeo = new THREE.BoxGeometry(100,100,240);
	this.wallGeo = bevelBoxEdges(this.wallGeo,2);
	this.wallGeo.applyMatrix( new THREE.Matrix4().makeTranslation(-50, -50, 0) );
	this.wall = new THREE.Mesh(this.wallGeo, rockMat);
	this.add(this.wall);

	var pilarsWidth = 110;
	var pilarSize = 10;
	var pilarN = 7;

	this.pilars = [];
	for (var i=0; i<pilarN; i++)
	{
		var z = (pilarsWidth/pilarN)*i - pilarsWidth/2 + pilarSize/2;

		var pilarGeo = new THREE.BoxGeometry(pilarSize, 100, pilarSize);
		pilarGeo = bevelBoxEdges(pilarGeo,2);
		pilarGeo.applyMatrix( new THREE.Matrix4().makeTranslation(0,-50, z) );
		this.pilars.push(new THREE.Mesh(pilarGeo, rockMat2));
		this.pilars[i].position.y = 10;
		this.pilars[i].position.x = -10;
		this.pilars[i].neonColors = {
				true: {
					"inner": new THREE.Color(1.0, 1.0, 1.0),
					"outer": new THREE.Color(1.0, 1.0, 0.0)
				},
				false: {
					"inner": new THREE.Color(0.5, 0.5, 0.5),
					"outer": new THREE.Color(0.3, 0.3, 0.3)
				}
			}

		this.pilars[i].neonMaterial = new THREE.ShaderMaterial({
				uniforms: {
					"OuterColor": { "type": "c", "value": this.pilars[i].neonColors[true]["outer"] },
					"InnerColor": { "type": "c", "value": this.pilars[i].neonColors[true]["inner"] }
				},
				vertexShader: shaders.vertexShader_microscope,
				fragmentShader: shaders.fragmentShader_microscope
			});
		this.pilars[i].material = this.pilars[i].neonMaterial;
		//this.pilars[i].customOverrideMaterial = new THREE.MeshBasicMaterial({color:0x000000});

		this.pilars[i].neonLight = new THREE.PointLight(0xffff00, 1, 35);
		this.pilars[i].neonLight.position.set(-10, 15, z);
		this.add(this.pilars[i]);
		this.add(this.pilars[i].neonLight);
	}


	this.animate = function(n)
	{
		for (var i=0; i<this.pilars.length; i++)
		{
			var s = (Math.sin(i*1.2 + n*5)*0.5+0.5);
			s2 = easeOne('easeInOutBack',s);
			var y = 10 + s2*7;

			s2 = s2>1 ? 1 : s2;
			s2 = s2<0 ? 0 : s2;

			s2 = segmentTransition(0.3,1.0,s);

			this.pilars[i].position.set(this.pilars[i].position.x, y, this.pilars[i].position.z);

			var colorInner = new THREE.Color(this.pilars[i].neonColors[false]["inner"].r, this.pilars[i].neonColors[false]["inner"].g, this.pilars[i].neonColors[false]["inner"].b);
			var colorOuter = new THREE.Color(this.pilars[i].neonColors[false]["outer"].r, this.pilars[i].neonColors[false]["outer"].g, this.pilars[i].neonColors[false]["outer"].b);

			this.pilars[i].neonMaterial.uniforms.InnerColor.value = colorInner.lerp(this.pilars[i].neonColors[true]["inner"], s2);
			this.pilars[i].neonMaterial.uniforms.OuterColor.value = colorOuter.lerp(this.pilars[i].neonColors[true]["outer"], s2);

			this.pilars[i].neonLight.intensity = s2;
			
		}
	}

};

THREE.StoneSinus.prototype = Object.create(THREE.Object3D.prototype);
THREE.StoneSinus.prototype.constructor = THREE.StoneSinus;