function reduceGeometry (geometry2, k)
{
	var modifier = new THREE.SubdivisionModifier(0);

	var smooth2 = geometry2.clone();
	smooth2.mergeVertices();

	modifier.modify(smooth2);

	var simplify = new THREE.SimplifyModifier(400);
	var sortedGeometry2 = simplify.modify(smooth2);


	var map = sortedGeometry2.map;
	var permutations = sortedGeometry2.sortedGeometry2;
	var sortedVertices = sortedGeometry2.vertices;
	var t = sortedVertices.length - 1;
	t = t * k | 0;
	var numFaces = 0;
	var face;
	var geometry2 = smooth2;
	for (i = 0; i < geometry2.faces.length; i++) {
		face = geometry2.faces[i];
		var oldFace = sortedGeometry2.faces[i];
		face.a = oldFace.a;
		face.b = oldFace.b;
		face.c = oldFace.c;
		while (face.a > t) face.a = map[face.a];
		while (face.b > t) face.b = map[face.b];
		while (face.c > t) face.c = map[face.c];
		if (face.a !== face.b && face.b !== face.c && face.c !== face.a) numFaces++;
	}

	geometry2.mergeVertices();

	geometry2.computeFaceNormals();
	geometry2.verticesNeedUpdate = true;
	geometry2.normalsNeedUpdate = true;

	return geometry2;
}