THREE.OverlayPass = function ( texture, opacity ) {

	this.uniforms = {

		"tDiffuse": { type: "t", value: null },
		"opacity":  { type: "f", value: opacity },
		overlayTexture: { type: "t", value: texture }
	}
	

	this.material = new THREE.ShaderMaterial( {

		uniforms: this.uniforms,
		vertexShader: THREE.CopyShader.vertexShader,
		fragmentShader: shaders.fragmentShader_overlay,

	} );

	this.enabled = true;
	this.needsSwap = true;


	this.camera = new THREE.OrthographicCamera( -1, 1, 1, -1, 0, 1 );
	this.scene  = new THREE.Scene();

	this.quad = new THREE.Mesh( new THREE.PlaneGeometry( 2, 2 ), null );
	this.scene.add( this.quad );

};

THREE.OverlayPass.prototype = {

	render: function ( renderer, writeBuffer, readBuffer, delta ) {

		this.quad.material = this.material;
		
		if ( this.renderToScreen ) {

			renderer.render( this.scene, this.camera );

		} else {

			renderer.render( this.scene, this.camera, writeBuffer );

		}
		

	}

};