// Credits cene

var Scene = (function() {
	var lerp = function(s, e, p) {
		return s - ((s - e) * p);
	}

return {
	id: getIdForLastLoadedScript(),

	wiggleCoordinates: function(geo, dist, seed)
	{
		for (var i=0; i < geo.vertices.length; i++)
		{
		geo.vertices[i].x += (Math.random()-0.5)*dist;
		geo.vertices[i].y += (Math.random()-0.5)*dist;
		geo.vertices[i].z += (Math.random()-0.5)*dist;
		}
		geo.computeFaceNormals();
		geo.computeVertexNormals();
	},

	getGroundY: function(x,z)
	{
		var y = noise.perlin2(x/70+400, z/70+400)*5;
		y += noise.perlin2(x/10,z/10)*1.5;
		y -= 15;
		return y;
	},
	

	load: function()
	{
		this.scene = new THREE.Scene();
		/*
		var ambient = new THREE.AmbientLight( 0xffffff );
		ambient.color.setHSL( 0.1, 0.3, 0.2 );
		this.scene.add( ambient );

		var dirLight = new THREE.DirectionalLight( 0xffffff, 0.125 );
		dirLight.position.set( 0, 10, -20 ).normalize();
		dirLight.color.setHSL( 0.1, 0.7, 0.7 );
		this.scene.add( dirLight );

		var light = new THREE.PointLight( 0xffffff, 1.5, 4500 );
		light.color.setHSL( 0.55, 0.9, 0.5 );
		light.position.set( -10, 10, -10 );
		this.scene.add( light );
		*/
		/*
		this.axishelper = new THREE.AxisHelper(5);
		this.scene.add(this.axishelper);
		*/
		/*
		var light = new THREE.HemisphereLight( 0xffffff, 0x000000, .5 );
		light.position.y = 100;
		this.scene.add( light );
		*/

		this.light2 = new THREE.PointLight(0xffffff, 1, 150);
		//this.light2.castShadow = true;
		this.light2.position.set(50,100,50);
		this.scene.add(this.light2);

		// Maybe this is better than mocking around with emissive colors and shit?
		this.dirLight1 = new THREE.DirectionalLight(0xffffff, 0.4);
		this.dirLight2 = new THREE.DirectionalLight(0xffffff, 0.4);
		this.dirLight1.position.set(1,1,1);
		this.dirLight2.position.set(-1,0,0);
		this.dirLight3 = new THREE.DirectionalLight(0xffffff, 0.2);
		this.dirLight4 = new THREE.DirectionalLight(0xffffff, 0.2);
		this.dirLight3.position.set(0,0,1);
		this.dirLight4.position.set(0,0,-1);
		this.scene.add(this.dirLight1);
		this.scene.add(this.dirLight2);
		this.scene.add(this.dirLight3);
		this.scene.add(this.dirLight4);

		this.pointLight = new THREE.PointLight(0xFFFFC0, 1, 30);
		this.pointLight.position.set(0,1000,0);
		this.scene.add(this.pointLight);



		// Cave with tunnels
		this.cave = new THREE.Cave(100);
		this.scene.add(this.cave);


		// Load awesome people
		tex.credits1 = load_texture(texture_dir+'greets/chr.png','Credits1');
		tex.credits2 = load_texture(texture_dir+'greets/nitelite.png','Credits2');
		tex.credits3 = load_texture(texture_dir+'greets/chiller.png','Credits3');
		tex.credits4 = load_texture(texture_dir+'greets/axel.png','Credits4');
		tex.credits5 = load_texture(texture_dir+'greets/audiopeeps.png','Credits5');
		tex.credits6 = load_texture(texture_dir+'greets/indigo.png','Credits6');


		// Add some grassy shit

		var groundGeo = new THREE.PlaneGeometry(220,220,30,30);
		groundGeo.applyMatrix( new THREE.Matrix4().makeRotationX(deg2rad(-90)) );


		for (var i=0; i<groundGeo.vertices.length; i++)
		{
			var x = groundGeo.vertices[i].x;
			var z = groundGeo.vertices[i].z;

			var y = this.getGroundY(x,z);

			groundGeo.vertices[i].y = y;
		}

		groundGeo.computeVertexNormals();
		groundGeo.computeFaceNormals();

		var matGround = new THREE.MeshLambertMaterial({
			//ambient: 0x999999,
			color: 0x198515,
			//emissive: 0x222222,
			shading: THREE.FlatShading,
			//side: THREE.DoubleSide,
			wireframe: false
		});

		this.ground = new THREE.Mesh(groundGeo, matGround);
		this.scene.add(this.ground);


		// Add some oxygen producers
		var nTrees = 18;
		this.trees = [];
		Math.seedrandom(99754);
		for (var i=0; i<nTrees; i++)
		{
			var tree = new THREE.Busk({seed:i+40, leafCount:4});
			var radius = Math.random()*60+30;
			var angle = (i/nTrees)*Math.PI*2;
			var x = Math.sin(angle)*radius;
			var z = Math.cos(angle)*radius;
			var y = this.getGroundY(x,z);
			tree.position.set(x,y,z);
			tree.scale.set(0.7,0.7,0.7);
			this.scene.add(tree);
			this.trees.push(tree);
		}

		// Add some rock
		var nRocks = 20;
		this.rocks = [];
		Math.seedrandom(4443);
		for (var i=0; i<nRocks; i++)
		{
			var rock = makeRock(1.5+Math.random()*0.5, 3, i+5555);

			var radius = Math.random()*60+25;
			var angle = (i/nTrees)*Math.PI*2;
			var x = Math.sin(angle)*radius;
			var z = Math.cos(angle)*radius;
			var y = this.getGroundY(x,z)+0.2;
			rock.position.set(x,y,z);
			this.scene.add(rock);
			this.trees.push(rock);
		}

		// Add a windmill in the center.

		this.windmill = new THREE.Windmill(8);
		this.windmill.position.set(0,0,10);
		this.windmill.rotation.set(0,deg2rad(15),0);
		this.windmill.position.y = this.getGroundY(0,25);
		//this.windmill.rotation.y = deg2rad(85);
		this.scene.add(this.windmill);


		this.fan1 = new THREE.IndustrialFan(15,7);
		this.fan1.position.y = 20;
		this.fan1.position.x = -85;
		this.fan1.rotation.y = deg2rad(90);
		this.scene.add(this.fan1);
		this.fan2 = new THREE.IndustrialFan(15,7);
		this.fan2.position.y = 20;
		this.fan2.position.x = 85;
		this.fan2.rotation.y = deg2rad(-90);
		this.scene.add(this.fan2);


		this.sign = new THREE.Sign();
		this.sign.scale.set(0.2,0.2,0.2);
		this.sign.rotation.y = deg2rad(180);
		this.sign.position.y = this.getGroundY(0,-25);
		this.sign.position.z = -25;
		this.scene.add(this.sign);


		this.blinkyBox = new THREE.BlinkyBox(10);
		this.blinkyBox.position.set(0,25,0);
		this.scene.add(this.blinkyBox);


		// Add the credit pigs
		this.creditsN = 5;
		this.creditObjects = [];
		this.badges = [];
		this.badgeHeight = 6.5;
		for (var i=0; i<this.creditsN; i++)
		{
			this.creditObjects.push([]);

			var radius = 70;
			var angle = (i/this.creditsN)*Math.PI*2*-1;
			var x = Math.sin(angle)*radius;
			var z = Math.cos(angle)*radius;
			var y = this.getGroundY(x,z)+0.2;

			var pig = new THREE.PoffPig(5,15,40, 20, 1+i);
			pig.position.set(x,y,z);
			pig.scale.set(0.5, 0.5, 0.5);
			pig.lookAt( new THREE.Vector3(0,y,0) );
			pig.animate(1);
			this.creditObjects[i].push(pig);
			this.scene.add(this.creditObjects[i][0]);

			var badge = new THREE.Badge( tex['credits'+(i+1)] );
			badge.position.set(x,y+this.badgeHeight+3,z);
			this.badges.push(badge);
			this.scene.add(this.badges[i]);
		}


		var objectsSeed = [10,11,3,9,234234,7023423];
		for (var i=0; i<this.creditsN; i++)
		{
			var num = 5;
			Math.seedrandom(objectsSeed[i]);
			var offset = Math.random()*10;
			for (var u=0; u<2; u++)
			{
				var radius = 13 + Math.random()*7;
				var angle = (u/num)*Math.PI*2 + offset;
				var x = Math.sin(angle)*radius + this.creditObjects[i][0].position.x;
				var z = Math.cos(angle)*radius + this.creditObjects[i][0].position.z;
				var y = this.getGroundY(x,z)+0.2;

				var house = new THREE.House(4+Math.random()*5,4+Math.random()*5,4+Math.random()*5,10+Math.random()*30);
				house.position.set(x,y,z);
				house.rotation.set(0,Math.random()*Math.PI*2,0);
				house.animate(1);
				this.scene.add(house);
				this.creditObjects[i].push(house);
			}
		}


		// Do the rendering shit
		this.composer = new THREE.EffectComposer(renderer);

		this.camera = new THREE.PerspectiveCamera(55, 16/9, 1, 4000);
		this.camera.position.x = 150;
		this.camera.position.y = 75;

		//this.controls = new THREE.OrbitControls( this.camera );
		//this.controls.addEventListener('change',render);

		// SSAO Depth
		this.depthShader = THREE.ShaderLib[ "depthRGBA" ];
		this.depthUniforms = THREE.UniformsUtils.clone( this.depthShader.uniforms );

		this.depthMaterial = new THREE.ShaderMaterial({
		fragmentShader: this.depthShader.fragmentShader,
		vertexShader: this.depthShader.vertexShader,
		uniforms: this.depthUniforms
		});
		this.depthMaterial.blending = THREE.NoBlending;

		this.depthTarget = new THREE.WebGLRenderTarget( wWidth, wHeight, {
		minFilter: THREE.NearestFilter,
		magFilter: THREE.NearestFilter,
		format: THREE.RGBAFormat
		});

		this.renderPass = new THREE.RenderPass(this.scene, this.camera);
		this.composer.addPass(this.renderPass);


		this.SSAOPass = new THREE.ShaderPass( THREE.SSAOShader );
		this.SSAOPass.uniforms[ 'tDepth' ].value = this.depthTarget;
		this.SSAOPass.uniforms[ 'size' ].value.set( wWidth * 0.75, wHeight * 0.75 );
		this.SSAOPass.uniforms[ 'cameraNear' ].value = this.camera.near;
		this.SSAOPass.uniforms[ 'cameraFar' ].value = this.camera.far;
		this.SSAOPass.uniforms[ 'aoClamp' ].value = 0.5;
		this.SSAOPass.enabled = true;
		this.composer.addPass( this.SSAOPass );

		this.composer.addPass(final_pass);
	},

	render: function(time, percent) 
	{

		//this.controls.update();

		this.cave.controlCamera(this.camera);

		for (var i=0; i<this.badges.length; i++)
		{
			this.badges[i].lookAt( new THREE.Vector3( this.camera.position.x, this.badges[i].position.y, this.camera.position.z) );
		}

		this.fan1.animate(2.5,time);
		this.fan2.animate(2.5,time);

		this.blinkyBox.rotation.set(time*0.7*1.5,time*1.5,time*1.2*1.5);

		var bnb = getVal('var4')
		if (bnb >= 100)
		{
			bnb = bnb-100;
		} else
		{
			bnb = 1;
		}

		var bn = easeOne('easeInQuint', getVal('var3'));
		this.blinkyBox.animate( bn * bnb );

		this.windmill.animate(getVal('var2'), time);

		// Animate the greet stuffs

		var c = getVal('var1');

		var hOffset = 0.2;

		var hTime1 = segmentTransition(0.0, hOffset*2, c);
		var hTime2 = segmentTransition(hOffset*1, hOffset*2, c);
		var hTime3 = segmentTransition(hOffset*2, hOffset*3, c);
		var hTime4 = segmentTransition(hOffset*3, hOffset*4, c);
		var hTime5 = segmentTransition(hOffset*4, hOffset*5, c);

		for (var i=0; i<this.creditsN; i++)
		{
			var n = (c-i);
			n = n<0 ? 0 : n;
			n = n>1 ? 1 : n;

			this.creditObjects[i][0].animate(segmentTransition(0.0, 0.5, n));
			this.badges[i].animate(segmentTransition(0.4, 0.7, n));
			this.creditObjects[i][1].animate(segmentTransition(0.1, 0.9, n), time);
			this.creditObjects[i][2].animate(segmentTransition(0.1, 1.0, n), time);
		}

		if (c > 0.00000001 && c <4.99999999999999)
		{
			var lpos = this.cave.getOrbit(deg2rad(getVal('var7')-100), deg2rad(getVal('var6')), 85);

			this.pointLight.position.set(lpos);
			//console.log(this.pointLight.position);
		} else
		{
			this.pointLight.position.set(0,1000,0);
		}



		this.scene.overrideMaterial = this.depthMaterial;
		renderer.render( this.scene, this.camera, this.depthTarget );

		this.scene.overrideMaterial = null;
		this.composer.render();
		}
	};
})();

var scenes = scenes || [];
scenes[Scene.id] = Scene;

