var Scene = (function() {
	var lerp = function(s, e, p) {
		return s - ((s - e) * p);
	}

  	return {
		id: getIdForLastLoadedScript(),
		load: function()
		{

			var BLUR_FILTER =
			{
					Apply: function( inCanvas, inParameters )
					{
							boxBlurCanvasRGB( inCanvas, 0, 0, inCanvas.width, inCanvas.height, Math.round(inParameters.filterparam), 2 );
					}
			};

			var RAND_DEFAULT =
			{
					Random: function()
					{
						return Math.random();
					}
			};

			var MOUNTAINS_COLORS =
			{
					Apply: function( inGeometry, inParameters )
					{
							var step = 1000;
							var colors = inGeometry.getAttribute( 'color' ).array;
							var positions = inGeometry.getAttribute( 'position' ).array;

							for( var i = 0; i < positions.length; i += 3 )
							{
									var depth = Math.min( 1, 0.2 + ( 0.85 + 0.3 * inParameters.alea.Random() ) * 0.8 * Math.round( step * positions[i + 1] / inParameters.depth ) / step );

									colors[i] = depth * depth;
									colors[i + 1] = depth;
									colors[i + 2] = depth * depth * depth;
							}
					},
			};

			var DEPTHNOISE_EFFECT =
			{
					Apply: function( inGeometry, inParameters )
					{
							var positions = inGeometry.getAttribute( 'position' ).array,
							scaleDepth = inParameters.depth / 255;

							for( var i = 1; i < positions.length; i += 3 )
							{
									positions[i] += scaleDepth * inParameters.alea.Random();
							}
					},
			};

			var parameters = {
					alea: RAND_DEFAULT,
					generator: this.PN_GENERATOR,
					width: 500,
					height: 500,
					widthSegments: 250,
					heightSegments: 250,
					depth: 150,
					param: 3,
					filterparam: 1,
					filter: [ BLUR_FILTER ],
					postgen: [ MOUNTAINS_COLORS ],
					effect: [ DEPTHNOISE_EFFECT ],
					canvas: document.getElementById('heightmap'),
			};

			var terrainGeo = TERRAINGEN.Get( parameters );
			var terrainMaterial = new THREE.MeshPhongMaterial({
				vertexColors: THREE.VertexColors,
				shading: (THREE.SmoothShading)
			});

			var terrain = new THREE.Mesh( terrainGeo, terrainMaterial );
			terrain.position.y = - inParameters.depth / 2;

			if( this.ms_Terrain != null )
					this.ms_Scene.remove( this.ms_Terrain );

			this.scene.add( terrain );
			this.ms_Terrain = terrain;
			this.ms_Terrain.castShadow = true;
			this.ms_Terrain.receiveShadow = true;

			this.Display();


			this.scene = new THREE.Scene();
			this.composer = new THREE.EffectComposer(renderer);

			var ambient = new THREE.AmbientLight( 0xffffff );
			ambient.color.setHSL( 0.1, 0.3, 0.2 );
			this.scene.add( ambient );

			var dirLight = new THREE.DirectionalLight( 0xffffff, 0.125 );
			dirLight.position.set( 0, 10, -20 ).normalize();
			dirLight.color.setHSL( 0.1, 0.7, 0.7 );
			this.scene.add( dirLight );

			var light = new THREE.PointLight( 0xffffff, 1.5, 4500 );
  		light.color.setHSL( 0.55, 0.9, 0.5 );
			light.position.set( -10, 10, -10 );
			this.scene.add( light );

			this.camera = new THREE.PerspectiveCamera(45, 16/9, 0.1, 100);
			this.camera.position.set(0, 10, -30);
			this.camera.lookAt(new THREE.Vector3(0, 0, 0));

			var mat = new THREE.MeshLambertMaterial({
				ambient: 0x999999,
				color: 0xfd7a7b,
				emissive: 0x6a2323,
				shading: THREE.FlatShading
			});

			var green = new THREE.MeshLambertMaterial({
				ambient: 0x999999,
				color: 0x80a93f,
				emissive: 0x394c1c,
				shading: THREE.FlatShading
			});

			var geometry = new THREE.BoxGeometry( 1, 1, 1 );
			var cube = new THREE.Mesh( geometry, mat );
			this.scene.add( cube );

			controls = new THREE.OrbitControls( this.camera );
			controls.damping = 0.2;
			controls.addEventListener( 'change', render );

			var axisHelper = new THREE.AxisHelper( 5 );
			this.scene.add( axisHelper );

			this.renderPass = new THREE.RenderPass(this.scene, this.camera);
			this.composer.addPass(this.renderPass);
			this.composer.addPass(final_pass);

		},

		render: function(time, percent)
		{
			this.composer.render();
		}
	};

})();

var scenes = scenes || [];
scenes[Scene.id] = Scene;
