#version 330 core

layout(location = 0) in vec3 vertexPosition_modelspace;
//layout(location = 1) in vec2 vertexUV;

// Output data
//out vec2 texCoord;

uniform mat4 MVP;
uniform float time;
uniform vec2 Distort;
uniform vec2 DistortSpeed;


void main()
{
    vec4 vertex = vec4(vertexPosition_modelspace,1); // Transform an homogeneous 4D vector, remember ?

	vertex.x = vertex.x + cos(time * 2 + vertex.y)*.9;
	vertex.y = vertex.y + sin(time * 4 + vertex.x)*1.5;
	vertex.z = vertex.z + sin(time * 3 + vertex.x)*1.4;
	//texCoord = vertexUV;

    gl_Position = MVP * vertex;
}