#version 330 core

// Input data
in vec2 texCoord;
in vec3 ViewDirection;
in vec3 Normal;

// Output data
out vec4 color;

// Values that stay constant for the whole draw.
uniform vec4 Diffuse;
uniform vec4 Ambient;
uniform vec4 Specular;

uniform float SpecularPower;
uniform float Sync;

uniform sampler2D ambientMap;
uniform sampler2D bumpMap;
uniform sampler2D diffuseMap;
uniform sampler2D specularMap;

uniform bool ambientMapActive;
uniform bool bumpMapActive;
uniform bool diffuseMapActive;
uniform bool emissionMapActive;
uniform bool shininessMapActive;
uniform bool specularMapActive;
uniform bool transparencyMapActive;

vec4 ambientColor;
vec3 nNormal;
vec4 diffuseColor;
vec4 SpecularColor;


#define MAX_LIGHTS 10
in vec3 directions[MAX_LIGHTS];

uniform int numLights;
uniform struct Light
{
	uint type; // 0=invalid - 1=Point Light - 2=Ambient Light - 3=Directional Light - 4=Spot Light
	vec3 position;
	vec3 direction;
	vec3 color;
	float intensity;
	float coneAngle;
	float penumbraAngle;	// see "http://buzzking.me/?p=486"
	float dropOff;
} allLights[MAX_LIGHTS];

vec4 calcLights(Light light, vec3 direction)
{
	vec3 tempLightDirection = normalize(direction);
	float dotLight = dot( nNormal, tempLightDirection );
	vec3 tempReflection = normalize(((2.0 * nNormal) * dotLight) - tempLightDirection);
	vec3 tempViewDirection = normalize(ViewDirection);
	float tempRDotV = max(0.0, dot(tempReflection, tempViewDirection));

	vec4 tempDiffuseColor = diffuseColor * dotLight * light.intensity * vec4(light.color, 1.0);

	vec4 tempSpecularColor = SpecularColor* pow(tempRDotV, SpecularPower);

	return tempDiffuseColor + tempSpecularColor;
}

void main(void)
{
	if(ambientMapActive)
	{
		ambientColor = texture(ambientMap, texCoord);
	}
	else
	{
		ambientColor = Ambient;
	}
	
	if(bumpMapActive)
	{
		nNormal = normalize( (texture(bumpMap, texCoord).xyz * 2.0) - 1.0);
    }
	else
	{
		nNormal = Normal;
	}

	if(diffuseMapActive)
	{
		diffuseColor = texture(diffuseMap, texCoord);
	}
	else
	{
		diffuseColor = Diffuse;
	}

	if(specularMapActive)
	{
		SpecularColor = texture(specularMap, texCoord);
    }
	else
	{
		SpecularColor = Specular;
	}
	vec4 AmbientColor = ambientColor * diffuseColor;

	color = vec4(0);
	for(int i = 0; i < numLights; ++i)
	{
		color += calcLights(allLights[i], directions[i]);
    }

	color += AmbientColor;
	//color = vec4(0.2, 0.0, 7.0, 1.0);
	//color = texture(diffuseMap, texCoord);
	//color = vec4(Normal.x, Normal.y, Normal.z, 1.0);
}