#version 330 core

// Input data
layout(location = 0) in vec3 vertexPosition_modelspace;
layout(location = 1) in vec2 vertexUV;
layout(location = 2) in vec3 vertexNormal_modelspace;
layout(location = 3) in vec3 vertexTangent_modelspace;
layout(location = 4) in vec3 vertexBiTangent_modelspace;

// Output data
out vec2 texCoord;
out vec3 ViewDirection;
out vec3 Normal;
out float dist;

// Values that stay constant for the whole draw.
uniform mat4 MVP;
uniform mat4 V;
uniform mat4 M;
uniform mat3 MV3x3;
out vec3 EyeDirection_cameraspace;
out vec3 LightDirection_cameraspace;
out vec3 LightDirection_tangentspace;
out vec3 EyeDirection_tangentspace;
out vec3 Position_worldspace;

uniform vec3 eyePosition;
uniform float Time;

uniform bool bumpMapActive;

vec3 tangent;
vec3 binormal;
vec4 objectPosition;
vec3 nBinormal;
vec3 nTangent;
vec3 nViewDirection;

#define MAX_LIGHTS 10
out vec3 directions[MAX_LIGHTS];
out float distances[MAX_LIGHTS];

uniform int numLights;
uniform struct Light
{
	uint type; // 0=invalid - 1=Point Light - 2=Ambient Light - 3=Directional Light - 4=Spot Light
	vec3 position;
	vec3 direction;
	vec3 color;
	float intensity;
	float coneAngle;
	float penumbraAngle;	// see "http://buzzking.me/?p=486"
	float dropOff;
} allLights[MAX_LIGHTS];

vec3 calcLights(Light light)
{
	vec3 tempDirection;

	if(bumpMapActive)
	{
		nViewDirection = eyePosition - objectPosition.xyz;
		ViewDirection.x = dot(vertexTangent_modelspace, nViewDirection);
		ViewDirection.y = dot(nBinormal, nViewDirection);
		//ViewDirection.y = dot(vertexBiTangent_modelspace, nViewDirection);
		ViewDirection.z = dot(Normal, nViewDirection);

		vec3 lightDirection = (V * M * vec4(light.position, 1)).xyz - objectPosition.xyz;

		tempDirection.x = dot(nTangent, lightDirection);
		tempDirection.y = dot(nBinormal, lightDirection);
		tempDirection.z = dot(Normal, lightDirection);
    }	
	else
	{
		tempDirection = (V * M * vec4(light.position, 1)).xyz - objectPosition.xyz;
		ViewDirection = eyePosition - objectPosition.xyz;
    }

	return tempDirection;
}

void main(void)
{
	gl_Position =  MVP * vec4(vertexPosition_modelspace,1);
	texCoord = vertexUV;
	objectPosition = V * M * vec4(vertexPosition_modelspace,1);
	Normal = vec4((transpose(inverse(V * M))) *  vec4(vertexNormal_modelspace,0)).xyz;

	tangent = normalize(vertexTangent_modelspace);
	binormal = normalize(vertexBiTangent_modelspace);

	nBinormal = vec4((transpose(inverse(V * M))) * vec4(binormal,0)).xyz;
	nTangent = vec4((transpose(inverse(V * M))) * vec4(tangent,0)).xyz;

	for(int i = 0; i < numLights; ++i)
	{
		directions[i] = calcLights(allLights[i]);
		distances[i] = length(allLights[i].position - ((V * M * vec4(allLights[i].position, 1)).xyz - objectPosition.xyz));
    }

	// Position of the vertex, in worldspace : M * position
	Position_worldspace = (M * vec4(vertexPosition_modelspace,1)).xyz;

	// model to camera = ModelView
	vec3 vertexTangent_cameraspace = MV3x3 * vertexTangent_modelspace;
	vec3 vertexBitangent_cameraspace = MV3x3 * vertexBiTangent_modelspace;
	vec3 vertexNormal_cameraspace = MV3x3 * vertexNormal_modelspace;
	
	mat3 TBN = transpose(mat3(
		vertexTangent_cameraspace,
		vertexBitangent_cameraspace,
		vertexNormal_cameraspace	
	)); // You can use dot products instead of building this matrix and transposing it. See References for details.

	LightDirection_tangentspace = TBN * LightDirection_cameraspace;
	EyeDirection_tangentspace =  TBN * EyeDirection_cameraspace;


}