#version 330 core

// Input vertex data
layout(location = 0) in vec3 particleCenter_worldspace; // Position of the the particle
layout(location = 1) in vec3 squareVertices;

// Output data
out vec2 texCoord;

// Values that stay constant for the whole mesh.
uniform vec3 CameraRight_worldspace;
uniform vec3 CameraUp_worldspace;
uniform mat4 VP;

void main()
{	
	vec3 vertexPosition_worldspace = particleCenter_worldspace + CameraRight_worldspace * squareVertices.x + CameraUp_worldspace * squareVertices.y;

	gl_Position = VP * vec4(vertexPosition_worldspace, 1.0);

	texCoord = squareVertices.xy + vec2(0.5, 0.5);
}

