#version 330 core

layout(location = 0) in vec3 vertexPosition_modelspace;
uniform mat4 MVP;
uniform float time;
uniform float sync;

void main()
{
    vec4 vertex = vec4(vertexPosition_modelspace,1); // Transform an homogeneous 4D vector, remember 

	vertex.x = vertex.x + cos(time * .2 + vertex.y)*.2*(sync*10000);
	vertex.y = vertex.y + sin(time * .6 + vertex.x)*.9*(sync*5000);
	vertex.z = vertex.z + sin(time * 3 + vertex.x)*1.4;

	gl_Position =  MVP * vertex;
}