#version 330 core

layout(location = 0) in vec3 vertexPosition_modelspace;
uniform mat4 MVP;
uniform float time;
uniform float sync;

void main()
{
    vec4 vertex = vec4(vertexPosition_modelspace,1); // Transform an homogeneous 4D vector, remember 

	vertex.x = vertex.x + cos(time * 2 + vertex.y)*1.4;
	vertex.y = vertex.y + sin(time * 4 + vertex.x)*1;
	vertex.z = vertex.z + sin(time * 3 + vertex.x)*1.5;

	gl_Position =  MVP * vertex;
}