#version 330 core

// Input data
in vec2 texCoord;
in vec3 Position_worldspace;
in vec3 Normal;
in vec3 EyeDirection_cameraspace;
in vec3 LightDirection_cameraspace;

// Output data
out vec4 color;

// Values that stay constant for the whole draw.
uniform vec4 Diffuse;
uniform sampler2D diffuseMap;
uniform bool diffuseMapActive;

uniform mat4 MV;
uniform vec3 LightPosition_worldspace;

void main(void)
{
	vec4 diffuseColor;
	if(diffuseMapActive)
	{
		diffuseColor = texture(diffuseMap, texCoord);
	}
	else
	{
		diffuseColor = Diffuse;
	}

	vec3 lightColor = vec3(1,1,1);
	float lightPower = 50.0;
	vec4 ambientColor = vec4(0.2,0.2,0.2,1.0) * diffuseColor;
	vec4 specularColor = vec4(0.5,0.5,0.5,1.0);

	float distance = length( LightPosition_worldspace - Position_worldspace );
	vec3 n = normalize( Normal );
	vec3 l = normalize( LightDirection_cameraspace );
	float cosTheta = clamp( dot( n,l ), 0,1 );
	vec3 E = normalize(EyeDirection_cameraspace);
	vec3 R = reflect(-l,n);
	float cosAlpha = clamp( dot( E,R ), 0,1 );

	color = 
		// Ambient : simulates indirect lighting
		ambientColor +
		// Diffuse : "color" of the object
		diffuseColor * vec4(lightColor, 1.0) * lightPower * cosTheta / (distance*distance) +
		// Specular : reflective highlight, like a mirror
		specularColor * vec4(lightColor, 1.0) * lightPower * pow(cosAlpha,5) / (distance*distance);

	//color = vec4(0.0, 0.0, 0.8, 1.0);
	color = texture(diffuseMap, texCoord);
	//color = vec4(Normal, 1.0);
}