#!/usr/local/bin/php
<?php

ini_set('memory_limit', -1);
ini_set('display_errors', 1);

// Get command line values
$inputUrl = empty($argv[1]) ? 'juvenorge.com' : $argv[1];

// Fetch input source
$cat = nyanCat();
$source = removeWhiteSpace(curl($inputUrl));
$asciiCount = countSpecificChars($source);

// Define drawing rules
$drawIndex = 0;
$ascending = false;

// Define draw areas
$ears = array();
$eyes = array();
$body = array();
$paws = array();
$indices = array(
    $ears,
    $eyes,
    $body,
    $paws
);

// Define colors
$colors = array(
    "0;31", // RED
    "1;33", // YELLOW
    "0;32", // GREEN
    "0;34"  // BLUE
);

foreach ( $asciiCount as $ascii => $count )
{
    $char = mb_chr($ascii);
    for ($charFrame = 0; $charFrame < $count; $charFrame++)
    {
        $catLength = 15;
        $tailLength = intval(exec('tput cols')) - $catLength; 

        for($catPart = 0; $catPart < 4; $catPart++)
        {
            if($catPart == $drawIndex)
            {
                array_unshift($indices[$catPart], $char);
            }
            else
            {
                array_unshift($indices[$catPart], " ");
            }
        }

        if($ascending && $drawIndex > 3)
        {
            $drawIndex = 3;
            $ascending = false;
        }
        else if(!$ascending && $drawIndex < 1)
        {
            $drawIndex = 0;
            $ascending = true;
        }

        foreach ( $cat as $key => $part )
        {
            $tail = array_slice($indices[$key], 0, $tailLength);

            // Add rainbow
            $color = $colors[$key];
            $output = strrev(implode("", $tail));

            // GO!
            echo sprintf("%". $tailLength ."s%s", colorize($color, $output), $part) . "\n";
        }

        $drawIndex = $ascending ? ($drawIndex + 1) : ($drawIndex - 1);
        usleep(20000);
        system('clear');
    }
}


function nyanCat()
{
    return $states = array(
        '  _,------,',
        '_|  /\\_/\\',
        '~|_( % .%)',
        ' ""  ""'
    );
}

function colorize($color, $string)
{
    return sprintf("\033[%sm%s\033[37m", $color, $string);
}

function countSpecificChars($source)
{
   $count = array();
   $length = strlen($source);
   for ( $i = 0; $i < $length; $i++ )
   {
      $char = $source[$i];
      $asciiCode = mb_ord($char);
      $count[$asciiCode] = isset($count[$asciiCode]) ? ($count[$asciiCode] += 1) : 1;
   }
   ksort($count);       
   return $count;
}

function removeWhiteSpace($source)
{
    return preg_replace('/\s+/', '', $source);;
}

function curl($url)
{
   $ch = curl_init();
   curl_setopt($ch, CURLOPT_URL, $url);
   curl_setopt($ch, CURLOPT_HEADER, 0);
   curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
   curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
   $result = curl_exec($ch);
   curl_close($ch);
   return $result;
}

function mb_ord($string)
{
    if (extension_loaded('mbstring') === true)
    {
      mb_language('Neutral');
      mb_internal_encoding('UTF-8');
      mb_detect_order(array('UTF-8', 'ISO-8859-15', 'ISO-8859-1', 'ASCII'));

      $result = unpack('N', mb_convert_encoding($string, 'UCS-4BE', 'UTF-8'));

      if (is_array($result) === true)
      {
         return $result[1];
      }
    }

    return ord($string);
}

function mb_chr($string)
{
    return mb_html_entity_decode('&#' . intval($string) . ';');
}

function mb_html_entity_decode($string)
{
    if (extension_loaded('mbstring') === true)
    {
      mb_language('Neutral');
      mb_internal_encoding('UTF-8');
      mb_detect_order(array('UTF-8', 'ISO-8859-15', 'ISO-8859-1', 'ASCII'));

      return mb_convert_encoding($string, 'UTF-8', 'HTML-ENTITIES');
    }

    return html_entity_decode($string, ENT_COMPAT, 'UTF-8');
}
