#version 430

layout(binding=0) uniform sampler2D texScreen;
layout(binding=1) uniform sampler2D texOverlay;

layout(binding=2) uniform sampler2D texScreen2;

in vec2 uv;

layout(location = 0) out vec4 frag;
layout(location = 1) out vec4 frag2;

uniform float g_time;
/*
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

vec3 tonemapUC2(vec3 x) {
    float A = 0.15;
    float B = 0.50;
    float C = 0.10;
    float D = 0.20;
    float E = 0.02;
    float F = 0.30;
    return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;
}
*/


uniform float flip=1.0;

uniform float overlayAlpha=1.0;

uniform float g_bgAmount = 1.0;
uniform float g_lightAmount = 1.0;
uniform float g_waterClip = 0.0;
uniform float g_bumpStrength = 1.0;

uniform float g_posX = 0.0;
uniform float g_posY = 0.0;

uniform float g_overlayScale = 1.0;

uniform float g_windowWidth = 1280.0;
uniform float g_windowHeight = 720.0;

uniform mat4 viewInvMatrix;


// from Iq: http://www.iquilezles.org/www/articles/texture/texture.htm
vec4 getTexel( sampler2D s, vec2 p ) {
    //return texture2D(s, p);

    highp vec2 texRes = vec2(g_windowWidth, g_windowHeight);
    p = p*texRes+0.5;

    highp vec2 i = floor(p);
    highp vec2 f = p - i;
    f = f*f*f*(f*(f*6.0-15.0)+10.0);
    p = i + f;

    p = (p - 0.5)/texRes;
    return texture2D(s, p);
}

vec3 spreadSpec3(vec3 c, float sp) {
    sp = fract(sp);
    c.r *= smoothstep(1.0, 0.0, (1.0-sp)*1.0);
    c.g *= smoothstep(1.0, 0.0, abs((sp-0.5)*2.0));
    c.b *= smoothstep(1.0, 0.0, sp*1.0);
    return c;
}

vec4 spreadSpec(vec4 c, float sp) {
    sp = fract(sp);
    c.r *= smoothstep(1.0, 0.0, (1.0-sp)*1.0);
    c.g *= smoothstep(1.0, 0.0, abs((sp-0.5)*2.0));
    c.b *= smoothstep(1.0, 0.0, sp*1.0);
    return c;
}



void main() {

    vec2 uvS = uv;
  //  uvS.y = 1.0-uvS.y;
    vec2 uvO = uv+vec2(g_posX, g_posY);

    uvO -= vec2(0.5, 0.5)*1.0;
    uvO *= g_overlayScale;
    uvO += vec2(0.5, 0.5)*1.0;

    vec4 screen = texture2D(texScreen, uvS);
    vec4 screen2 = texture2D(texScreen2, uvS);

    screen -= vec4(g_waterClip);
    screen = clamp(screen, 0.0, 100000.0);

    vec4 so = screen;

    vec4 bg = texture2D(texOverlay, uvS);

    float alffa = clamp(screen.b*0.020, 0.0, 1.0);



    float dm = 1.0;
    float dx = dm/1280.0;
    float dy = dm/720.0;
    float nz = 0.5;

 //   vec3 normal = vec3(getTexel(texScreen, vec2(uvS.x+dx, uvS.y)).r-getTexel(texScreen, vec2(uvS.x-dx*0.0, uvS.y)).r,
  //                getTexel(texScreen, vec2(uvS.x, uvS.y+dy)).r-getTexel(texScreen, vec2(uvS.x, uvS.y-dy*0.0)).r, nz);

    vec3 normal = vec3(texture2D(texScreen, uvS).rgb)*1.0;

//    vec3 normal = vec3(getTexel(texScreen, vec2(uvS)).gb, nz);

 //   normal *= 1.0;
 //   normal.z = 1.0*clamp(sqrt(clamp(1.0-dot(normal.xy, normal.xy), 0.0, 1.0)), 0.0, 1.0);

    screen.rg = vec2(gl_FragCoord.x/g_windowWidth, gl_FragCoord.y/g_windowHeight)-vec2(0.5, 0.5);

    float len = sqrt(dot(normal,normal));

    normal.z *= 2.0;

   // screen.rg *= so.x; // multiply by z to make some kind of 3d lighting...

    normal = normalize(normal);


    screen.xy += -normal.xy*2.5;

    screen.xy += 0.5*vec2(-0.5, 0.5);

    float dist = clamp(dot(screen.rg, screen.rg), 0.01, 10000.0);
    dist = pow(dist, 0.750)*40.50;
    screen.rgb = vec3(pow(1.0/(dist+1.01), 2.0))*g_lightAmount;
    //screen.g *= 1.30;

//    screen2.rgb *= screen2.rgb;

    screen.rgb *= screen.rgb;

    screen.rgb += screen2.rgb/(0.10+10.050*len)*1.15;

   // screen.rgb += vec3(0.0, 0.05, 0.10); // *alffa;

   // screen.rgb = vec3(0.0);

    screen.rgb += 1.0*texture2D(texOverlay, uvS+normal.xy*g_bumpStrength*0.08).rgb;


    screen.rgb = clamp(screen.rgb, 0.0, 100.0);
   //  screen.rgb = vec3(so.rrr*0.1);

   // screen.rgb = spreadSpec3(screen.rgb, alffa);

    // bg.rgb = vec3(0.0);

    //float alffa = clamp(so.r, 0.0, 1.0);
    screen.rgb = screen.rgb*alffa*1.0 + bg.rgb*(1.0-alffa)*g_bgAmount;

   // screen.rgb = bg.rgb;
   // screen.rgb = bg.rgb;
   // screen.rgb = so.rgb*1.0;
    // screen.rgb = so.rgb*0.2;

    screen.a = 1.0;

    frag = screen;
    //normal.z *= 2.0;
    //normal = normalize(normal);
    alffa = clamp(so.b*1.0, 0.0, 1.0);

    normal = (viewInvMatrix*vec4(normal, 0.0)).xyz;

    frag2 = vec4(0.0, normal.rg, alffa);
}

