#version 430

layout(binding=0) uniform sampler2D texColor;
layout(binding=1) uniform sampler2D texDepthNorm;
layout(binding=2) uniform sampler2D texPos;

in vec4 posG;
in vec3 normalG;
in vec3 normalWSG;
in vec2 uvG;
in vec3 tangentG;
in vec4 posSS;
in vec4 posW;
in vec4 posInst;

layout(location = 0) out vec4 frag;
layout(location = 1) out vec4 frag2;

layout(binding=0, offset=0) uniform atomic_uint ac;

layout(binding=0, r32ui) uniform uimage2D headPointers;
layout(binding=1, r32ui) uniform uimage2D nextPointers;
layout(binding=2, rgba16f) uniform image2D pixelListColors;
layout(binding=3, rgba32f) uniform image2D pixelListDepthNorm;

// layout(location = 0) out uvec4 uex_colour;
// layout(location = 1) out vec4 ex_colour;

uniform float g_time;

uniform float g_uvOfsX = 0.0;
uniform float g_uvScale = 1.0;

uniform float g_texBrightness = 1.0;

#define PI 3.1415926

vec2 latlong(vec3 v) {
  v = normalize(v);
  float theta = acos(v.z); // +z is up
  float phi = atan(v.y, v.x) + PI;
  return vec2(phi, theta)*vec2(.1591549, .6366198);
}


uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelViewInvMatrix;

uniform mat4 projectionInvMatrix;

uniform mat4 viewMatrix;


vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec3 rotateXY3(vec3 p, float a) {
  return rotateXY(vec4(p, 0.0), a).xyz;
}


// google glsl rand gave this, thanks and credit flies to
// http://stackoverflow.com/questions/4200224/random-noise-functions-for-glsl
float rand(vec2 co){
return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

uniform float g_windowWidth=1280.0;
uniform float g_windowHeight=720.0;

uniform float zNear = 0.1;
uniform float zFar = 1000.0;
// convert from 0.0 to 1.0 depth sample ds to linear depth
float linearDepth(float ds) {
    ds = 2.0*ds-1.0;
    float zLinear = 2.0*zNear*zFar/(zFar+zNear-ds*(zFar-zNear));
    return zLinear;
}


void main() {

  vec3 normal = normalG;
  vec2 uv = uvG;
  vec3 tangent = tangentG;
  // vec3 color = colorG;
 //projectionMatrix
  // vec4 perse = 1.0*viewMatrix*vec4(0.0, 0.0, 0.0, 1.0);
  //perse /= perse.w;

  vec3 mposInst = posInst.xyz; // /posInst.w;
  vec3 lightCen = mposInst.xyz*1.0;
 // lightCen.xyz /= lightCen.w;

  vec2 scrUV = vec2(gl_FragCoord.x/g_windowWidth, gl_FragCoord.y/g_windowHeight);

  vec3 surfPos = texture2D(texPos, scrUV).rgb;
  // surfPos /= surfPos.w;
  vec3 surfDepthNorm = texture2D(texDepthNorm, scrUV).rgb;

  vec3 surfLight = surfPos.rgb-lightCen;
  float dd = dot(surfLight,surfLight);

  frag.rgb = vec3(10.0/(dd*dd*2.0+0.01));

 // frag.rgb = surfPos;
  frag.a = 1.0;


//  vec4 cc = texture2D(texDepthNorm, scrUV);
//  vec4 ray = vec4((vec2(gl_FragCoord.x/g_windowWidth, gl_FragCoord.y/g_windowHeight)-vec2(0.5,0.5))*2.0, cc.r, 1.0); // *linearDepth(cc.r);
//  //ray.y = ray.y*-1.0;
//  //ray.x *= 16.0/9.0;
//  ray = projectionInvMatrix*ray;
//  ray /= ray.w;

//  //ray = normalize(ray);

////  normal.z = 1.0*clamp(sqrt(clamp(1.0-dot(normal.xy, normal.xy), 0.0, 1.0)), 0.0, 1.0);

//  vec3 norm = vec3(cc.gb, sqrt(1.0-dot(cc.gb, cc.gb)));
//  norm = normalize(norm);

//  vec3 ld = ray.xyz-lightCen.xyz;

//   float dist = dot(ld, ld);


//   // float dd = clamp(dot(ld.xyz, norm), 0.0, 1000.0);
//   ld = normalize(ld);
//   float dd = clamp(dot(-norm, ld), 0.0, 1000.0);


// // float dd = 1.0/(sqrt(dot(ld, ld))+0.01);
////   dd = pow(dd*2.2, 0.50);
//  // vec3 color = posSS.rgb*0.20;
//   dist = pow(dist, 1.0);
//   float kkk = 1.0/(dist*1.0+1.10);
//   kkk = pow(kkk, 1.0)*2.0;
// // frag = vec4(vec3(dd)*0.030*0.0+vec3(1.0), 1.0)*kkk;

//     //frag.rgb = vec3(ray.rgb)*0.1;
//   frag.rgb = vec3(kkk)*1.1;
  // frag.rgb = lightCen.rgb;
 // frag.rgb = (ray.rgb*1.0-lightCen.xyz*1.0)*0.50;

  // frag.rgb = texture2D(texPos, scrUV).rgb;

//  kk = pow(kk*0.001, vec4(0.30));
 //  frag.rgb = kk.rgb*10.0;
  frag2 = vec4(0.0, 0.0, 0.0, 0.0);


}

