import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

Group {
    id: partSim
    property string name: "partSim"
    property string forceName: "partSim"
    property string simShader: "simPart"
    property string drawShader: "partWater"
    property string drawBlendMode: "add"
    property int gridDimension: 600
    property int drawNumPoints: 100*100
    property bool drawEnabled: true

    property real partSize: 0.50

    property string partEmitShapeImage: "../../images/adapt_logo2_full.png"

    property int particleCount: advanceSim.particleCount

    signal particleCountTo(int pc)

    Blit {
        textureRT: "screenBuffer"
    }

    Texture {
        textureUnit: 0
        textureItem: particleTexture
        Image {
            id: particleTexture
            source: "../../images/particles_64_2048.png"
        }
    }

    Texture {
        textureUnit: 1
        textureItem: particleNoise
        Image {
            id: particleNoise
            visible: false
            source: "../../images/random16.png"
        }
    }

    Texture {
        textureUnit: 2
        textureItem: particleEmitShape
        Image {
            id: particleEmitShape
            visible: false
            source: partEmitShapeImage

        }
    }

    Texture {
        textureUnit: 3
        textureRT: "depth"
    }

    //    Texture {
    //        textureUnit: 2
    //        textureRT: "screenBuffer"
    //    }

//    Texture {
//        textureUnit: 3
//        textureItem: particleEnv
//        Image {
//            id: particleEnv
//            visible: false
//            source: "../../images/Bright-roof-multi.jpg"
//        }
//    }


    // --------------------------------------
    // ADVANCE PARTICLE SIMULATIONS
    // --------------------------------------

    property string shaderVaryings: "
        vec3 posG;
        vec2 uvG;
        vec3 velG;
        float ageG;
        float recG;
        float ageSplitG;
        vec4 posInitG;"
       // vec3 posScrG;"


    Shader {
        file: sceneDir+simShader
        tfVaryings: shaderVaryings
    }


    DrawVB {
        id: advanceSim
        enabled: true
        type: "pointGrid"
        vboId: sceneName+name

        property real resetOn: sync(partSim.name+".reset")

        onResetOnChanged: {
            if (resetOn > 0.5) {
                reset = 1.0;
                resetParticles();
            } else {
                reset = 0.0;
            }
        }

        onParticleCountChanged: {
            // console.log("jorma particle count:"+particleCount);
            particleCountTo(particleCount);
        }


        tfVaryings: shaderVaryings

        gridWidth: partSim.gridDimension
        gridHeight: partSim.gridDimension
        drawNumPoints: partSim.drawNumPoints

        depthTest: false
        depthWrite: false
        ShaderParam {
            paramName: "g_gridDim"
            paramValue: partSim.gridDimension
        }
//        ShaderParam {
//            paramName: "g_rotOrigin"
//            paramValue: sync(partSim.name+".rotOrigin")
//        }

        ShaderParam {
            paramName: "g_velDamping"
            paramValue: sync(partSim.name+".velDamping")
        }

//        ShaderParam {
//            paramName: "g_emitShape"
//            paramValue: sync(partSim.name+".emitShape")
//        }

        ShaderParam {
            paramName: "g_noiseScale"
            paramValueVec4: sync(partSim.forceName+".noiseScale.x")+","+sync(partSim.forceName+".noiseScale.y")+","+sync(partSim.forceName+".noiseScale.z")
        }
        ShaderParam {
            paramName: "g_noiseOfs"
            paramValueVec4: sync(partSim.name+".dirForce.x")+","+sync(partSim.name+".dirForce.y")+","+sync(partSim.name+".dirForce.z")
        }

        ShaderParam {
            paramName: "g_force"
            paramValue: sync(partSim.forceName+".force")
        }
        ShaderParam {
            paramName: "g_noiseFreq"
            paramValue: sync(partSim.forceName+".noiseFreq")
        }
        ShaderParam {
            paramName: "g_speed"
            paramValue: sync(partSim.forceName+".speed")
        }

//        ShaderParam {
//            paramName: "g_initShapeX"
//            paramValue: sync(partSim.name+".initShapeX")
//        }
//        ShaderParam {
//            paramName: "g_initShapeY"
//            paramValue: sync(partSim.name+".initShapeY")
//        }
        ShaderParam {
            paramName: "g_maxAge"
            paramValue: sync(partSim.name+".maxAge")
        }
//        ShaderParam {
//            paramName: "g_initPosX"
//            paramValue: sync(partSim.name+".initPosX")
//        }
//        ShaderParam {
//            paramName: "g_initPosY"
//            paramValue: sync(partSim.name+".initPosY")
//        }
//        ShaderParam {
//            paramName: "g_initPosZ"
//            paramValue: sync(partSim.name+".initPosZ")
//        }

        ShaderParam { paramName: "g_elasticity"; paramValue: sync(partSim.name+".elasticity") }

    }


    // --------------------------------------
    // RENDER PARTICLES
    // --------------------------------------
    Shader {
        file: sceneDir+drawShader
    }
    DrawVB {
        enabled: drawEnabled
        type: "pointGridDraw"
        property string name: partSim.name
        vboId: sceneName+name
        depthTest: true
        depthWrite: false

       // blendMode: "normal"
        blendMode: drawBlendMode
       // blendMode: "off"

        tfVaryings: shaderVaryings
        gridWidth: partSim.gridDimension
        gridHeight: partSim.gridDimension
        drawNumPoints: partSim.drawNumPoints

//        ShaderParam {
//            paramName: "g_pikselos"
//            paramValue: sync("pikselos")
//        }
        ShaderParam {
            paramName: "g_partSize"
            paramValue: partSize
        }
//        ShaderParam {
//            paramName: "g_partMapX"
//            paramValue: sync(partSim.name+".partMapX")
//        }
//        ShaderParam {
//            paramName: "g_partMapY"
//            paramValue: sync(partSim.name+".partMapY")
//        }

        drawBuffers: 2
    }

    Shader {
        file: sceneDir+"partDepthOnly"
    }
    DrawVB { // depth only draw
        enabled: drawEnabled
        type: "pointGridDraw"
        property string name: partSim.name
        vboId: sceneName+name
        depthTest: true
        depthWrite: true
       // blendMode: "normal"
        blendMode: "add"
       // blendMode: "off"
        tfVaryings: shaderVaryings
        gridWidth: partSim.gridDimension
        gridHeight: partSim.gridDimension
        drawNumPoints: partSim.drawNumPoints
        ShaderParam {
            paramName: "g_partSize"
            paramValue: partSize
        }
        drawBuffers: 1
    }

//    DrawVB {
//        enabled: false
//        type: "pointGridDraw"
//        property string name: partSim.name
//        vboId: sceneName+name
//        depthTest: true
//        depthWrite: true

//        blendMode: "add"
//       // blendMode: "add"

//        tfVaryings: shaderVaryings
//        gridWidth: partSim.gridDimension
//        gridHeight: partSim.gridDimension
//        drawNumPoints: partSim.drawNumPoints

////        ShaderParam {
////            paramName: "g_pikselos"
////            paramValue: sync("pikselos")
////        }
//        ShaderParam {
//            paramName: "g_partSize"
//            paramValue: partSize
//        }
////        ShaderParam {
////            paramName: "g_partMapX"
////            paramValue: sync(partSim.name+".partMapX")
////        }
////        ShaderParam {
////            paramName: "g_partMapY"
////            paramValue: sync(partSim.name+".partMapY")
////        }
//    }
}
