import QtQuick 2.3
import QtGraphicalEffects 1.0
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene {
    //property bool bDebugTexts: true
    property bool bDebugTexts: false

    Camera {
        property string name: "camera"
        x: sync(name + ".x")
        y: sync(name + ".y")
        z: sync(name + ".z")
        lookAtX: sync(name + ".lookAtX")
        lookAtY: sync(name + ".lookAtY")
        lookAtZ: sync(name + ".lookAtZ")
        upX: sync("camera.upX")
        upY: sync("camera.upY")
        upZ: sync("camera.upZ")
        yawLA: sync("camera.yawLA")
        pitchLA: sync("camera.pitchLA")
    }

    property real t: rocket.time
    Timer {
        interval: 5
        running: true
        repeat: true
        onTriggered: {
            t = rocket.time;
        }
    }

    property string shaderVaryings: "
            vec3 posG;
            vec2 uvG;
            vec3 velG;
            float ageG;
            float recG;
            float ageSplitG;
            vec4 posInitG;"



    TextureImage {
        textureUnit: 1
        file: "../../images/_SK57414_normal.png"
    }
    Texture {
        textureUnit: 2
        textureItem: kuvasEnv
        Image {
            id: kuvasEnv
            visible: false
            source: "../../images/area_lights.jpg"
        }
    }

    Texture {
        textureUnit: 3
        //file: "../../images/StarDust1.jpg"
        //file: "../../images/aalto.png"
        // file: "../../images/PinkMedusa.png"
        // textureRT: "prev"
        textureRT: "prev"
    }
    Texture {
        textureUnit: 4
        textureRT: "prevBlur"
        textureWrap: "repeat"
    }

    TextureImage {
        textureUnit: 0
        //file: "../../images/_SK57414.png"
        //file: (sync("bgTexture") === 0) ? "../../images/PinkMedusa.png" : "../../images/noiseb1.png"
        //file: "../../images/gas4.png"
        //file: "../../images/meteor_b.png"
        //file: "../../images/laatta.png"
        file: "../../images/PinkMedusa_black.png"
    }
    Shader { file: "smLuola" }
    DrawMesh {
        Clear { cR: 0.00; cG: 0.00; cB: 0.00; cD: 1.0; }
        property string name: "mesh2"
        //  file: "mesh/Drill002.dae"
       // file: "mesh/halli.obj"
        file: "mesh/ball5000.x"
        //file: "mesh/400x400.obj"
        //file: "mesh/Cave.dae"
        Pos { x: 0.0; y: -10.0; z: 0.0; }
        //  Rot { d: 180; ax: 1.0; ay: 0.0; az: 0.0 }
        Sca { s: 990.0; x: 1.0; y: 1.0; z: 1.0 }
        ShaderParam { paramName: "g_uvScale"; paramValue: 2.0}
        ShaderParam { paramName: "g_texBrightness"; paramValue: 0.3 }
        ShaderParam { paramName: "g_prevAmount"; paramValue: 0.00 }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: 0.0*sync("prevBlurFeed") }
        blendMode: "off"
        depthTest: true
        depthWrite: false
    }


    TextureImage {
        textureUnit: 0
        //file: "../../images/tiny_rocks2.png"
        //file: "../../images/lione3.png"
       //  file: "../../images/planet_ice.png"
        //file: "../../images/kivitex1s.png"
        file: "../../images/gas1.png"
    }
    TextureImage {
        textureUnit: 1
       // file: "../../images/tiny_rocks2.png"
        file: "../../images/scratch1.png"
        //file: "../../images/lione3.png"
        // file: "../../images/kivitex1s.png"
    }
    Shader { file: "smPlastic" }

    property real zoomAmount: sync("zoomAmount")
    property real zoomPerLevel: sync("zoomPerLevel")

    Repeater {
        model: 11
        delegate:
            DrawMesh {
            // enabled: false
            //  Clear { cR: 0.0; cG: 0.0; cB: 0.0; }
            property string name: "meshZoom"
            // file: "mesh/puppet.dae"
           // file: "mesh/puppet_jump.dae"
            file: index == 10 ? "mesh/zoomer/Puppet_Dead.dae" : "mesh/zoomer/Puppet_Give.dae"
            // file: "mesh/kolkkus.x"
            Pos { x: index == 10 ? 0.0 : 0.0; y: index == 10 ? 1.0 : 1.0; z: index == 10 ? 0.0 : 0.0; }
            Rot { d: -90; ax: 1.0; ay: 0.0; az: 0.0 }
            property real zoom: Math.max(0.0, Math.pow(0.1, (index+zoomAmount)+1.0))*100.0;
            Sca { s: zoom*1.0; x: 1.0; y: 1.0; z: 1.0 }

            /// Zoom center here!
            Pos { x: sync("zoomCenter.x")+(index==10 ? sync("zoomDead.x") : 0.0); y: sync("zoomCenter.y") +(index==10 ? sync("zoomDead.y"):0.0); z: sync("zoomCenter.z")+ (index==10 ? sync("zoomDead.z"):0.0); }
            ShaderParam { paramName: "g_uvScale"; paramValue: 0.010*11-0.01*index}
            ShaderParam { paramName: "g_texBrightness"; paramValue: 0.065 }
            ShaderParam { paramName: "g_prevAmount"; paramValue: 0.00 }
            ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurFeed") }
            blendMode: "normal"
            depthTest: true
            depthWrite: true

//            smoothNormals: true
//            flipNormals: true

            SavePoint {
                target: "cen"
                x: 0.0; y: 0.0; z: 0.0;
            }
        }
    }

    DustPartikles {
        id: dp
        name: "dustPart"
        // emitMesh: "mesh/ea_cube.obj"
        // emitMesh: "mesh/kolkkus.x"
        emitMesh: "mesh/poinzos2.lwo"
        drawBlendMode: "add"
        partTexture: "../../images/particles_64_2048.png"
    }

    property int totalParticleCount: dp.particleCount // + wp2.particleCount

    onTotalParticleCountChanged: {
        particleCountText.text = "dust particles: "+totalParticleCount
    }


    // depth & normals for lights & reflections
    Blit { textureRT: "depth"; blitRT: 1; }
    Blit { textureRT: "pos"; blitRT: 2; }


    /// From this point on, these "postprocs" should be pretty same for each skene,
    /// enabled from rocket if needed/used...

    Reflect { }
    Group {
        enabled: sync("prevBlurStore.ON")
        /// Previous frame blur feedback lights'n'magix
        Blit { textureRT: "prev" }
        Blur { enabled: sync("prevBlurStore.ON"); textureWrap: "clamp" }
        Blit { textureRT: "prevBlur" }
        Texture {
            textureUnit: 0
            textureRT: "prev"
        }
        Shader {
            file: "drawRt"
        }
        DrawVB {
            type: "quad"
            depthTest: false
            depthWrite: false
            ShaderParam {
                paramName: "flip"
                paramValue: 1.0
            }
            blendMode: "off"
        }

    }
    GodRay {
        godRayX: getSavePointX2D("cen")
        godRayY: getSavePointY2D("cen")
    }
    Tonemap { }
    Glow { }
    Vignette { }

    Blit { textureRT: "frame_B_zoomering"; blitRT: 0; }

    DrawOverlayAdd {
        property string name: "ovl_A_some"
        enabled: sync(name+".ON")
        overlayScale: sync(name+".scale")
        overlayAlpha: sync(name+".alpha")
        posX: sync(name+".posX")
        posY: sync(name+".posY")
        textureRT: "frame_A_some"
        flip: false
    }

    Shader { file: "smCoords" }
    Coords { }

    Item {
        visible: bDebugTexts
        enabled: bDebugTexts
        id: infoText
        layer.enabled: true
        width: 1280
        height: 720
        FastBlur {
            anchors.fill: texts
            source: texts
            radius: 32
        }
        Item {
            opacity: 1.0
            id: texts
            anchors.fill: parent
            Column {
                anchors.bottom: parent.bottom
                anchors.left: parent.left
                ShadowText {
                    id: particleCountText
                    text:"particleCount: 0"
                    // pixelSize: 32
                }
            }
        }
    }
    DrawRT {
        visible: bDebugTexts
        enabled: bDebugTexts
        textureItem: infoText
        flip: false
    }

}
