#version 430



vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}

layout(triangles) in;
layout(triangle_strip, max_vertices = 3) out;
//layout(line_strip, max_vertices = 15) out;

in vec3 normal[3];
in vec2 uv[3];
in vec3 tangent[3];
in vec4 origPos[3];
in vec3 instPos[3];

in vec3 instVel[3];
in float instAge[3];
in float instRec[3];

out vec4 posG;
out vec3 normalG;
out vec3 normalWSG;
out vec2 uvG;
out vec3 tangentG;
out vec4 colorG;
out vec4 posW;


uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 viewMatrix;

uniform float g_time;

uniform float windowWidth;
uniform float windowHeight;

uniform float furLength = 1.0;

// uniform float makkara;

layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texNorm;
layout(binding=2) uniform sampler2D texEnv;
layout(binding=3) uniform sampler2D texPrevFrame;
layout(binding=4) uniform sampler2D texDepth;

uniform float zNear = 0.1;
uniform float zFar = 1000.0;
// convert from 0.0 to 1.0 depth sample ds to linear depth
float linearDepth(float ds) {
    ds = 2.0*ds-1.0;
    float zLinear = 2.0*zNear*zFar/(zFar+zNear-ds*(zFar-zNear));
    return zLinear;
}

float atanSafe(float y, float x) {
 float ret=0.0;
        if (x!=0.0) {
                if (x>0.0) {
                        ret=atan(y/x);
                } else	{
                        ret=atan(y/x)+3.141592;
                }
        } else {
                if (y>=0.0) {
                        ret=0.5*3.141592;
                } else {
                        ret=-0.5*3.141592;
                }
        }
 return ret;
}

void main(void) {

        vec3 controlBase = vec3(0.0);

        float times = g_time*0.1;
       vec3 faceNormal = vec3(0.0);
        vec4 facePos = vec4(0.0);

        float rotAngle = atanSafe(instVel[0].y,instVel[0].x)+0.50*3.141592;

        mat4 mvp = projectionMatrix * modelViewMatrix;


        for (int i = 0; i < gl_in.length(); ++i) {
                gl_Position = gl_in[i].gl_Position; // -vec4(1.5, 0.0, 0.0, 0.0);
                gl_Position.xyz -= normal[i]*0.0;
                facePos += origPos[i];
        //	gl_Position.xyz -= normal[i]*1.5;

               // gl_Position = rotateXY(gl_Position, rotAngle);

                posW = gl_Position;
                vec4 pos4 = vec4(gl_Position);
                // pos4.w = 1.0;

                gl_Position = modelViewMatrix*gl_Position + viewMatrix*vec4(instPos[i], 1.0);


                vec4 posScreen = projectionMatrix*gl_Position;
                vec2 scrTexPos = (posScreen.xy/posScreen.w*0.5+vec2(0.5, 0.5));
                float da = posScreen.z/posScreen.w;
                vec4 dd = texture2D(texDepth, scrTexPos);
                float ddo = dd.r;
                da = linearDepth(da);
                dd.r = linearDepth(dd.r);

                vec3 ssNormal = vec3(dd.gb, 0.0);
                ssNormal.z = sqrt(1.0-dot(ssNormal.xy, ssNormal.xy));
                // uniform mat4 projectionInvMatrix;
                // uniform mat4 modelViewInvMatrix;
                ssNormal = normalize(ssNormal);

                float depu = (1.0-smoothstep(0.0, 12.0, -(da-dd.r)));
                depu = pow(depu, 2.0);
                gl_Position.z -= (da-dd.r)*depu*0.0;

                gl_Position = modelViewMatrix*(vec4(posW.xyz+ssNormal.xyz*depu*0.0, posW.w)) + viewMatrix*vec4(instPos[i], 1.0);
                //gl_Position.xyz += ;


                normalG = normal[i];
                normalG = (modelViewMatrix * vec4(normalG, 0.0)).xyz;
               // normalG += depu*1.0;
                gl_Position.xyz += normalG.xyz*depu*1.50*0.0;
                gl_Position.z += depu*3.0*0.0;


                //gl_Position.z += depu*0.0;
                gl_Position = projectionMatrix*gl_Position;


               // colorG = vec3(scrTexPos, 1.0);//vec3(1.90, 0.92, 0.9925)*5.0;

                normalWSG = normalG;
                posG = gl_Position;
             //   controlG = controlBase;
             //   controlG.r = 0.1;
                faceNormal += normal[i];
                uvG = uv[i];
                tangentG = tangent[i];
                EmitVertex();
        }
        facePos /= 3.0;

        EndPrimitive();



//        float makkara = furLength*clamp(0.50+1.50*sin(g_time*0.4), 0.0, 1.0)*0.1+0.01;


//        float times = g_time*0.1;
//       vec3 faceNormal = vec3(0.0);
//        vec4 facePos = vec4(0.0);
//        for (int i = 0; i < gl_in.length(); ++i) {
//                gl_Position = gl_in[i].gl_Position; // -vec4(1.5, 0.0, 0.0, 0.0);
//                facePos += origPos[i];
//                posW = gl_Position;
//        //	gl_Position.xyz -= normal[i]*1.5;
//                gl_Position = projectionMatrix * modelViewMatrix * gl_Position +  projectionMatrix*viewMatrix*vec4(instPos[i], 1.0);
//                normalG = normal[i];
//                colorG = vec3(0.10, 0.2, 0.25);
//                normalG = (modelViewMatrix * vec4(normalG, 0.0)).xyz;
//                normalWSG = normalG;
//                posG = gl_Position;
//                faceNormal += normal[i];
//                uvG = uv[i];
//                tangentG = tangent[i];
//         //        EmitVertex();
//        }
//        facePos /= 3.0;

//         EndPrimitive();

//        vec4 inp = facePos;
//        // vec4 inp = ;
//        float lim = -0.50;
//        float why = 1.0*pow((clamp(sin((inp.y*0.1350-fract(inp.y*0.0350))+times*0.2)*1.0, lim, 1.0)-lim)/(1.0-lim),10.0);
//        for (int i = 0; i < gl_in.length(); ++i) {
//                vec4 inp = gl_in[i].gl_Position;
//    //	why = 1.50*pow((clamp(sin((inp.y*0.10)+g_time*0.4)*1.0, lim, 1.0)-lim)/(1.0-lim),5.0);
//                // float lim = 0.75;
//                 float why = 0.50*pow((clamp(sin(inp.y*2.825+g_time*1.15)*1.0, lim, 1.0)-lim)/(1.0-lim),0.50);

//                gl_Position = gl_in[i].gl_Position+vec4(faceNormal*0.80*why, 0.0);
//                posW = gl_Position;
//              //  gl_Position = gl_in[i].gl_Position+vec4(normal[i]*0.020*why, 0.0);
//               // gl_Position.xz += (faceNormal.xz*why*0.30);
//                gl_Position = rotateXZ(gl_Position, why*0.10);
//         //       gl_Position.xyz += (normal[i].xyz*why*12.0);
//    //	gl_Position.xz += (normal[i].xz*why*32.0);
//                // gl_Position = gl_Position*(1.0-why)+1.0*origPos[i]*why;
//                gl_Position = projectionMatrix * modelViewMatrix * gl_Position +  projectionMatrix*viewMatrix*vec4(instPos[i], 1.0);
//                normalG = normal[i];
//                colorG = 2.0*vec3(0.40, 0.30, 0.420)*(1.0-why*0.0)+vec3(1.1,1.81,0.31)*why*0.0;
//                normalG = (modelViewMatrix * vec4(normalG, 0.0)).xyz;
//                normalWSG = normalG;
//                uvG = uv[i];
//                tangentG = tangent[i];
//                posG = gl_Position;
//               EmitVertex();
//        }
//        EndPrimitive();

//        makkara = 0.10;

//       vec4 vertTex = texture2D(tex, uv[0]);

//        int ii=0;
//        vec4 posAccu = gl_in[0].gl_Position;
//        float velDown = 0.20;
//        float velAccu = 0.0;

//        float karvaPituus = vertTex.g;

//        float karvaFreq = 0.8;

//        karvaPituus = 0.0+0.0*clamp((karvaPituus-(1.0-karvaFreq))/karvaFreq, 0.0, 1.0);

//        makkara = karvaPituus*12.91;

//        // int karvaPituusI = 16*karvaPituus;

//        for (int i = 0; i < karvaPituus*16*2; ++i) {

//                gl_Position = posAccu;
//                if (ii==1) {
//                  gl_Position += vec4(0.005, 0.005, 0.0, 0.0);
//                }
//                if (ii==1) {
//                  velAccu += velDown;
//                  velDown -= 1.125;
//                  posAccu += vec4(faceNormal, 0.0)*0.150*why*makkara-origPos[0]*1.1*0.1;
//                  posAccu += vec4(0.0, 1.0, 0.0, 0.0)*0.03*velAccu;
//                }

//                 posW = gl_Position;

//             //  gl_Position.xyz -= normal[i].xyz*2.0;

////            gl_Position = gl_in[i].gl_Position;
//////            //gl_Position.xyz -= normal[i].xyz*12.0*why;
////          //  gl_Position += rotateXZ(origPos[i], why*5.0);
////            gl_Position.xyz -= faceNormal*1.0*why;

//                gl_Position = projectionMatrix * modelViewMatrix * gl_Position + projectionMatrix*viewMatrix*vec4(instPos[i], 1.0);
//                normalG = normal[0];
//                colorG = mix(vec3(0.150, 0.150, 0.50),vec3(1.5,0.91,0.91), why*0.2)*0.20;
//                normalG = (modelViewMatrix * vec4(normalG, 0.0)).xyz;
//                normalWSG = normalG;
//                uvG = uv[0];
//                tangentG = tangent[0];
//                posG = gl_Position;

//                ii++;
//                if (ii>1) {
//                    ii=0;
//                }
//                EmitVertex();
//        }
//        EndPrimitive();


}
