import QtQuick 2.3
import QtGraphicalEffects 1.0
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene {
    //property bool bDebugTexts: true
    property bool bDebugTexts: false

    Camera {
        property string name: "camera"
        x: sync(name + ".x")
        y: sync(name + ".y")
        z: sync(name + ".z")
        lookAtX: sync(name + ".lookAtX")
        lookAtY: sync(name + ".lookAtY")
        lookAtZ: sync(name + ".lookAtZ")
        upX: sync("camera.upX")
        upY: sync("camera.upY")
        upZ: sync("camera.upZ")
        yawLA: sync("camera.yawLA")
        pitchLA: sync("camera.pitchLA")
    }

    property real t: rocket.time
    Timer {
        interval: 5
        running: true
        repeat: true
        onTriggered: {
            t = rocket.time;
        }
    }

    property string shaderVaryings: "
            vec3 posG;
            vec2 uvG;
            vec3 velG;
            float ageG;
            float recG;
            float ageSplitG;
            vec4 posInitG;"



    TextureImage {
        textureUnit: 1
        // file: "../../images/_SK57414_normal.png"
        file:"../../images/scratch1.png"
    }
    Texture {
        textureUnit: 2
        textureItem: kuvasEnv
        Image {
            id: kuvasEnv
            visible: false
            source: "../../images/area_lights.jpg"
        }
    }

    Texture {
        textureUnit: 3
        //file: "../../images/StarDust1.jpg"
        //file: "../../images/aalto.png"
        // file: "../../images/PinkMedusa.png"
        // textureRT: "prev"
        textureRT: "prev"
    }
    Texture {
        textureUnit: 4
        textureRT: "prevBlur"
        textureWrap: "repeat"
    }

// TAUSTA
    TextureImage {
        textureUnit: 0
        //file: "../../images/_SK57414.png"
        //file: (sync("bgTexture") === 0) ? "../../images/PinkMedusa.png" : "../../images/noiseb1.png"
        //file: "../../images/noiseb1.png"
        // file: "../../images/siniku.png"
        file: "../../images/area_lights.jpg"

    }
    // Shader { file: "smLuola" }
    Shader { file: "smTunnel" }
    DrawMesh {
        Clear { cR: 0.0; cG: 0.0; cB: 0.0; }
        property string name: "mesh2"
        //  file: "mesh/Drill002.dae"
        //file: "mesh/halli.obj"
        //file: "mesh/parkki_halli.dae"
        file: "mesh/ball5000.x"
        //file: "mesh/400x400.obj"
        //file: "mesh/Cave.dae"
        Pos { x: 0.0; y: -1.50; z: 0.0; }
        Rot { d: 0; ax: 1.0; ay: 0.0; az: 0.0 }
        Sca { s: 320.0; x: 1.0; y: 1.0; z: 1.0 }
        ShaderParam { paramName: "g_uvScale"; paramValue: 1.0}
        ShaderParam { paramName: "g_texBrightness"; paramValue: 0.5 }
        ShaderParam { paramName: "g_prevAmount"; paramValue: 0.00 }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: 0.0 }
        blendMode: "off"
        depthTest: true
        depthWrite: true
        smoothNormals: true
        flipNormals: false
        normalSmoothAngle: 20
    }


// Teh parq-HALLI
    TextureImage {
        textureUnit: 0
        //file: "../../images/_SK57414.png"
        //file: (sync("bgTexture") === 0) ? "../../images/PinkMedusa.png" : "../../images/noiseb1.png"
        //file: "../../images/noiseb1.png"
        file: "../../images/kivitex1s.png"
    }
    Shader { file: "smLuola" }
    DrawMesh {
       // Clear { cR: 0.0; cG: 0.0; cB: 0.0; }
        property string name: "mesh2"
        //  file: "mesh/Drill002.dae"
        //file: "mesh/halli.obj"
        file: "mesh/parkki_halli.dae"
        //file: "mesh/ball5000.x"
        //file: "mesh/400x400.obj"
        //file: "mesh/Cave.dae"
        Pos { x: 0.0; y: -1.50; z: 0.0; }
        Rot { d: -90; ax: 1.0; ay: 0.0; az: 0.0 }
        Sca { s: 20.0; x: 1.0; y: 1.0; z: 1.0 }
        ShaderParam { paramName: "g_uvScale"; paramValue: 2.0}
        ShaderParam { paramName: "g_texBrightness"; paramValue: 0.1 }
        ShaderParam { paramName: "g_prevAmount"; paramValue: 0.00 }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: 1.0*sync("prevBlurFeed") }
        blendMode: "off"
        depthTest: true
        depthWrite: true
        smoothNormals: true
        flipNormals: false
        normalSmoothAngle: 20
    }


    DrawMesh {
        // Clear { cR: 0.0; cG: 0.0; cB: 0.0; }
        property string name: "mesh2"
        //  file: "mesh/Drill002.dae"
        //file: "mesh/halli.obj"
       // file: "mesh/OctahedonSolid.dae"
        file: "mesh/zen/IcosphereSolid.dae"
        //file: "mesh/ball5000.x"
        //file: "mesh/400x400.obj"
        //file: "mesh/Cave.dae"
        Pos { x: -5.0; y: 1.30; z: -3.0; }
        Rot { d: -90; ax: 1.0; ay: 0.0; az: 0.0 }
        Sca { s: 14.0; x: 1.0; y: 1.0; z: 1.0 }
        ShaderParam { paramName: "g_uvScale"; paramValue: 2.0}
        ShaderParam { paramName: "g_texBrightness"; paramValue: 0.1 }
        ShaderParam { paramName: "g_prevAmount"; paramValue: 0.00 }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: 1.0*sync("prevBlurFeed") }
        blendMode: "off"
        depthTest: true
        depthWrite: true
        smoothNormals: true
        flipNormals: true
        normalSmoothAngle: 20
    }



    TextureImage {
        textureUnit: 0
        file: "../../images/_SK57414.png"
        //file: "../../images/noiseb1.png"
        //file: "../../images/kivitex1s.png"
    }
    Shader { file: "smPlastic" }
    DrawMesh {
      //  Clear { cR: 0.0; cG: 0.0; cB: 0.0; }
        property string name: "meshZoom"
        file: "mesh/zen/Lotus_pose.dae"
        Pos { x: 0.0; y: -2.60; z: 0.0; }
        Rot { d: -90; ax: 1.0; ay: 0.0; az: 0.0 }
        Sca { s: 30.0; x: 1.0; y: 1.0; z: 1.0 }
        ShaderParam { paramName: "g_uvScale"; paramValue: 1.0}
        ShaderParam { paramName: "g_texBrightness"; paramValue: sync("puppet.bright") }
        ShaderParam { paramName: "g_prevNorm"; paramValue: sync("puppet.prevNorm") }
        ShaderParam { paramName: "g_prevAmount"; paramValue: 0.00 }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurFeed") }
        blendMode: "off"
        depthTest: true
        depthWrite: true

        SavePoint { target: "cen"; x: 0.0; y: 0.0; z: 0.0; }

    }

    DrawMesh {
      //  Clear { cR: 0.0; cG: 0.0; cB: 0.0; }
        property string name: "primitive_in_the_hand1"
        file: "mesh/zen/BoxFractal.dae"
        Pos { x: -2.50; y: 1.0; z: 1.50; }
        Rot { d: -45+time()*20.0; ax: 1.0; ay: 1.0; az: 0.0 }
        Sca { s: 3.0; x: 1.0; y: 1.0; z: 1.0 }
        ShaderParam { paramName: "g_uvScale"; paramValue: 1.0}
        ShaderParam { paramName: "g_texBrightness"; paramValue: 0.0150 }
        ShaderParam { paramName: "g_prevAmount"; paramValue: 0.00 }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurFeed") }
        blendMode: "off"
        depthTest: true
        depthWrite: true
        SavePoint { target: "cen"; x: 0.0; y: 0.0; z: 0.0; }
    }


    DrawMesh {
      //  Clear { cR: 0.0; cG: 0.0; cB: 0.0; }
        property string name: "primitive_in_the_hand1"
        file: "mesh/zen/DodecahedronWire.dae"
        Pos { x: 2.0; y: 1.0; z: 1.50; }
        Rot { d: -0-time()*20.0; ax: 1.0; ay: 1.0; az: 0.0 }
        Sca { s: 4.0; x: 1.0; y: 1.0; z: 1.0 }
        ShaderParam { paramName: "g_uvScale"; paramValue: 1.0}
        ShaderParam { paramName: "g_texBrightness"; paramValue: 0.0150 }
        ShaderParam { paramName: "g_prevAmount"; paramValue: 0.00 }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurFeed") }
        blendMode: "off"
        depthTest: true
        depthWrite: true
        SavePoint { target: "cen"; x: 0.0; y: 0.0; z: 0.0; }
    }

    Group {
        property string name: "emitWaterPart"
        enabled: sync("waterPart.ON")

        RenderTarget {
            RenderTargetLayer {
                textureRT: "emittedPartPos"
                format: "RGBA16F"
                width: 1280*maxEmitLayers
                height: 720*maxEmitLayers
            }
        }
        ShaderAtomicCounter { property string name: "sac1"; clear: true }
        Texture { textureUnit: 0; imageUnit: 0; textureRT: "emittedPartPos" }
        Shader { file: sceneDir+"smEmitter" }

        TextureImage {
            textureUnit: 0
            file: "../../images/gas1.png"
        }
        DrawMesh {
            property string name: "mesh2"
            //file: "mesh/ball5000.x"
            file: "mesh/kolkkus.x"
            //file: "mesh/cube.x"
            //file: "mesh/adaptlogo.obj"
            depthTest: true
            depthWrite: true
            blendMode: "off"

            // Shader params for particle emitting
            ShaderParam { paramName: "g_emitPercent"; paramValue: sync("waterPart.g_emitPercent"); }

            // Shader params for mesh surface
            ShaderParam { paramName: "g_uvScale"; paramValue: 0.20 }
            ShaderParam { paramName: "g_texBrightness"; paramValue: 0.0 }
            ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
            ShaderParam { paramName: "g_prevBlurAmount"; paramValue: 0.0 }

            //  property string num: index+1
            Pos { x: sync("waterPart.emitPosX"); y: sync("waterPart.emitPosY"); z: sync("waterPart.emitPosZ"); }
            Rot { d: 0.0; ax: 1.0; ay: 0.0; az: 0.0 }
            Sca { s: sync("waterPart.g_emitterSize"); x: 1.0; y: 1.0; z: 1.0 }
        }

        Shader { file: sceneDir+"smPlastic" }
        TextureImage {
            textureUnit: 0
            //file: "../../images/_SK57414.png"
            //file: "../../images/PinkMedusa.png"
            //file: "../../images/noiseb1.png"
            //file: "../../images/kivitex1s.png"
            file: "../../images/gas1.png"
        }

        TextureImage {
            textureUnit: 2
            //file: "../../images/_SK57414.png"
            //file: "../../images/PinkMedusa.png"
            //file: "../../images/noiseb1.png"
            //file: "../../images/kivitex1s.png"
            //file: "../../images/prismainsideA-7.jpg"
            file: "../../images/aalto.png"
        }

        Texture {
            textureUnit: 3
            //file: "../../images/StarDust1.jpg"
            //file: "../../images/aalto.png"
            // file: "../../images/PinkMedusa.png"
            // textureRT: "prev"
            textureRT: "prev"
        }
        Texture {
            textureUnit: 4
            textureRT: "prevBlur"
            textureWrap: "repeat"
        }

        DrawMesh {
           // enabled: false
            property string name: "mesh2"
            //  file: "mesh/Drill002.dae"
            // file: "mesh/halli.obj"
            file: "mesh/ball5000.x"
            //file: "mesh/400x400.obj"
            //file: "mesh/Cave.dae"
           Pos { x: sync("waterPart.emitPosX"); y: sync("waterPart.emitPosY"); z: sync("waterPart.emitPosZ"); }
            //  Rot { d: 180; ax: 1.0; ay: 0.0; az: 0.0 }
            Sca { s: 3.50*(1.0+sync("whiteBall.scaleMul")); x: 1.0; y: 1.0; z: 1.0 }
            ShaderParam { paramName: "g_uvScale"; paramValue: 0.50}
            ShaderParam { paramName: "g_texBrightness"; paramValue: 0.002+sync("whiteBall.texBright") }
            ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
            ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurFeed") }
            ShaderParam { paramName: "g_writeCollisionDepth"; paramValue: 0.0 }
            blendMode: "normal"
            depthTest: true
            depthWrite: true
        }
    }

    property int totalParticleCount: wp.particleCount // + wp2.particleCount

    onTotalParticleCountChanged: {
        particleCountText.text = "particles: "+totalParticleCount
    }

    /// Deferred instanced light draw starts here
    Blit { textureRT: "depth"; blitRT: 1; }
    Blit { textureRT: "pos"; blitRT: 2; }

    Texture { textureUnit: 0; textureRT: "color" }
    Texture { textureUnit: 1; textureRT: "depth" }
    Texture { textureUnit: 2; textureRT: "pos" }
    Shader { file: "smDeferredInst" }
    DrawMesh {
        enabled: sync("defLights.ON");
        property string name: "lightMesh"
        //file: "mesh/cube.x"
        file: "mesh/LowPolyPallo.lwo"
        //file: "mesh/kolkkus.x"
        //file: "mesh/aivob.x"
        //file: "mesh/rinkula.obj"
        //file: "mesh/seitti.x"
        //file: "mesh/hand1b.x"
        //file: "mesh/pillarman.obj"
        depthTest: false
        depthWrite: false
        blendMode: "add"
        instanceVBO: sceneName+wp.name
        instanceCount: Math.min(totalParticleCount, 2000)
        tfVaryings: shaderVaryings
        cull: true
        cullBack: false
        drawBuffers: 1 // draw only to the primary color buffer
        Pos { x: 0.0; y: 0.0; z: 0.0; }
        Sca { s: 1.0; }
    }

    //  Blit { textureRT: "depth"; blitRT: 1; }


    ShaderAtomicCounter { property string name: "sac1" }
    Texture { textureUnit: 0; imageUnit: 0; textureRT: "emittedPartPos" }
    WaterPartikles { id: wp; name: "waterPart"; drawEnabled: sync(name+".drawEnabled") }


    DustPartikles {
        id: dp
        name: "dustPart"
        // emitMesh: "mesh/ea_cube.obj"
        // emitMesh: "mesh/kolkkus.x"
        emitMesh: "mesh/poinzos2.lwo"
        drawBlendMode: "normal"
        partTexture: "../../images/particles_64_2048.png"
       // partTexture: "../../images/partik.png"
    }




    Blit { // depth & normals for lights & reflections
        textureRT: "depth"
        blitRT: 1
    }

    /// From this point on, these "postprocs" should be pretty same for each skene,
    /// enabled from rocket if needed/used...

    Reflect { }
    Group {
        enabled: sync("prevBlurStore.ON")
        /// Previous frame blur feedback lights'n'magix
        Blit { textureRT: "prev" }
        Blur { enabled: sync("prevBlurStore.ON"); textureWrap: "clamp" }
        Blit { textureRT: "prevBlur" }
        Texture {
            textureUnit: 0
            textureRT: "prev"
        }
        Shader {
            file: "drawRt"
        }
        DrawVB {
            type: "quad"
            depthTest: false
            depthWrite: false
            ShaderParam {
                paramName: "flip"
                paramValue: 1.0
            }
            blendMode: "off"
        }

    }
    GodRay {
        godRayX: getSavePointX2D("cen")
        godRayY: getSavePointY2D("cen")
    }
    Tonemap { }
    Glow { }
    Vignette { }

    Blit { textureRT: "frame_E_lightwaves"; blitRT: 0; }

    DrawOverlayMul {
        property string name: "ovl_C_credits"
        enabled: sync(name+".ON")
        overlayScale: sync(name+".scale")
        overlayAlpha: sync(name+".alpha")
        posX: sync(name+".posX")
        posY: sync(name+".posY")
        textureRT: "frame_D_diver"
        flip: false
    }


    Shader { file: "smCoords" }
    Coords { }

    Item {
        visible: bDebugTexts
        enabled: bDebugTexts
        id: infoText
        layer.enabled: true
        width: 1280
        height: 720
        FastBlur {
            anchors.fill: texts
            source: texts
            radius: 32
        }
        Item {
            opacity: 1.0
            id: texts
            anchors.fill: parent
            Column {
                anchors.bottom: parent.bottom
                anchors.left: parent.left
                ShadowText {
                    id: particleCountText
                    text:"particleCount: 0"
                    // pixelSize: 32
                }
            }
        }
    }
    DrawRT {
        visible: bDebugTexts
        enabled: bDebugTexts
        textureItem: infoText
        flip: false
    }

}
