import QtQuick 2.4
import QtGraphicalEffects 1.0
import "./_SharedQML"
import AdaptDemoSystem 1.0

import QtQuick.Window 2.2


RocketDemo {
    id: demo

    focus: true

    signal fileMissing(string fName, string sName)


    onFirstDemoRender: {
        console.log("YES first demo rendered now!!!");
        ackFirstDemoRender();
    }

    anchors.fill: parent


//    DebugInfoOverDemo {
//    }

    property string windowText

    Component {
        id: kurko
        Window {
            width: 300
            height: 250
            visible: true

            Text {
                anchors.fill: parent
                text: demo.windowText
                font.pixelSize: 15
                wrapMode: Text.WordWrap
                verticalAlignment: Text.AlignVCenter
                horizontalAlignment: Text.AlignHCenter
            }
        }
    }

//    Window {
//        width: 200
//        height: 200
//        visible: true
//    }

    Loader {
        id: windowLoader

    }

    onFileNotFound: {
        console.log("QML Skene received file not found:"+fileName+" skene:"+skeneName);

        demo.windowText = "<b>ERROR!!!!</b><br><br>QML Skene received file not found.<br><br>File:"+fileName+"<br>skene:"+skeneName;

        windowLoader.sourceComponent = kurko;
        fileMissing(fileName, skeneName);
    }

    onFrameRendered: {
        demo.clearResetParticles();
        //console.log("no ny tee poika resetti");
    }



}
