import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0


Group {
    id: cubeSurfer

    property int uniqueId: getUniqueId()
    property string myUid: ""
    property string uid: mesh+"_uid"+myUid+uniqueId.toString()


    property string mesh: "credits_de3.lwo"
    property string surfMesh: "box1m.lwo"
    property real posX: 0.0
    property real posY: 0.0
    property real posZ: 0.0
    property real cenX: -0.1
    property real cenY: -0.1
    property real sca: 1.0
    property real rot: 0.0

    property int maxInstanceCount: 2000

    property real emitMeshScale: 1.0
    property real emitMeshScaleZ: 1.0

    property real origUvScale: 1.0
    property real origGenUvs: 1.0
    property string origTexture: "../../images/noiseb1.png"

    property string surfCubeTexture: "../../images/gas4.png"
    property real surfCubeUvSca: 0.20

    property string name: "surfCubesInst"
    enabled: sync(name+".ON")

    // Begin draw pixel emitters
    property int maxEmitLayers: 2

    property real surfEmitDiv: Math.max(sync("surfEmit.div"), 1.0)
    property real surfEmitDiv2: Math.max(sync("surfEmit.div2"), 1.0)


    property string shaderVaryings: "
            vec3 posG;
            vec2 uvG;
            vec3 velG;
            float ageG;
            float recG;
            float ageSplitG;
            vec4 posInitG;"



    RenderTarget {
        RenderTargetLayer {
            textureRT: "emittedCubesPos"
            format: "RGBA16F"
            width: windowWidth*maxEmitLayers
            height: windowHeight*maxEmitLayers
        }
    }
    RenderTarget {
        RenderTargetLayer {
            textureRT: "emittedCubesNormal"
            format: "RGBA16F"
            width: windowWidth*maxEmitLayers
            height: windowHeight*maxEmitLayers
        }
    }
    RenderTarget {
        RenderTargetLayer {
            textureRT: "emittedCubesVar" // size, etc..
            format: "RGBA16F"
            width: windowWidth*maxEmitLayers
            height: windowHeight*maxEmitLayers
        }
    }


    ShaderAtomicCounter { property string name: "sacCubes"+uid; clear: true }
    Texture { textureUnit: 0; imageUnit: 0; textureRT: "emittedCubesPos" }
    Texture { textureUnit: 0; imageUnit: 1; textureRT: "emittedCubesNormal" }
    Texture { textureUnit: 0; imageUnit: 2; textureRT: "emittedCubesVar" }
    TextureImage {
        textureUnit: 0
        //file: "../../images/aalto.png"
        //file: "../../images/kivitex1s.png"
        file: "../../images/zeppo.png"
    }


    TextureImage {
        textureUnit: 1
        file: "../../images/_SK57414_normal.png"
    }


    Texture {
        textureUnit: 3
        //file: "../../images/StarDust1.jpg"
        //file: "../../images/aalto.png"
        // file: "../../images/PinkMedusa.png"
        // textureRT: "prev"
        textureRT: "prev"
    }
    Texture {
        textureUnit: 4
        textureRT: "prevBlur"
        textureWrap: "repeat"
    }
    TextureImage {
        textureUnit: 0
        //file: "../../images/_SK57414.png"
        //file: (sync("bgTexture") === 0) ? "../../images/PinkMedusa.png" : "../../images/noiseb1.png"
        file: origTexture
        //file: "../../images/kivitex1s.png"
    }
    Texture {
        textureUnit: 4
        textureRT: "prevBlur"
        textureWrap: "repeat"
    }


    Shader { file: "smCubeSurfEmit" }

    DrawMesh {
        // Clear { cR: 0.0; cG: 0.0; cB: 0.0 }
        property string name: "mesh2"
        file: "mesh/"+mesh
        //   file: "mesh/kolkkus.x"

        smoothNormals: true
        flipNormals: false

        depthTest: true
        depthWrite: true
        blendMode: "normal"

        ShaderParam { paramName: "g_uvScale"; paramValue: origUvScale }
        ShaderParam { paramName: "g_genUvs"; paramValue: origGenUvs }
        ShaderParam { paramName: "g_texBrightness"; paramValue: sync("surfEmit.texBright") }
        ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("surfEmit.prevBlur") }
        ShaderParam { paramName: "g_prevNorm"; paramValue: sync("surfEmit.prevNorm") }
        ShaderParam { paramName: "g_cubesDiv"; paramValue: surfEmitDiv }
        ShaderParam { paramName: "g_spread"; paramValue: sync("surfEmit.spread") }
        ShaderParam { paramName: "g_worldPos"; paramValue: 1.0 }
        ShaderParam { paramName: "g_drawSurf"; paramValue: sync("surfEmit.drawSurf") }
        ShaderParam { paramName: "g_alpha"; paramValue: sync("surfEmit.alpha") }
        //            ShaderParam { paramName: "g_stretch"; paramValue: sync("surfEmit.surfStretch") }

        Pos { x: 0+posX; y: 2.30+posY; z: -1.50+posZ; }
        Rot { d: rot; ax: 1.0; ay: 0.0; az: 0.0; }
        Sca { s: 40.0*sca; x: 1.0; y: 1.0; z: 1.0 }

        // change center point
        Pos { x: cenX; y: cenY; z: 0.0; }

    }

    //        RenderTarget {
    //            RenderTargetLayer {
    //                textureRT: "emittedCubesPos2"
    //                format: "RGBA16F"
    //                width: 1280*maxEmitLayers
    //                height: 720*maxEmitLayers
    //            }
    //        }
    //        RenderTarget {
    //            RenderTargetLayer {
    //                textureRT: "emittedCubesNormal2"
    //                format: "RGBA16F"
    //                width: 1280*maxEmitLayers
    //                height: 720*maxEmitLayers
    //            }
    //        }
    //        RenderTarget {
    //            RenderTargetLayer {
    //                textureRT: "emittedCubesVar2"
    //                format: "RGBA16F"
    //                width: 1280*maxEmitLayers
    //                height: 720*maxEmitLayers
    //            }
    //        }

    //        Texture { textureUnit: 0; imageUnit: 0; textureRT: "emittedCubesPos" }
    //        Texture { textureUnit: 0; imageUnit: 1; textureRT: "emittedCubesNormal" }
    //        Texture { textureUnit: 0; imageUnit: 2; textureRT: "emittedCubesVar" }

    //        Texture { textureUnit: 0; imageUnit: 3; textureRT: "emittedCubesPos2" }
    //        Texture { textureUnit: 0; imageUnit: 4; textureRT: "emittedCubesNormal2" }
    //        Texture { textureUnit: 0; imageUnit: 5; textureRT: "emittedCubesVar2" }

    ShaderAtomicCounter { property string name: "sacCubes"+uid; clear: false }
    ShaderAtomicCounter { property string name: "sacCubes2"+uid; clear: true; bind: 1 }
    Shader { file: "smSurfInst" }
    TextureImage {
        textureUnit: 0
        //file: "../../images/laatta.png"
        //file: "../../images/meteor.png"
        file: surfCubeTexture
    }


    DrawVB { // actually don't draw, just generate the vbo for instanced drawing below..
        enabled: true
        type: "pointGrid"
        vboId: sceneName+"_surfCubes"

        //            property real resetOn: sync(partSim.name+".reset")

        //            onResetOnChanged: {
        //                if (resetOn > 0.5) {
        //                    reset = 1.0;
        //                    resetParticles();
        //                } else {
        //                    reset = 0.0;
        //                }
        //            }

        //            onParticleCountChanged: {
        //                // console.log("jorma particle count:"+particleCount);
        //                particleCountTo(particleCount);
        //            }


        tfVaryings: shaderVaryings

        gridWidth: 200
        gridHeight: 200
        drawNumPoints: 1
    }

    // Texture { textureUnit: 0; imageUnit: 0; textureRT: "emittedPartPos" }
    DrawMesh {
        enabled: sync("surfEmit.size") > 0.0
        property string name: "mesh333"
        //file: "mesh/cube.x"
        //file: "mesh/ball5000.x"
        // file: "mesh/kolkkus.x"
        //file: "mesh/aivob.x"
        //file: "mesh/seitti.x"
        //file: "mesh/hand1b.x"
        //file: "mesh/pillarman.obj"
        //file: "mesh/lootikhe2.lwo"
        file: "mesh/" + surfMesh
        //file: "mesh/rinkula.obj"
        //file: "mesh/LowPolyPallo.lwo"
        depthTest: true
        depthWrite: true
        blendMode: "normal"
        instanceVBO: sceneName+"_surfCubes"
        instanceCount: maxInstanceCount
        tfVaryings: shaderVaryings

        ShaderParam { paramName: "g_uvScale"; paramValue: surfCubeUvSca }
        ShaderParam { paramName: "g_texBrightness"; paramValue: sync("surfCubes.texBright") }
        ShaderParam { paramName: "g_emitNew"; paramValue: 0.0 }
        ShaderParam { paramName: "g_instLayer"; paramValue: 0.0 }
        ShaderParam { paramName: "g_worldPos"; paramValue: 1.0 }

        ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: 0.0 }

        ShaderParam { paramName: "g_spread"; paramValue: sync("surfEmit.spread2") }
        ShaderParam { paramName: "g_cubesDiv"; paramValue: surfEmitDiv2 }

        property real surfEmitSpread: sync("surfEmit.spread")

        Pos { x: sync("surfEmit.ofsX"); y: sync("surfEmit.ofsY"); z: sync("surfEmit.ofsZ"); }
        // Sca { s: 0.50; x: 5.0; y: 5.0; z: 0.3 }
        //Sca { s: 1.0*surfEmitDiv/12.0; }
        //Sca { s: 0.50*surfEmitDiv/12.0*(1.0/(parent.surfEmitSpread*0.01+0.50)); x: 0.50; y: 0.50; z: 27.05;}
        Sca { s: emitMeshScale*0.30*sync("surfEmit.size")*surfEmitDiv/12.0*(1.0/(parent.surfEmitSpread*0.01+0.50)); x: 1.0; y: 1.0; z: emitMeshScaleZ*sync("surfEmit.scaleZ");}
        // Rot { d: 0.0; ax: 0.0; ay: 1.0; az: 0.0 }
    }

    //        // 2nd set of cubes over the first ones
    //            Texture { textureUnit: 0; imageUnit: 0; textureRT: "emittedCubesPos" }
    //            Texture { textureUnit: 0; imageUnit: 1; textureRT: "emittedCubesNormal" }
    //            Texture { textureUnit: 0; imageUnit: 2; textureRT: "emittedCubesVar" }
    //            ShaderAtomicCounter { property string name: "sacCubes2"; clear: false; bind: 0 }
    //            Shader { file: sceneDir+"smSurfInst" }
    //            TextureImage {
    //                textureUnit: 0
    //                //file: "../../images/aalto.png"
    //                file: "../../images/kivitex1s.png"
    //                //file: "../../images/PinkMedusaB.png"
    //            }
    //            // Texture { textureUnit: 0; imageUnit: 0; textureRT: "emittedPartPos" }
    //            DrawMesh {
    //                //property string name: "mesh444"
    //                //file: "mesh/cube.x"
    //                //file: "mesh/ball5000.x"
    //                //file: "mesh/kolkkus.x"
    //                //file: "mesh/aivob.x"
    //                //file: "mesh/seitti.x"
    //                //file: "mesh/hand1b.x"
    //                //file: "mesh/pillarman.obj"
    //                //file: "mesh/lootikhe2.lwo"
    //             //   file: "mesh/box1m.lwo"
    //                file: "mesh/rinkula.obj"
    //                depthTest: true
    //                depthWrite: true
    //                blendMode: "normal"
    //                instanceVBO: sceneName+wp.name
    //                instanceCount: 16000
    //                tfVaryings: shaderVaryings

    //                ShaderParam { paramName: "g_uvScale"; paramValue: 0.020 }
    //                ShaderParam { paramName: "g_texBrightness"; paramValue: 0.20 }
    //                ShaderParam { paramName: "g_emitNew"; paramValue: 0.0 }
    //                ShaderParam { paramName: "g_instLayer"; paramValue: 1.0 }

    //                ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
    //                ShaderParam { paramName: "g_prevBlurAmount"; paramValue: 0.70 }


    //                 Pos { x: 0.0; y: 0.0; z: -9.0; }
    //                //Sca { s: 0.250; x: 2.0; y: 1.0; z: 1.0 }
    //                Sca { s: 0.50; x: 1.0; y: 1.0; z: 64.0 }
    //                // Rot { d: 0.0; ax: 0.0; ay: 1.0; az: 0.0 }
    //            }


}



