import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    property string name: "godray"
    effectName: "GodRay"
    enabled: sync(name+".ON")


    property real godRayX: 0.0
    property real godRayY: 0.0

    Blit {
        textureRT: "screenBuffer"
        blitRT: 0
    }
    Blit {
        textureRT: "godRays"
        blitRT: 1
    }
    Texture {
        textureUnit: 0
        textureRT: "screenBuffer"
    }
    Texture {
        textureUnit: 1
        textureRT: "godRays"
    }
    Shader {
        file: "godray"
        ShaderParam {
            paramName: "rayX"; paramValue: sync(name+".x")+godRayX
        }
        ShaderParam {
            paramName: "rayY"; paramValue: sync(name+".y")+godRayY
        }
        ShaderParam {
            paramName: "g_rotCenterX"; paramValue: sync(name+".x")+godRayX
        }
        ShaderParam {
            paramName: "g_rotCenterY"; paramValue: sync(name+".y")+godRayY
        }

        ShaderParam {
            paramName: "lightZ"
            paramValue: sync(name+".lightZ")+1.0
        }
        ShaderParam {
            paramName: "g_intensity"
            paramValue: sync(name+".intensity")
        }
        ShaderParam {
            paramName: "g_origAmount"
            paramValue: sync(name+".origAmount")
        }
        ShaderParam {
            paramName: "g_specRounds"
            paramValue: sync(name+".specRounds")
        }
        ShaderParam {
            paramName: "g_specOfs"
            paramValue: sync(name+".specOfs")
        }
        ShaderParam {
            paramName: "g_specWeight"
            paramValue: sync(name+".specWeight")
        }
        ShaderParam {
            paramName: "g_length"
            paramValue: sync(name+".length")
        }
        ShaderParam {
            paramName: "g_loops"
            paramValue: sync(name+".loops")
        }
        ShaderParam {
            paramName: "g_rotateAmp"
            paramValue: sync(name+".rotateAmp")
        }
        ShaderParam {
            paramName: "g_rotatePrim"
            paramValue: sync(name+".rotatePrim")
        }
        ShaderParam {
            paramName: "g_rotateSinAmp"
            paramValue: sync(name+".rotateSinAmp")
        }
        ShaderParam {
            paramName: "g_rotateSinFreq"
            paramValue: sync(name+".rotateSinFreq")
        }
        ShaderParam { paramName: "g_rotateMove"; paramValue: sync(name+".rotateMove") }
        ShaderParam { paramName: "g_rotateBrightMove"; paramValue: sync(name+".rotateBrightMove") }
        ShaderParam { paramName: "g_rotateBrightFreq"; paramValue: sync(name+".rotateBrightFreq") }
        ShaderParam { paramName: "g_rotateDist"; paramValue: sync(name+".rotateDist")+0.5 }
        ShaderParam { paramName: "g_timeRot"; paramValue: sync(name+".timeRot")+0.0 }
        ShaderParam { paramName: "g_timeBrightRot"; paramValue: sync(name+".timeBrightRot")+0.0 }

        ShaderParam { paramName: "g_screenSize"; paramValue: sync(name+".screenSize") }

    }
    DrawVB {
        type: "quad"
        depthTest: false
        depthWrite: false
        blendMode: "off"
    }
    Blit {
        textureRT: "godRaysResult"
        blitRT: 0
    }


    // mix original and result

    Shader {
        file: "fx/_SharedQML/glow"
    }
    Texture {
        textureUnit: 0
        textureRT: "screenBuffer"
    }
    Texture {
        textureUnit: 1
        textureRT: "godRaysResult"
    }
    DrawVB {
        ShaderParam {
            paramName: "flip"
            paramValue: 0.0
        }
        ShaderParam {
            paramName: "overlayAlpha"
            paramValue: 1.0
        }

        ShaderParam {
            paramName: "g_origAmount"
            paramValue: sync(name+".origAmount")
        }
        ShaderParam { paramName: "g_overlayScale"; paramValue: sync(name+".screenSize") }
        type: "quad"
        depthTest: false
        depthWrite: false
        blendMode: "off"
        drawBuffers: 1
    }

}

