import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0


// Renders one deferred light to the skene
// Assumes "depth" and "pos" textures exist
Group {
    id: light
    property string name: "light"
    enabled: sync(name+".ON")

    Texture { textureUnit: 0; textureRT: "color" }
    Texture { textureUnit: 1; textureRT: "depth" }
    Texture { textureUnit: 2; textureRT: "pos" }
    Shader { file: sceneDir+"smDeferred" }
    DrawMesh {
        property string name: "lightMesh"
        file: "mesh/LowPolyPallo.lwo"
        depthWrite: false
        blendMode: "add"
        instanceVBO: sceneName+wp.name
        instanceCount: totalParticleCount
        tfVaryings: shaderVaryings
        cull: true
        cullBack: false
        drawBuffers: 1 // draw only to the primary color buffer
        Pos { x: 0.0; y: 0.0; z: 0.0; }
        Sca { s: 1.0; }
    }

}
