#version 430

layout(binding=0) uniform sampler2D texScreen;
layout(binding=1) uniform sampler2D texOverlay;

in vec2 uv;

layout(location = 0) out vec4 frag;
layout(location = 1) out vec4 frag2;

uniform float g_time;
/*
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

vec3 tonemapUC2(vec3 x) {
    float A = 0.15;
    float B = 0.50;
    float C = 0.10;
    float D = 0.20;
    float E = 0.02;
    float F = 0.30;
    return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;
}
*/


uniform float flip=1.0;

uniform float overlayAlpha=1.0;

uniform float g_posX = 0.0;
uniform float g_posY = 0.0;

uniform float g_overlayScale = 1.0;

uniform float g_alphaFromColor = 1.0;

void main() {

    vec2 uvS = uv;
    if (flip > 0.5) {
        uvS.y = 1.0-uvS.y;
    }
    vec2 uvO = uvS+vec2(g_posX, g_posY);

    uvO -= vec2(0.5, 0.5)*1.0;
    uvO *= g_overlayScale;
    uvO += vec2(0.5, 0.5)*1.0;

    vec4 screen = texture2D(texScreen, uvS*1.0+vec2(0.0, 0.0));
    vec4 color = texture2D(texOverlay, uvO);

  //  screen.rgb*=screen.rgb;
  //  color.rgb*=color.rgb;


    float alfs = color.a;

    if (g_alphaFromColor > 0.5) {
        alfs = clamp(color.r+color.g+color.b, 0.0, 10.0);
    }

    alfs = clamp((alfs-2.0)*2.0, 0.0, 1.0);

    float alpha = alfs;


//    color *= screen*alpha;
//    color += (1.0-alpha)*screen;

    //color = color*1.0;

    color = mix(color, screen*overlayAlpha+color*(1.0-overlayAlpha), alpha);

  //  color.rgb = pow(color.rgb, vec3(0.5));


    color.a = 1.0;

    frag = color;
	frag2 = vec4(0.0, 0.0, 0.0, 0.0);
}

