_G.clearColor = { red = 0, green = 0, blue = 0.1 }

time = 0

local model = {
	layer = "3d",
	uniforms = {
		directionalLight = { 1, 1, 0 },
		intensity = 0.7,
		ambientLight = 0.5,
	}
}

local getPosition = function(channel)
	local time = time * 20
	local t = time - math.floor(time)
	local pixel0 = resources.getColorFromTexture("perlin_noise", math.abs(time) % (512 * 512), channel) / 255 * 250 - 125
	local pixel1 = resources.getColorFromTexture("perlin_noise", math.abs(time + 1) % (512 * 512), channel) / 255 * 250 - 125
	return _G.lerp(pixel0, pixel1, t)
end

renderTextureTargets = {
	effect1 = { width = config.width, height = config.height },
	effect2 = { width = config.width, height = config.height },
}

_G.world = {
	{
		texture = "light",
		layer = "rays1",
		x = function() return getPosition(0) end, 
		y = function() return getPosition(1) end, 
		scale = 5,
	},
	{
		texture = "effect1",
		fs = "radial_blur",
		layer = "rays2",
		uniforms = {
			source = { function() return getPosition(0) / config.width + 0.5 end, function() return getPosition(1) / config.height + 0.5 end }, --uniform vec2 source;
			decay = 2, --uniform float decay;
			samples = 10, --uniform float samples;
			density = 0.1,
		},
	},
	{ instance{model, model = "sphere", layer = "mask", uniforms_ambientLight = 0, uniforms_intensity = 0, scale = 0.6 } },
	{ camera = { layer = "rays1", target = "effect1" } },
	{ camera = { fov = 65, layer = "mask", target = "effect1" }, z = 9 },
	{ camera = { layer = "rays2" } },
}