#version 120
varying vec2 uv;

uniform sampler2D textureSampler;
uniform sampler2D perlinTextureSampler;
uniform vec4 color;
uniform float perlinStrength;
uniform float time;
uniform float radiusOffsetFactor;
uniform float angleOffsetFactor;
uniform float timeAngleFactor;
uniform float width;
uniform float height;
uniform float suckInFactor;
uniform float suckInOffset;

void main() {
 	vec2 uvCentered = uv - vec2(0.5,0.5);
 	float radius = length(uvCentered);
 	radius = pow(radius + suckInOffset, 1.0/suckInFactor) - suckInOffset;
 	float angle = atan(uvCentered.y, uvCentered.x);
 	float perlinOffset = (texture2D(perlinTextureSampler, vec2(angle / 3.14159 * angleOffsetFactor + radius * radiusOffsetFactor, time * timeAngleFactor * 2)).r - 0.5) * perlinStrength;
 	radius += perlinOffset;
 	vec2 uvModified = uv;
	uvModified.x = radius * cos(angle) + 0.5;
	uvModified.y = radius * sin(angle) + 0.5;
//	uvModified = uvModified * + vec2(0.5, 0.5);
	//vec4 texColor0 = vec4(1.0, 1.0, 1.0, 1.0) * texture2D(textureSampler, uvModified).a;
	vec4 texColor0 = texture2D(textureSampler, uvModified);
	float depth = gl_FragCoord.z / gl_FragCoord.w;
	float a = color.a - depth / 13.0;
	texColor0 = vec4(texColor0.rgb * color.rgb * a, texColor0.a * color.a * a);
	//vec4 texColor1 = vec4(1.0, 1.0, 1.0, 1.0) * texture2D(textureSampler, vec2(uvModified.x + 4.0/width, uvModified.y + 4.0/height)).a;
	//vec4 texColor = vec4(0.0, 0.0, 0.0, abs(texColor0.a - texColor1.a));
	//vec4 texColor = vec4(0.0, 0.0, 0.0, abs(texColor0.a - texColor1.a));

	gl_FragColor = texColor0;

}