#version 120
varying vec2 uv;

uniform float spread;
uniform float strength;
uniform float height;
uniform sampler2D textureSampler;
uniform sampler2D depthTextureSampler;

void main() {
	float samples = 5.0;
	vec4 texColor = texture2D(textureSampler, uv).rgba / samples;// * 0.2270270270;
	float spread = min(1.0, spread * texture2D(depthTextureSampler, uv).r);
	texColor = texColor + texture2D(textureSampler, uv - vec2(0, 2/height * spread)) / samples;// * 0.1945945946;
	texColor = texColor + texture2D(textureSampler, uv - vec2(0, 1/height * spread)) / samples;// * 0.0540540541;
	texColor = texColor + texture2D(textureSampler, uv + vec2(0, 1/height * spread)) / samples;// * 0.0540540541;
	texColor = texColor + texture2D(textureSampler, uv + vec2(0, 2/height * spread)) / samples;// * 0.1945945946;
	texColor = texColor * strength;
	gl_FragColor = texColor;
}