#version 120
varying vec2 uv;

uniform float texelSize;
uniform sampler2D p; // Pressure
uniform sampler2D w; // Velocity

void main()
{
  float pL = texture2D(p, uv - vec2(texelSize, 0)).x;
  float pR = texture2D(p, uv + vec2(texelSize, 0)).x;
  float pB = texture2D(p, uv - vec2(0, texelSize)).x;
  float pT = texture2D(p, uv + vec2(0, texelSize)).x;

  vec4 uNew = texture2D(w, uv);
  uNew.xy -= 0.5 * vec2(pR - pL, pT - pB);
  gl_FragColor = uNew;
}
